%
% Runs the multiclass experiments for faces and cars
% (see README and the paper)
%

clear;

load results/roth_alternative2_10fold folds all_positives all_negatives...
    all_pos_idx all_neg_idx;

car_stuff = [];
car_stuff.folds = folds;
car_stuff.all_positives = all_positives;
car_stuff.all_negatives = all_negatives;
car_stuff.all_pos_idx   = all_pos_idx;
car_stuff.all_neg_idx   = all_neg_idx;

load results/faces_alternative3_10fold folds all_positives all_negatives...
    all_pos_idx all_neg_idx;

face_stuff = [];
face_stuff.folds = folds;
face_stuff.all_positives = all_positives;
face_stuff.all_negatives = all_negatives;
face_stuff.all_pos_idx   = all_pos_idx;
face_stuff.all_neg_idx   = all_neg_idx;

n_folds = size(folds,2); % Both should have 10 folds anyway...
master_folds = [];
for current_fold = 1:n_folds,
  
  % Extract the car test data for this fold..
  pos_idx_test = setdiff(car_stuff.all_pos_idx,car_stuff.folds(current_fold).pos_idx);
  neg_idx_test = setdiff(car_stuff.all_neg_idx,car_stuff.folds(current_fold).neg_idx);
  car_pos = car_stuff.all_positives(:,:,pos_idx_test);
  car_neg = car_stuff.all_negatives(:,:,neg_idx_test);
  
  % Extract the face test data for this fold..
  pos_idx_test = setdiff(face_stuff.all_pos_idx,face_stuff.folds(current_fold).pos_idx);
  neg_idx_test = setdiff(face_stuff.all_neg_idx,face_stuff.folds(current_fold).neg_idx);
  face_pos = face_stuff.all_positives(:,:,pos_idx_test);
  face_neg = face_stuff.all_negatives(:,:,neg_idx_test);
  
  % Lets use the following code: 1=car,2=face,0=neither,666=undecidable
  test_images  = car_pos;
  test_images  = cat(3,car_pos,car_neg);
  test_answers = [ones(size(car_pos,3),1); zeros(size(car_neg,3),1)];
  test_images  = cat(3,test_images,face_pos);
  test_answers = cat(1,test_answers,2*ones(size(face_pos,3),1));
  test_images  = cat(3,test_images,face_neg);
  test_answers = cat(1,test_answers,zeros(size(face_neg,3),1));
  predictions  = 0*test_answers;
  
  % Extract the machinery for this fold.
  car_svm_raw   = car_stuff.folds(current_fold).svm_raw;
  car_features  = car_stuff.folds(current_fold).saved_features;
  car_svm       = car_stuff.folds(current_fold).svm;
  face_svm_raw  = face_stuff.folds(current_fold).svm_raw;
  face_features = face_stuff.folds(current_fold).saved_features;
  face_svm      = face_stuff.folds(current_fold).svm;
  
  % savepoint matlab.mat;
  
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
  % Main system:
  n_fast_decision  = 0;
  n_slow_decision  = 0;
  n_slow2_decision = 0;
  for k = 1:size(test_images,3),
    img    = test_images(:,:,k);
    
    [fast_pred_car,dv]  = predict_example_raw_svmF(car_svm_raw,img);
    if dv>car_svm_raw.neg_max & dv<car_svm_raw.pos_min,
      fast_pred_car = 0;
    end
    
    [fast_pred_face,dv] = predict_example_raw_svmF(face_svm_raw,img);
    if dv>face_svm_raw.neg_max & dv<face_svm_raw.pos_min,
      fast_pred_face = 0;
    end
    
    % Individual codes are {1,0,-1} = {yes,uncertain,no}.
    
    % Combine classifications.
    if fast_pred_car~=1 & fast_pred_face~=1,
      
      if fast_pred_car==-1 & fast_pred_face==-1,
	% Both say no..
	n_fast_decision = n_fast_decision + 1;
	predictions(k) = 0;
      elseif fast_pred_car==0 & fast_pred_face==0,
	% Both are uncertain - slowww.. X 2
	
	n_slow2_decision = n_slow2_decision + 1;
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	slow_pred_car  = predict_example_svmF(car_features,car_svm,img);
	slow_pred_face = predict_example_svmF(face_features,face_svm,img);
	
	if slow_pred_car~=1 & slow_pred_face~=1,
	  % Both say no..
	  predictions(k) = 0;
	elseif slow_pred_car==1 & slow_pred_face==1,
	  % Both say yes
	  predcitions(k) = 666; % Undecidable.
	else
	  % One says yes, the other says no..
	  if slow_pred_car==1,
	    predictions(k) = 1;
	  end
	  if slow_pred_face==1,
	    predictions(k) = 2;
	  end
	end
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      else
	% One is uncertain, the other says no..
	
	n_slow_decision = n_slow_decision + 1;
	if fast_pred_car==0,
	  % car uncertain, face certainly not...
	  slow_pred_car  = predict_example_svmF(car_features,car_svm,img);
	  if slow_pred_car==1,
	    predictions(k) = 1;
	  else
	    predictions(k) = 0;
	  end
	end
	if fast_pred_face==0,
	  % face uncertain, car certainly not...
	  slow_pred_face = predict_example_svmF(face_features,face_svm,img);
	  if slow_pred_face==1,
	    predictions(k) = 2;
	  else
	    predictions(k) = 0;
	  end
	end
      end
      
    elseif fast_pred_car==1 & fast_pred_face==1,
      
      n_fast_decision = n_fast_decision + 1;
      % Both are positive:
      predictions(k) = 666; % Marks undecidable..
    else
      
      n_fast_decision = n_fast_decision + 1;
      % The "clear cut cases". Exactly one is certain 1..
      if fast_pred_car==1,
	predictions(k) = 1;
      end
      if fast_pred_face==1,
	predictions(k) = 2;
      end
    end
  end
  
  frac_correct       = sum(predictions==test_answers)/size(predictions,1);
  frac_undecidable   = sum(predictions==666)/size(predictions,1);
  tmp = n_fast_decision + n_slow_decision + n_slow2_decision;
  frac_fast_decision  = n_fast_decision / tmp;
  frac_slow_decision  = n_slow_decision / tmp;
  frac_slow2_decision = n_slow2_decision / tmp;
  
  master_folds(current_fold).frac_correct = frac_correct;
  master_folds(current_fold).frac_undecidable = frac_undecidable;
  master_folds(current_fold).frac_fast_decision  = frac_fast_decision;
  master_folds(current_fold).frac_slow_decision  = frac_slow_decision;
  master_folds(current_fold).frac_slow2_decision = frac_slow2_decision;
  
  frac_correct
  frac_fast_decision
  frac_slow_decision
  frac_slow2_decision
  
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  % Baseline system:
  n_fast_decision  = 0;
  n_slow_decision  = 0;
  n_slow2_decision = 0;
  predictions  = 0*test_answers;
  
  for k = 1:size(test_images,3),
    img    = test_images(:,:,k);
    
    [fast_pred_car,dv]  = predict_example_raw_svmF(car_svm_raw,img);
    [fast_pred_face,dv] = predict_example_raw_svmF(face_svm_raw,img);
    
    if fast_pred_car==1 & fast_pred_face==1,
      % 1,1
      predictions(k) = 666;
    elseif fast_pred_car==-1 & fast_pred_face==-1,
      % -1,-1
      predictions(k) = 0;
    else
      % 1,-1
      if fast_pred_car==1,
	predictions(k) = 1;
      end
      if fast_pred_face==1,
	predictions(k) = 2;
      end
    end
  end
  
  frac_correct       = sum(predictions==test_answers)/size(predictions,1);
  frac_correct
  frac_undecidable   = sum(predictions==666)/size(predictions,1);
  master_folds(current_fold).frac_correct_raw = frac_correct;
  master_folds(current_fold).frac_undecidable_raw = frac_undecidable;
  
  save multi_test1 master_folds;
end

accs = zeros(size(master_folds,2),1);
for k=1:size(master_folds,2),
  accs(k) = master_folds(k).frac_correct;
end
m_acc = mean(accs);


% End.
