function pred = predict_example_svm(features,svm,img)
if isempty(features),
  pred = nan;
  return;
end
n_feat = size(features,2);
m_test = zeros(n_feat,1);
for i=1:n_feat,
  feature   = features(i).feature;
  m_test(i) = feval(feature.evaluator,feature.evaluator_params,img);
  m_test(i) = (m_test(i,:) >= feature.th);
end
[Label,DecisionValue] = SVMClass(m_test,svm.AlphaY,svm.SVs,svm.Bias,svm.Parameters,svm.nSV,svm.nLabel);
% Slow...
pred = Label;

% End.