function [pred,dv] = predict_example_svmF(features,svm,img)
% Faster..
if isempty(features),
  pred = nan;
  return;
end
n_feat = size(features,2);
m_test = zeros(n_feat,1);
for i=1:n_feat,
  feature   = features(i).feature;
  m_test(i) = feval(feature.evaluator,feature.evaluator_params,img);
  m_test(i) = (m_test(i,:) >= feature.th);
end

dv = sum(svm.w_map .* m_test) - svm.Bias;
if dv>0,
  pred = 1;
else
  pred = -1;
end

%[Label,DecisionValue] = SVMClass(m_test,svm.AlphaY,svm.SVs,svm.Bias,svm.Parameters,svm.nSV,svm.nLabel);
%pred = Label;

% End.