%
% A car dataset test with heavier blurring
%

clear;

load Seeds/Seed_one SeedState;
rand('state',SeedState); % Seed_one is the seed just after reset.

load datasets/carsL positives negatives;

% Mix them:
idx_perm  = randperm(size(positives,3));
positives = positives(:,:,idx_perm);
idx_perm  = randperm(size(negatives,3));
negatives = negatives(:,:,idx_perm);
clear idx_perm;


% Prepare n-fold cv:
n_folds = 10;
n_pos = size(positives,3);
n_neg = size(negatives,3);

pos_in_fold = floor(n_pos/n_folds);
neg_in_fold = floor(n_neg/n_folds);

n_pairs = min([n_pos n_neg]);
pos_in_fold = floor(n_pairs/n_folds);
neg_in_fold = floor(n_pairs/n_folds);

folds = [];
all_pos_idx = [];
all_neg_idx = [];
for k=1:n_folds,
   folds(k).pos_idx = ((k-1)*pos_in_fold+1):(k*pos_in_fold);
   all_pos_idx = union(all_pos_idx,folds(k).pos_idx);
   folds(k).neg_idx = ((k-1)*neg_in_fold+1):(k*neg_in_fold);
   all_neg_idx = union(all_neg_idx,folds(k).neg_idx);
   folds(k).train_stat     = [];
   folds(k).test_stat      = [];
   folds(k).saved_features = [];
   folds(k).W              = [];
   folds(k).theta          = [];
end
all_positives = positives(:,:,all_pos_idx);
all_negatives = negatives(:,:,all_neg_idx);

%all_positives = make_noise(all_positives);
%all_negatives = make_noise(all_negatives);

for current_fold=1:n_folds,
   
   fprintf(1,'\nFold %d starting..\n', current_fold);
   
   % Prepare to train:
   clear positives;
   clear negatives;
   positives = all_positives(:,:,folds(current_fold).pos_idx);
   negatives = all_negatives(:,:,folds(current_fold).neg_idx);
   
   fprintf(1,'\nThis training set has %d pos and %d neg examples.\n',size(positives,3),size(negatives,3));
   
   saved_features        = [];
   match_table_saved     = [];
   max_feature_pool_size = 50; 
   
   current_images = cat(3,positives,negatives);
   current_labels = [ones(size(positives,3),1); -ones(size(negatives,3),1)];
   [H,W] = size(current_images(:,:,1));
   
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   %%%%%%%%%%%%%%%%%%%%%%%%
   % Svm 1:
   addpath osu_svm;
   [ht,wt,n_images] = size(current_images);
   svm_data = zeros(ht*wt,n_images);
   svm_answers = zeros(1,n_images);
   for k = 1:n_images,
     tmp = current_images(:,:,k);
     % Blur:
     tmp = imfilter(tmp,fspecial('gaussian',[9 9],2));
     tmp = tmp(:);
     svm_data(:,k)  = tmp;
     svm_answers(k) = current_labels(k);
   end
   % Learn a baseline svm:
   [AlphaY,SVs,Bias,Parameters,nSV,nLabel] = LinearSVC(svm_data,svm_answers);
   % Remember the raw machine:
   svm_raw = [];
   svm_raw.AlphaY = AlphaY;
   svm_raw.SVs = SVs;
   svm_raw.Bias = Bias;
   svm_raw.Parameters = Parameters;
   svm_raw.nSV = nSV;
   svm_raw.nLabel = nLabel;
   
   %%%%%%%%%%%%%%%%%%%%%%%%
   % Find out key pixels:
   mapping = zeros(H,W);
   for i=1:H,
      for j=1:W,
         tmp = zeros(H,W);
         tmp(i,j) = 1;
         [pred,dv] = predict_example_raw_svm(svm_raw,tmp(:));
         mapping(i,j) = dv;
      end
   end
   mapping = mapping + svm_raw.Bias; % Remove the bias from each w(i,j)
   svm_raw.w_map = mapping;
   stuff = abs(mapping);
   list = -sort(-stuff(:));
   N_SEED = 60;   
   seed_loc = zeros(N_SEED,2);
   debug_stuff = 0*stuff;
   for i=1:size(seed_loc,1),
      tmp = (stuff==list(i));
      [I,J] = find(tmp);
      seed_loc(i,:) = [I J];
      debug_stuff(I,J) = 1;
   end
   figure(15); subplot(1,1,1); imshow(debug_stuff);
   % savepoint alt2
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % Find a safe margin for the linear machine:
   dv_pos = zeros(size(positives,3),1);
   for test_idx = 1:size(positives,3),
      tmp = positives(:,:,test_idx); 
      tmp = imfilter(tmp,fspecial('gaussian',[9 9],2));
      [pred,dv] = predict_example_raw_svm(svm_raw,tmp);
      dv_pos(test_idx) = dv;
   end
   dv_neg = zeros(size(negatives,3),1);
   for test_idx = 1:size(negatives,3),
      tmp = negatives(:,:,test_idx);
      tmp = imfilter(tmp,fspecial('gaussian',[9 9],2));
      [pred,dv] = predict_example_raw_svm(svm_raw,negatives(:,:,test_idx));
      dv_neg(test_idx) = dv;
   end
   tmp_sorted = -sort(-dv_pos);
   frac_point = round(size(tmp_sorted,1)/2);
   pos_min_dv = min(tmp_sorted(1:frac_point));
   tmp_sorted = sort(dv_neg);
   frac_point = round(size(tmp_sorted,1)/2);
   neg_max_dv = max(tmp_sorted(1:frac_point));
   svm_raw.pos_min = pos_min_dv;
   svm_raw.neg_max = neg_max_dv;
   
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % Savepoint
   
   current_features = extract_features_Lseed(current_images,current_labels,seed_loc);
   folds(current_fold).n_cand_features = size(current_features,2);
   fprintf(1,'\nThere are %d features\n',size(current_features,2));
   pause(1);
   match_table_current = compute_mtable_batch(current_features,current_images);
   fprintf(1,'\nMatch table ready..\n');  
   
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   par1 = size(current_features,2);
   gain_tables2(1,1).gain = spalloc(par1,par1,par1*par1);
   gain_tables2(1,1).marks= spalloc(par1,par1,par1*par1);
   
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   
   % 2: Growth..
   keep_going = 1;
   while keep_going,
      
      fprintf(1,'g');
      
      max_min_val = 0;
      max_min_idx = [];
      for i = 1:size(current_features,2),
         X_i = current_features(i).feature;
         % TH  = X_i.TH_range;
         
         [split_loc,okey] = generate_split(match_table_current(i,:),current_labels);
         
         th_idx = split_loc; % XXX: a hack
         X_i.th = split_loc;
         min_val = -inf;
         if okey,
            %for th_idx = 1:size(TH,2),
            %X_i.th  = TH(th_idx);
            min_val = inf;
            min_idx = [];
            X_i_occ = find(match_table_current(i,:)>=X_i.th);
            X_i_occ = X_i_occ(:);
            if size(saved_features,2)==0,
               min_val = measure_gain1c(X_i_occ,current_labels);
               min_idx = 0;
               % This thing is used only once.. The pool will have
               % 2+ features even if pruned...
               % => No need for table lookups..
            else
               for j = 1:size(saved_features,2),
                  X_j     = saved_features(j).feature;
                  % th_idx2 = X_j.th_idx;
                  if gain_tables2(1,1).marks(X_i.unique_id,X_j.unique_id)==1,
                     g = gain_tables2(1,1).gain(X_i.unique_id,X_j.unique_id);
                  else
                     X_j_occ = find(match_table_saved(j,:)>=X_j.th);
                     X_j_occ = X_j_occ(:);
                     g = measure_gain2c(X_i_occ,X_j_occ,current_labels);
                     gain_tables2(1,1).marks(X_i.unique_id,X_j.unique_id) = 1;
                     gain_tables2(1,1).gain(X_i.unique_id,X_j.unique_id) = g;
                  end
                  
                  if g < min_val,
                     min_val = g;
                     min_idx = j;
                  end
               end
            end
            % The worst opponent for i is now known (min_val,min_idx).
            % See if X_i has the least bad worst opponent:
            if min_val > max_min_val,
               % Best of the worst so far..
               max_min_val = min_val;
               max_min_idx = [i th_idx min_idx];
            end
         end
      end
      
      if max_min_val>0,
         % Something useful found..
         
         X_k      = current_features(max_min_idx(1)).feature;
         %TH       = X_k.TH_range;
         X_k.th   = max_min_idx(2); %%%: A hack
         X_k.th_idx = max_min_idx(2); % Save the th_idx !!
         X_k.gain = max_min_val; 
         % This is transient: Valid only for this instant..
         % fprintf(1,'.');
         
         if isempty(saved_features),
            saved_features(1).feature = X_k;
            match_table_saved = match_table_current(max_min_idx(1),:);
         else
            saved_features(size(saved_features,2)+1).feature = X_k;
            match_table_saved = [match_table_saved; match_table_current(max_min_idx(1),:)];
         end
         
         % Remove the feature from current features:
         idx_other_current_features = setdiff(1:size(current_features,2),max_min_idx(1));
         if not(isempty(idx_other_current_features)),
            current_features    = current_features(idx_other_current_features);
            match_table_current = match_table_current(idx_other_current_features,:);
         else
            current_features    = [];
            match_table_current = [];
         end
      else
         % Nothing useful..
         keep_going = 0;
      end
      
      
      if size(saved_features,2) >= max_feature_pool_size,
         keep_going = 0;
      end
      if isempty(current_features),
         keep_going = 0;
      end
      
      fprintf(1,'%d ',size(saved_features,2));
   end % End of the feature learning phase..
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % Clear countless megabytes of unnecessary stuff..
   clear gain_tables2;
   clear par1;
   
   fprintf(1,'\nFeature pool size = %d\n',size(saved_features,2));  
   
   % Change the data into svm format (just binarize)..
   svm_data = match_table_saved;
   for k = 1:size(saved_features,2),
      svm_data(k,:) = (match_table_saved(k,:) >= saved_features(k).feature.th);
   end
   addpath osu_svm;
   svm_answers = current_labels';
   % Learn a linear svm:
   [AlphaY,SVs,Bias,Parameters,nSV,nLabel] = LinearSVC(svm_data,svm_answers);
   svm = [];
   svm.AlphaY = AlphaY;
   svm.SVs = SVs;
   svm.Bias = Bias;
   svm.Parameters = Parameters;
   svm.nSV = nSV;
   svm.nLabel = nLabel;   
   mapping = 0*svm_data(:,1);
   for i=1:size(mapping,1),
     tmp = zeros(size(mapping,1),1);
     tmp(i) = 1;
     [pred,dv] = predict_example_raw_svm(svm,tmp);
     mapping(i) = dv;
   end
   mapping = mapping + svm.Bias;
   svm.w_map = mapping;
   
   %%%%%%%%%%%%%%%%%%%%%%%%
   % Alternative stuff:
   [H,W] = size(current_images(:,:,1));
   mask = zeros(H,W);
   graded_mask = mask;
   for k=1:size(saved_features,2),
      feature = saved_features(k).feature;
      [h,w]   = size(feature.evaluator_params.fragment_image);
      loc     = feature.evaluator_params.source_loc;
      span    = feature.evaluator_params.span;
      span = 0;
      i_start = loc(1)-span; i_start = max([1 i_start]);
      j_start = loc(2)-span; j_start = max([1 j_start]);
      i_stop  = loc(1)+h-1+span; i_stop = min([H i_stop]); 
      j_stop  = loc(2)+w-1+span; j_stop = min([W j_stop]);
      mask(i_start:i_stop,j_start:j_stop) = 1;
      graded_mask(i_start:i_stop,j_start:j_stop) = graded_mask(i_start:i_stop,j_start:j_stop) +1;
   end
   graded_mask = graded_mask./max(graded_mask(:));
   figure(2); subplot(2,1,1); imshow(mask);
   figure(2); subplot(2,1,2); imshow(graded_mask);
   
   masked_images = current_images;
   for k=1:size(current_images,3),
      masked_images(:,:,k) = mask.*current_images(:,:,k);
   end
   
   
   %%%%%%%%%%%%%%%%%%%%%%%%
   % Svm 2:
   addpath osu_svm;
   [ht,wt,n_images] = size(current_images);
   svm_data = zeros(ht*wt,n_images);
   svm_answers = zeros(1,n_images);
   for k = 1:n_images,
     tmp = current_images(:,:,k);
     tmp = imfilter(tmp,fspecial('gaussian',[9 9],2));
     tmp = tmp(:);
     svm_data(:,k)  = tmp;
     svm_answers(k) = current_labels(k);
   end
   % Learn another svm:
   [AlphaY,SVs,Bias,Parameters,nSV,nLabel] = PolySVC(svm_data,svm_answers,2);
   % Remember the raw machine:
   svm_raw2 = [];
   svm_raw2.AlphaY = AlphaY;
   svm_raw2.SVs = SVs;
   svm_raw2.Bias = Bias;
   svm_raw2.Parameters = Parameters;
   svm_raw2.nSV = nSV;
   svm_raw2.nLabel = nLabel;
   
   %%%%%%%%%%%%%%%%%%%%%%%%
   
   % Remember the classifier:
   folds(current_fold).saved_features = saved_features;
   folds(current_fold).svm = svm;
   folds(current_fold).svm_raw  = svm_raw;
   folds(current_fold).svm_raw2 = svm_raw2;
   folds(current_fold).mask = mask;
   folds(current_fold).graded_mask = graded_mask;
   
   % Prepare to test:
   clear positives;
   clear negatives;
   pos_idx_test = setdiff(all_pos_idx,folds(current_fold).pos_idx);
   neg_idx_test = setdiff(all_neg_idx,folds(current_fold).neg_idx);
   positives = all_positives(:,:,pos_idx_test);
   negatives = all_negatives(:,:,neg_idx_test);
   n_mistakes_pos = 0;
   n_correct_pos  = 0;
   n_mistakes_neg = 0;
   n_correct_neg  = 0;
   n_frag_use     = 0;
   n_raw_use      = 0;
   raw_speed      = 0;
   frag_speed     = 0;
   
   fprintf(1,'\nTesting with %d + %d images\n',size(positives,3),size(negatives,3));
   
   for test_idx = 1:size(positives,3),
      test_img = positives(:,:,test_idx);
      tmp = imfilter(test_img,fspecial('gaussian',[9 9],2));
      tic;
      [pred,dv] = predict_example_raw_svmF(svm_raw,tmp);
      raw_speed = raw_speed + toc; % Cumulative..
      if dv>svm_raw.neg_max & dv<svm_raw.pos_min,
         tic;
         pred = predict_example_svmF(saved_features,svm,test_img);
         frag_speed = frag_speed + toc;
         n_frag_use = n_frag_use + 1;
      else
         n_raw_use = n_raw_use + 1;
      end
      if pred==1,
         n_correct_pos = n_correct_pos + 1;
      else
         n_mistakes_pos = n_mistakes_pos + 1;
      end
   end
   for test_idx = 1:size(negatives,3),
      test_img = negatives(:,:,test_idx);
      tmp = imfilter(test_img,fspecial('gaussian',[9 9],2));
      tic;
      [pred,dv] = predict_example_raw_svmF(svm_raw,tmp);
      raw_speed = raw_speed + toc; % Cumulative..
      if dv>svm_raw.neg_max & dv<svm_raw.pos_min,
	 tic;
         pred = predict_example_svmF(saved_features,svm,test_img);
         frag_speed = frag_speed + toc;
         n_frag_use = n_frag_use + 1;
      else
         n_raw_use = n_raw_use + 1;
      end
      if pred==1,
         n_mistakes_neg = n_mistakes_neg + 1;
      else
         n_correct_neg = n_correct_neg + 1;
      end
   end
   folds(current_fold).test_stat = ...
      [n_correct_pos n_mistakes_pos; n_correct_neg n_mistakes_neg];
   [n_correct_pos n_mistakes_pos; n_correct_neg n_mistakes_neg]
   folds(current_fold).usage = [n_raw_use n_frag_use];
   [n_raw_use n_frag_use]
   raw_speed  = raw_speed / (n_raw_use + n_frag_use);
   frag_speed = frag_speed / n_frag_use;
   folds(current_fold).speeds = [raw_speed frag_speed];
   [raw_speed frag_speed]
   
   %%%%%%%%%%%%
   % Raw 1:
   n_mistakes_pos = 0;
   n_correct_pos  = 0;
   n_mistakes_neg = 0;
   n_correct_neg  = 0;
   for test_idx = 1:size(positives,3),
      tmp = positives(:,:,test_idx);
      tmp = imfilter(tmp,fspecial('gaussian',[9 9],2));
      pred = predict_example_raw_svm(svm_raw,tmp);
      if pred==1,
         n_correct_pos = n_correct_pos + 1;
      else
         n_mistakes_pos = n_mistakes_pos + 1;
      end
   end
   for test_idx = 1:size(negatives,3),
      tmp = negatives(:,:,test_idx);
      tmp = imfilter(tmp,fspecial('gaussian',[9 9],2));
      pred = predict_example_raw_svm(svm_raw,tmp);
      if pred==1,
         n_mistakes_neg = n_mistakes_neg + 1;
      else
         n_correct_neg = n_correct_neg + 1;
      end
   end
   folds(current_fold).test_stat_raw1 = ...
      [n_correct_pos n_mistakes_pos; n_correct_neg n_mistakes_neg];
   [n_correct_pos n_mistakes_pos; n_correct_neg n_mistakes_neg]
   
   %%%%%%%%%%%%
   % Raw 2:
   n_mistakes_pos = 0;
   n_correct_pos  = 0;
   n_mistakes_neg = 0;
   n_correct_neg  = 0;
   for test_idx = 1:size(positives,3),
      tmp = positives(:,:,test_idx);
      tmp = imfilter(tmp,fspecial('gaussian',[9 9],2));
      pred = predict_example_raw_svm(svm_raw2,tmp);
      if pred==1,
         n_correct_pos = n_correct_pos + 1;
      else
         n_mistakes_pos = n_mistakes_pos + 1;
      end
   end
   for test_idx = 1:size(negatives,3),
      tmp = negatives(:,:,test_idx);
      tmp = imfilter(tmp,fspecial('gaussian',[9 9],2));    
      pred = predict_example_raw_svm(svm_raw2,tmp);
      if pred==1,
         n_mistakes_neg = n_mistakes_neg + 1;
      else
         n_correct_neg = n_correct_neg + 1;
      end
   end
   folds(current_fold).test_stat_raw2 = ...
      [n_correct_pos n_mistakes_pos; n_correct_neg n_mistakes_neg];
   [n_correct_pos n_mistakes_pos; n_correct_neg n_mistakes_neg]
   
   %%%%%%%
   % Save:
   save results/roth_moreblur;
   pause(2);
   
end

% Calculate stats, etc...

final_stats = validation_stats(folds,1,'r*');

cand_spec = zeros(size(folds,2),1);
for k=1:size(folds,2),
   cand_spec(k) = folds(k).n_cand_features;
end

save cand_spec_blur cand_spec;

% End.
