function out = validation_stats(folds,fno,opt)
% Combines some statistics of the results
%
out = [];
if nargin<3,
  opt = 'r*';
end
out.tp_per_fp = zeros(size(folds,2),1);
out.acc = zeros(size(folds,2),1);
out.roc_points = zeros(size(folds,2),2);
m = 0;
for idx=1:size(folds,2),
  s = folds(idx).test_stat;
  tmp1 = s(1,1)/sum(s(1,:)); 
  tmp2 = s(2,2)/sum(s(2,:)); 
  out.acc(idx) = sum(s(:,1))/sum(s(:));
  if tmp2~=0,
    out.tp_per_fp(idx) = tmp1/tmp2;
  else
    out.tp_per_fp(idx) = inf;
  end
  out.roc_points(idx,:) = [tmp1 tmp2];
end
out.mean_acc = mean(out.acc);
out.mean_tp_per_fp = mean(out.tp_per_fp);
out.min_acc = min(out.acc);
out.max_acc = max(out.acc);
out.min_tp_per_fp = min(out.tp_per_fp);
out.max_tp_per_fp = max(out.tp_per_fp);
figure(fno);
plot(out.roc_points(:,2),out.roc_points(:,1),opt);
axis([0 1 0 1]);

% End.
