
function acc=algorithm_heuristic(outfn,examples,labels,teststart)
% acc=algorithm_heuristic(outfn,examples,labels,teststart)
%
% Use Beta-Heuristic to online learn a classifier
%
% acc       : accuracy
% outfn     : filename to write results to
% examples  : cell array of file names
% labels    : example labels, in {-1,1}
% teststart : the index to examples to denote the start of
%             testing phase (model is no longer updated)
%
 
  MAXIMGSIZE  = 200;
  N_RANDOM_FEATURES = 64;
  DAMP0       = 0.98;
  DAMP1       = 0.98;
  pool0       = [];
  pool0.store = [];
  pool0.cap   = 512;
  pool1       = [];
  pool1.store = [];
  pool1.cap   = 32;
  errors = zeros(length(examples),1);
  promotes = zeros(length(examples),1);
  confu = zeros(2,2);
  
  if(nargin<4)
    teststart=0;
  end

  initialized = 0;
  for cidx = 1:length(examples), 
    x = loadimg2(char(examples(cidx)),MAXIMGSIZE);

    [pred,pimg] = predict_label(pool1.store,x);
    y = labels(cidx);
    err = (pred ~= y);
    if err,
      errors(cidx) = 1;
    end

    if(teststart==0 || cidx<teststart)
      % not in the test part yet, we are allowed to update the model

      if y==1  
        if initialized == 0,
          [fset,pimg] = request_features(pimg,y,pool0.cap,cidx);
          pool0 = append_features(pool0,fset);
          [fset,pimg] = request_features(pimg,y,pool1.cap,cidx);
          pool1 = append_features(pool1,fset);
          initialized = 1;
        else
          if err,
            [fset,pimg]  = request_features(pimg,y,N_RANDOM_FEATURES,cidx);
            pool0 = append_features(pool0,fset);
          end
        end
      end
 
      % Maintain pool statistics:
      [pool0,pimg] = maintain_stats_heuristic(pool0,pimg,y,DAMP0);
      [pool1,pimg] = maintain_stats_heuristic(pool1,pimg,y,DAMP1);
    
      if err,
        [pool0,pool1,pri] = promote_heuristic(pool0,pool1);
        promotes(cidx)=pri;
      end
    end % update
 
    acc = 1 - sum(errors)/cidx;
    closses = cumsum(errors(1:cidx));

%    fprintf(1,'%04d acc = %f\n',cidx, acc);
%    figure(2); subplot(1,1,1);
%    plot(closses);
%    drawnow;
 
    pred=0.5*(pred + 3);y=0.5*(y + 3);
    confu(y,pred)=confu(y,pred)+1;

  end

  save(outfn);
 
% End.
