
function pool_out = append_features(pool,fset)
% function pool_out = append_features(pool,fset)
%
% appends features in "fset" to feature pool "pool" in FIFO fashion
% 
% Returns the new pool
%

for k=1:size(fset,2),
  fset(k).feature.stats = [];
  fset(k).feature.stats.pos_phat = 0;
  fset(k).feature.stats.neg_phat = 0;
  fset(k).feature.stats.n_pos_occ = 0;
  fset(k).feature.stats.n_neg_occ = 0;
  fset(k).feature.stats.n_pos = 0;
  fset(k).feature.stats.n_neg = 0;
  fset(k).feature.stats.merit = 1;
end
n_old_out = size(pool.store,2) - (pool.cap - size(fset,2));
if n_old_out > 0,
  % Oldest out first..
  timestamps = zeros(size(pool.store,2),1);
  for i=1:size(timestamps,1),
    timestamps(i) = pool.store(i).feature.evaluator_params.source_loc(3);
  end
  [dummy,idx] = sort(timestamps);
  idx = idx(1:n_old_out);
  idx_spared  = setdiff(1:size(pool.store,2),idx);
  pool.store = pool.store(idx_spared);
end

% Now there is enough room for fset.

pool.store = [pool.store fset];
pool_out    = pool;

% End.
