
% 
% Calculates accuracy plots after experiments have been ran
%
%
clear;pack;

funcs = {'algorithm_bayes','algorithm_heuristic'};
names = {'OnlineLearn','Heuristic'};
%datasets = {'caltechfaces'};
datasets = {'rothcars','airplanes','bioidfaces','caltechfaces','motorbikes','houses'};
% dnames = {'Cars dataset','Airplanes dataset'};
iters = 10;

colors={'r-','g--','+','*','s'};

stats=zeros(length(datasets),iters,length(funcs));


  for i=1:length(datasets)
    for k=1:length(funcs)
      for j=1:iters
        outfn=sprintf('results/res_%s_%s_%s_iter%02d.mat', ...
                                                  getenv('USER'), ...
                                                  char(datasets(i)), ...
                                                  char(funcs(k)), ... 
  	    	     	  	                  j);
        S=load(outfn);
	tmp=cumsum(S.errors);
	if(j==1 && k==1)
	  errors=zeros(iters,length(funcs),length(tmp));
	end
%	errors(j,k,:)=errors(k,:)+tmp';
	errors(j,k,:)=tmp';
      end %j
    end %k
    fprintf(1,'%s\n',outfn);
%    stds=squeeze(std(errors,0,1));
%    keyboard
    errors=squeeze(sum(errors,1));
    errors=errors./iters;
%    keyboard;
    figure(1);clf;
    axis off;axes('FontSize',24);
    hold on;
%    axis([1 length(tmp) 0.4 0.9]);
    axis([1 length(tmp) 0.7 0.9501]);
    for k=1:length(funcs)
      errors(k,:) = errors(k,:) ./ (1:length(tmp));
       
      h=plot(1-errors(k,:),char(colors(k)));
      set(h,'LineWidth',3)
    end
%    plot(repmat(0.5,[length(tmp) 1]),'-.');
%    nfuncs=names;nfuncs{end+1}='guess';
    nfuncs=names;
    legend(nfuncs,4);
%%    title(char(dnames(i)));
    ylabel('Accuracy');
    xlabel('Examples processed');
    pause;
  end %i
  
  
% End.

