
%
% Calculates accuracies after experiments have been ran
%
clear;

funcs = {'algorithm_bayes','algorithm_heuristic'};
datasets = {'rothcars','bioidfaces','caltechfaces','airplanes','motorbikes','houses'};
iters = 10;

stats=zeros(length(datasets),iters,length(funcs));
p=[];

  for i=1:length(datasets)
    for j=1:iters
      for k=1:length(funcs)
        outfn=sprintf('results/res_%s_%s_%s_iter%02d.mat', ...
                                                  getenv('USER'), ...
                                                  char(datasets(i)), ...
                                                  char(funcs(k)), ... 
  	    	     	  	                  j);
        S=load(outfn);
        stats(i,j,k)=S.acc;
      end %k
    end %j
    fprintf(1,'%s\n', char(datasets(i)));
    tmp=squeeze(stats(i,:,:));
    tp=kruskalwallis(tmp,[],'off');
    p=[p;tp];
%    keyboard
%    pause;
  end %i
  
  for i=1:length(funcs)
    fprintf(1, '%12s  ', char(funcs(i)));
  end
  fprintf(1,'\n');
  
  for i=1:length(datasets)
    d=mean(squeeze(stats(i,:,:)));
    v=std(squeeze(stats(i,:,:)));
    fprintf(1, '%12s ', char(datasets(i)));
    for j=1:length(d)
      fprintf(1, ' & $%1.2f \\pm %1.2f$  ', d(j),v(j));
%      fprintf(1, ' %f ', d(j));
    end
    fprintf(1,'\n');
  end

% End.

  edge=sum(p<0.05)/length(p);
  fprintf(1,'%d/%d significances => %f\n', sum(p<0.05), length(p), edge);

