
function [out,procimage] = fragment_evaluator(params,procimage)
% function [out,procimage] = fragment_evaluator(params,procimage)
% 
% Evaluates the presence of a fragment feature "params" in "procimage"
% [ a preprocessed image returned by predict_label() ] 
% 

image = procimage.raw;

[ht,wt] = size(image);

spanI = round(params.spanI * ht);
spanJ = round(params.spanJ * wt);

I_f  = round(params.source_loc(1) * ht);
J_f  = round(params.source_loc(2) * wt);

I_start = max([1 I_f-spanI]);
J_start = max([1 J_f-spanJ]);
[ht2,wt2] = size(params.fragment_image);
I_stop  = min([ht I_f+ht2-1+spanI]);
J_stop  = min([wt J_f+wt2-1+spanJ]);
image   = image(I_start:I_stop,J_start:J_stop);

try
  % local normxcorr
  cc = hax_normxcorr2(params.fragment_image,image);
  cc = cc(ht2:end-ht2+1,wt2:end-wt2+1);  % cut border effects
catch
  % Image probably too small for fragment :(
  % Note that if there is correlation with this happening
  % and the class label, the results can be biased
  image = procimage.raw;
  if(ht<ht2 | wt<wt2) % image smaller than frag, enlarge
      r=max((ht2+1)/ht,(wt2+1)/wt);
      image=imresize(image,r,'bilinear');
  end
  % global normxcorr
  cc = hax_normxcorr2(params.fragment_image,image);
  cc = cc(ht2:end-ht2+1,wt2:end-wt2+1);  % cut border effects
end

if isreal(cc),
  out = max(cc(:));
else
  out = 0;
end

% End.
