
function F = getfilenames(SPATH,pattern,maxi)
% Samples filenames from a given path SPATH
% 
% pattern filename pattern to match
% maxi maximum number of images to sample
%
    tmp=sprintf('%s/%s', SPATH,pattern);

    files=dir(tmp);
    flen=size(files,1);
    if(maxi>flen)
      maxi=flen;
    end

    idx=randperm(flen);
    idx=idx(1:maxi);

    F=cellstr('');
    for i=1:maxi
      F(i)=cellstr(sprintf('%s/%s', SPATH, files(idx(i)).name));
    end

