
function img = loadimg2(fn,smax)
% Returns the loaded image in double format. Color images
% are converted to gray.
%
  doretry=1;

  while(doretry==1)
    try 
      img = imread(fn);
      doretry = 0;
    catch 
      fprintf(1,'Unable to read %s, sleeping\n', fn);
      pause(5);
    end 
  end

  img=im2double(img);
  [rows,cols,chns]=size(img);
  
  if(chns>1) % Color image?
    img=rgb2gray(img);
  end

  maxs=max(rows,cols);
  if(maxs>smax)
    img=imresize(img,smax/maxs,'bilinear');
  end

