
function [pool_out,pimg] = maintain_stats_heuristic(pool,pimg,y,dampenfactor)
% function [pool_out,pimg] = maintain_stats_heuristic(pool,pimg,y,dampenfactor)
%
% Maintains the statistics of the Beta-Heuristic model, i.e. compute
% the presence of features in "pool" in "pimg" with label "y"'
% and return the pool with the feature stats updated.
% "dampenfactor" is a forgetting factor, in ]0,1].
%

indicators = zeros(size(pool.store,2),1);
for k=1:size(pool.store,2),
  [indicator,pimg] = indicate_feature(pool.store(k).feature,pimg);
  indicators(k) = indicator;
  gain = 0;
  if indicator==1,
    if y==1
      gain = 1;
      pool.store(k).feature.stats.n_pos_occ = pool.store(k).feature.stats.n_pos_occ+1;
    else
      gain = -1;
      pool.store(k).feature.stats.n_neg_occ = pool.store(k).feature.stats.n_neg_occ+1;
    end
  end
  if y==1,
    pool.store(k).feature.stats.n_pos = pool.store(k).feature.stats.n_pos+1;
  else
    pool.store(k).feature.stats.n_neg = pool.store(k).feature.stats.n_neg+1;
  end

  nposocc = pool.store(k).feature.stats.n_pos_occ;
  npos = pool.store(k).feature.stats.n_pos;

  if(npos>0)
    pool.store(k).feature.stats.pos_phat = nposocc / npos;
  else
    pool.store(k).feature.stats.pos_phat = 0.5;
  end

  nnegocc= pool.store(k).feature.stats.n_neg_occ;
  nneg = pool.store(k).feature.stats.n_neg;
 
  if(nneg>0)
    pool.store(k).feature.stats.neg_phat = nnegocc / nneg;
  else
    pool.store(k).feature.stats.neg_phat = 0.5;
  end

  merit = dampenfactor * pool.store(k).feature.stats.merit + ...
          gain;

  pool.store(k).feature.stats.merit  = merit;
end

pool_out = pool;

% End.
