
function [pred,procimage] = predict_label(store,x)
% function [pred,procimage] = predict_label(store,x)
%
% Predict a class label for an image given a pool of
% features "store" with their associated statistics
%
procimage=[];
procimage.raw = x;

ratio = 1;
for k=1:size(store,2),
  [indicator,procimage] = indicate_feature(store(k).feature,procimage);
  pos_phat = store(k).feature.stats.pos_phat;
  neg_phat = store(k).feature.stats.neg_phat;
  if indicator ~= 1,
    pos_phat = 1 - pos_phat;
    neg_phat = 1 - neg_phat;
    % We computed p(feat=1|pos),p(feat=1|neg).
  end
 
  ratio = ratio * (pos_phat+eps)/(neg_phat+eps);
end
if ratio > 1,
  pred = 1;
else
  pred = -1;
end

% End.
