
function [pool0_out,pool1_out,promotion_indicator,cpy_promoted]= promote_bayes(pool0,pool1,n_sim_iter,min_req)
%function [pool0_out,pool1_out,promotion_indicator,cpy_promoted]= promote_bayes(pool0,pool1,n_sim_iter,min_req)
%
% Promotion function for Beta-Learn. Promote a feature from pool0 
% to pool1 if probability of the move being good enough is large.
%
% n_sim_iter : how many sampling iterations from beta-distr.
% min_req    : minimum probability req. for move, in [0,1]
%

% Tentative move: F_i replaces F_j in pool1.
% The move is correct if the sum of the merits in pool1 increases.
% i.e., m_i > m_j.
% Because the true merits are unknown, we cannot guarantee
% the correctness of any move.
% Hence, we choose the move that has the maximal probability
% of being correct.
% => Bayesian inference required, because the merits are
% functions of probabilities, and we must now assess the 
% probability of the component probabilities satisfying m_i > m_j.

sim_pool0_c1 = zeros(size(pool0.store,2),n_sim_iter);
sim_pool0_c0 = zeros(size(pool0.store,2),n_sim_iter);
sim_pool1_c1 = zeros(size(pool1.store,2),n_sim_iter);
sim_pool1_c0 = zeros(size(pool1.store,2),n_sim_iter);
for i=1:size(sim_pool0_c1,1),
  F_i = pool0.store(i).feature;
  n_i1 = F_i.stats.n_pos;
  k_i1 = F_i.stats.n_pos_occ;
  n_i0 = F_i.stats.n_neg;
  k_i0 = F_i.stats.n_neg_occ;
  sim_pool0_c1(i,:) = betarnd(k_i1+1, n_i1-k_i1+1, [1 n_sim_iter]);
  sim_pool0_c0(i,:) = betarnd(k_i0+1, n_i0-k_i0+1, [1 n_sim_iter]);
end
for j=1:size(sim_pool1_c1,1),
  F_j = pool1.store(j).feature;
  n_j1 = F_j.stats.n_pos;
  k_j1 = F_j.stats.n_pos_occ;
  n_j0 = F_j.stats.n_neg;
  k_j0 = F_j.stats.n_neg_occ;
  sim_pool1_c1(j,:) = betarnd(k_j1+1, n_j1-k_j1+1, [1 n_sim_iter]);
  sim_pool1_c0(j,:) = betarnd(k_j0+1, n_j0-k_j0+1, [1 n_sim_iter]);
end

max_prob_correct = -inf;
max_prob_i = 0;
max_prob_j = 0;
for i=1:size(pool0.store,2),
  p_i1 = sim_pool0_c1(i,:);
  p_i0 = sim_pool0_c0(i,:);
  for j=1:size(pool1.store,2),
    p_j1 = sim_pool1_c1(j,:);
    p_j0 = sim_pool1_c0(j,:);
    
    cond1 = (p_i1.*p_j0>p_j1.*p_i0) & (p_i1.*(1-p_j1)>(1-p_j0).*p_i0);      
    cond2 = ((1-p_i0).*p_j0>(1-p_i1).*p_j1) & ((1-p_i0).*(1-p_j1)>(1-p_j0).*(1-p_i1));
    indicators   = ((cond1 + cond2)>=1);
    prob_correct = sum(indicators)/size(indicators,2);
    if prob_correct > max_prob_correct,
      max_prob_correct = prob_correct;
      max_prob_i = i;
      max_prob_j = j;
    end
  end
end
promotion_indicator = 0;
cpy_promoted = [];
if max_prob_correct > min_req,
  tmp = pool1.store(max_prob_j).feature;
  pool1.store(max_prob_j).feature = pool0.store(max_prob_i).feature;
  cpy_promoted = pool1.store(max_prob_j).feature;
  pool0.store(max_prob_i).feature = tmp;
  promotion_indicator = 1;
end

%if promotion_indicator==1,
%  fprintf(1,'\nupdate_pool1_bayesian_fast: Pool modified.\n');
%end

pool0_out = pool0;
pool1_out = pool1;

% End.
