
function [pool0_out,pool1_out,promotion_indicator]= promote_heuristic(pool0,pool1)
%function [pool0_out,pool1_out,promotion_indicator]= promote_heuristic(pool0,pool1)
% 
% Promotion function for Beta-Heuristic. Move a feature from pool0
% to pool1 if its merit according to a simple criteria exceeds that
% of some feature in pool1.
%

merit_margin = 0; 

promotion_indicator = 0;
merit0 = zeros(size(pool0.store,2),1);
for k=1:size(pool0.store,2),
  s = pool0.store(k).feature.stats;
  merit0(k) = s.merit;
end
if not(isempty(merit0)),
  [dummy,idx] = max(merit0);
  promoted = idx(1);
  % This if never fires... Good in theory.
  if size(pool1.store,2)<pool1.cap,
    tmp = size(pool1.store,2)+1;
    pool1.store(tmp).feature = pool0.store(promoted).feature;
    pool0.store = pool0.store(setdiff(1:size(pool0.store,2),promoted));
    promotion_indicator = 1;
  else
    for k=1:size(pool1.store,2),
      s = pool1.store(k).feature.stats;
      merit1(k) = s.merit;
    end
    [dummy,idx] = min(merit1);
    demoted = idx(1);
    if merit0(promoted) - merit1(demoted) > merit_margin,
      tmp = pool1.store(demoted).feature;
      pool1.store(demoted).feature  = pool0.store(promoted).feature;
      pool0.store(promoted).feature = tmp;
      promotion_indicator = 1;
    end
  end
end

pool0_out = pool0;
pool1_out = pool1;

% End.
