
function [f_out,pimg] = request_features(pimg,y,nr,t)
% function [f_out,pimg] = request_features(pimg,y,nr,t)
%
% Samples fragment features from "pimg" with label "y". 
% "nr" is the number of features requested, "t" the number 
% of the current example
%

f_out  = [];
fcount = 0;

%%%%%%% Fragment features

x=pimg.raw;

[H,W] = size(x);

hsize=0.12 * H;   % frag. side length avg. ~12%+ of src image len
wsize=0.12 * W;

while(fcount<nr)
  h = 8+floor(rand(1)*2*hsize);
  w = 8+floor(rand(1)*2*wsize);
  
  i = ceil(rand(1)*(H-h+1));
  j = ceil(rand(1)*(W-w+1));
  patch = x((i:(i+h-1)),(j:(j+w-1)));

  if(std(patch(:))<0.01)
    continue;
  end

  fcount  = fcount + 1;
  feature = [];
  feature.evaluator = 'fragment_evaluator';
  feature.evaluator_params.fragment_image = patch;
  feature.evaluator_params.source_loc = [i/H j/W t];
  feature.evaluator_params.size = [h w];
  feature.evaluator_params.spanI = 0.05 + rand(1)*0.15;
  feature.evaluator_params.spanJ = 0.05 + rand(1)*0.15;
  feature.description = 'fragment';
  feature.th = 0.3 + rand(1)*0.65;
  f_out(fcount).feature = feature;
  
end

