
%
% Runs online classification experiments
%

clear;pack;

addpath more_hax;

funcs = {'algorithm_bayes','algorithm_heuristic'};
datasets = {'rothcars','caltechfaces','bioidfaces','airplanes','motorbikes','houses'};

ITERS = 10;

load('datasets/fn_negatives'); % negfn

if(~exist('results','dir'))
  mkdir('results');
end

% try to address the problem of syncing the random generators
% if different parts of the experiment are ran on different
% machines simultaneously
rand('state',0);
randn('state',0);
states=floor(rand(length(datasets),ITERS)*2^24);

for i=1:length(datasets)
  dsetfn=sprintf('datasets/fn_%s.mat',char(datasets(i)));
  load(dsetfn); % posfn

  examples = [posfn,negfn];
  labels   = [ones(length(posfn),1); -ones(length(negfn),1)];

  for j=1:length(funcs)
    for k=1:ITERS
      outfn=sprintf('results/res_%s_%s_%s_iter%02d.mat', ...
                                               getenv('USER'), ...
                                               char(datasets(i)), ...
                                               char(funcs(j)), ... 
 	    	     	  	                 k);
      if(exist(outfn,'file')~=0)
        fprintf(1,'skipping -> %s ...\n', outfn);
        continue;
      end
      fprintf(1,'running -> %s ... ', outfn);
      
      rand('state',states(i,k));
      randn('state',states(i,k));
      
      idx      = randperm(length(labels));
      examples = examples(idx);
      labels   = labels(idx);

      fid=fopen(outfn,'w'); % own the file, unsafe concurrency control
      fclose(fid);

      acc = feval(char(funcs(j)), outfn, examples,labels); % saves to outfn
      
      fprintf(1,'acc=%f\n', acc);
    end %k
  end %j
end %i

% End.
