
%
% Runs cross-validation experiments
%

clear;pack;

addpath more_hax;

funcs = {'algorithm_bayes','algorithm_heuristic'};
datasets = {'rothcars','caltechfaces','bioidfaces','airplanes','motorbikes','houses'};

FOLDS = 10;

if(~exist('results','dir'))
  mkdir('results');
end

load('datasets/fn_negatives.mat'); % negfn

% if ran on multiple machines, we need to get the
% correct xval splits
rand('state',0); 
randn('state',0);
states=floor(rand(length(datasets),FOLDS)*2^24);

for i=1:length(datasets)
  dsetfn=sprintf('datasets/fn_%s.mat',char(datasets(i)));
  load(dsetfn); % posfn
    
  examples = [posfn,negfn];
  labels   = [ones(length(posfn),1); -ones(length(negfn),1)];

  for j=1:length(funcs) 

    rand('state',states(i,1));
    randn('state',states(i,1));
    
    idxs = randperm(length(labels));
    splitlocs = round(linspace(0,length(idxs),FOLDS+1)); % xval splits

    for k=1:FOLDS
      outfn=sprintf('results/xval_%s_%s_%s_fold%02d.mat', ...
                                                  getenv('USER'), ...
                                                  char(datasets(i)), ...
                                                  char(funcs(j)), ... 
  	    	     	  	                  k);
      if(exist(outfn,'file')~=0)
        fprintf(1,'skipping -> %s ...\n', outfn);
        continue;
      end
      fprintf(1,'running -> %s ... ', outfn);

      testblock = splitlocs(k)+1:splitlocs(k+1);
      testidxs = idxs(testblock);
        
      trainblock = setdiff(1:length(idxs), testblock);
      trainidxs = idxs(trainblock);

      texamples = examples([trainidxs,testidxs]);
      tlabels = labels([trainidxs,testidxs]);
 
      teststart = length(trainidxs)+1;

      fid=fopen(outfn,'w'); % own the file, unsafe concurrency control
      fclose(fid);
      
      rand('state',states(i,k));
      randn('state',states(i,k));

      acc = feval(char(funcs(j)), outfn, texamples,tlabels, teststart); 
            % function saves its state to outfn
        
      fprintf(1,'acc=%f\n', acc);
    end %k
  end %j
end %i

% End.
