﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content;

namespace Sokoban3D
{
    /// <summary>
    /// The class which handles loading all resources for the base class
    /// And offers them as public properties for other classes to use.
    /// </summary>
    public class GameContent
    {
        private Game game;
        
        // model variables
        public Model floor;
        public Model wall;
        public Model goal;
        public Model ball;
        public Model player;
        public Model skyband;
        public Song bgm;

        // text variables
        public SpriteFont smallFont, largeFont;

        // background variables
        public Texture2D helpbg, skybackground;
        
        // insert audio variables here such as background and moving sounds


        public GameContent(Game game)
        {
            this.game = game;
        }
        /// <summary>
        /// loadContent loads all the content resources needed to draw graphics, models
        /// and audio in the game.
        /// </summary>
        public void loadContent()
        {
            // load level graphic textures and models
            floor = game.Content.Load<Model>(@"Models\floor");
            wall = game.Content.Load<Model>(@"Models\wall");
            goal = game.Content.Load<Model>(@"Models\goal");
            ball = game.Content.Load<Model>(@"Models\ball");
            player = game.Content.Load<Model>(@"Models\gingerbread");

            // load background related content
            skyband = game.Content.Load<Model>(@"Models\SkyBand");
            skybackground = game.Content.Load<Texture2D>(@"Textures\skysphere");
            helpbg = game.Content.Load<Texture2D>(@"Textures\helpbg");

            // load the menu text fonts
            smallFont = game.Content.Load<SpriteFont>(@"Textures\menuSmall");
            largeFont = game.Content.Load<SpriteFont>(@"Textures\menuLarge");

            // load background music
            bgm = game.Content.Load<Song>(@"Foogies");
        }        

    }
}
