﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Sokoban3D.Objects
{
    class BackGroundObject : GameObject
    {
        private int elapsedtime;

        public BackGroundObject(Model model, Vector3 position, Matrix rotation)
            : base(model, position, rotation)
        {
            this.diffuseColor = Color.White.ToVector3();
            this.lightDirection = new Vector3(1, 1, -1);
            this.lightDirection.Normalize();
            this.lightingEnabled = false;
            this.directionalLight0Enabled = false;
            this.preferPerPixelLighting = false;
            this.ambientLightColor = new Vector3(1, 1, 1);
        }

        /// <summary>
        /// This method updates the state of the background object. 
        /// In this case it will rotate the background slowly arounf the area.
        /// </summary>
        /// <param name="gametime"></param>
        public void Update(GameTime gametime)
        {
            this.elapsedtime -= gametime.ElapsedRealTime.Milliseconds;
            if (this.elapsedtime < 0)
            {
                this.elapsedtime = 10;
                this.rotation = this.rotation * Matrix.CreateRotationX(0.0001f) * Matrix.CreateRotationY(0.0002f) * Matrix.CreateRotationZ(0.0003f);
            }
        }
    }
}
