﻿using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Sokoban3D.Scenes;

namespace Sokoban3D.Objects
{
    public class GameObject
    {   
        // Model object holds the vertex and texture data for the object.
        protected Model objectModel;
        protected Vector3 position;
        protected Matrix rotation;
        protected Matrix positionTranslation;
        protected Matrix[] transforms;
        protected Vector3 diffuseColor;
        protected Vector3 lightDirection;
        protected Boolean lightingEnabled;
        protected Boolean directionalLight0Enabled;
        protected Boolean preferPerPixelLighting;
        protected Vector3 ambientLightColor;

        public GameObject(Model model, Vector3 position, Matrix rotation)
        {
            this.diffuseColor = Color.White.ToVector3();
            this.lightDirection = new Vector3(1, 1, -1);
            this.lightDirection.Normalize();
            this.lightingEnabled = true;
            this.directionalLight0Enabled = true;
            this.preferPerPixelLighting = true;

            this.objectModel = model;
            this.position = position;
            this.rotation = rotation;
            this.positionTranslation = Matrix.CreateTranslation(position);
            this.transforms = new Matrix[model.Bones.Count];
            model.CopyAbsoluteBoneTransformsTo(transforms);
        }




        public void draw(Camera camera)
        {
            foreach (ModelMesh mesh in objectModel.Meshes)
            {
                foreach (BasicEffect effect in mesh.Effects)
                {
                    effect.EnableDefaultLighting();                    
                    effect.View = camera.view;
                    effect.Projection = camera.projection;
                    effect.World = Matrix.Identity * mesh.ParentBone.Transform * this.rotation * this.positionTranslation;
                    effect.LightingEnabled = this.lightingEnabled;
                    effect.DirectionalLight0.Direction = this.lightDirection;
                    effect.DirectionalLight0.DiffuseColor = this.diffuseColor;
                    effect.DirectionalLight0.Enabled = this.directionalLight0Enabled;
                    effect.PreferPerPixelLighting = this.preferPerPixelLighting;
                    if (this.ambientLightColor != null)
                    {
                        effect.AmbientLightColor = this.ambientLightColor;
                    }
                }
                mesh.Draw();
            }
        }
    }
}
