﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Sokoban3D.Objects
{
    /// <summary>
    /// derivate of the unmovableobject class to add actualy functionality to it
    /// </summary>
    public class GoalObject : UnmovableObject
    {
        // x and y coordinates of the player on the board.
        private int x;
        private int y;
        private Boolean activated;

        public GoalObject(Model model, Vector3 position, Matrix rotation, int xposition, int yposition)
            : base(model, position, rotation)
        {
            this.x = xposition;
            this.y = yposition;
            this.activated = false;
        }

        public int xPosition
        {
            get { return x; }
            set { x = value; }
        }
        public int yPosition
        {
            get { return y; }
            set { y = value; }
        }
        public Boolean active
        {
            get { return activated; }
            set { activated = value; }
        }
    }
}
