﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Sokoban3D.Objects
{
    /// <summary>
    /// derivate of the game object class to handle objects that can move
    /// </summary>
    public class MovableObject : GameObject
    {
        protected float speed;

        public MovableObject(Model model, Vector3 position, Matrix rotation, float speed)
            : base(model, position, rotation)
        {
            this.speed = speed;
        }

        /// <summary>
        /// Moves object to the direction of direction vector with amount given by speed.
        /// </summary>
        /// <returns>Verctor3 object telling the new position.</returns>
        public void move(Vector3 direction)
        {
            direction.Normalize();
            this.position = this.position + (direction * speed);
            this.positionTranslation = Matrix.CreateTranslation(this.position);
        }

        /// <summary>
        /// Rotates the object according to the given rotation matrix.
        /// </summary>
        /// <returns>New direction vector denoting the new direction for the object.</returns>
        public Vector3 rotate(Matrix rotation)
        {
            throw new System.NotImplementedException();
        }

        public void setSpeed(float speed)
        {
            this.speed = speed;
        }
    }
}
