﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Sokoban3D.Objects
{
    /// <summary>
    /// derivate of the movable object to actually add some functionality of its own
    /// </summary>
    public class PlayerObject : MovableObject
    {
        // x and y coordinates of the player on the board.
        private int x;
        private int y;

        public PlayerObject(Model model, Vector3 position, Matrix rotation, float speed, int xposition, int yposition)
            : base(model, position, rotation, speed)
        {
            this.x = xposition;
            this.y = yposition;
        }

        public int xPosition
        {
            get { return x; }
            set { x = value; }
        }

        public int yPosition
        {
            get { return y; }
            set { y = value; }
        }
    }
}
