﻿using System;
using System.Collections.Generic;
using System.Text;
using Sokoban3D.Scenes;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

namespace Sokoban3D.Screens
{
    /// <summary>
    /// screen derivate which prints the credits after clearing all the levels in scenes list at scenemanager
    /// </summary>
    public class EndScreen : Screen
    {
        private Sokoban3D game;
        private KeyboardState oldKeyboardState;

        public EndScreen(Sokoban3D game, SceneManager sceneManager, Texture2D background)
            : base(game,new string[] {"Sokoban3D", " ", "Authors:" , " - VPK", " - PTK"}, sceneManager, background)
        {
            this.game = game;
            this.oldKeyboardState = Keyboard.GetState();
        }

        /// <summary>
        /// draw the credits screen if the screen is visible
        /// </summary>
        /// <param name="gameTime"></param>
        public override void update(GameTime gameTime)
        {
            if (this.visible)
            {
                KeyboardState keyboardState = Keyboard.GetState();

                if ((oldKeyboardState.IsKeyDown(Keys.Escape) && keyboardState.IsKeyUp(Keys.Escape)) || (oldKeyboardState.IsKeyDown(Keys.Enter) && keyboardState.IsKeyUp(Keys.Enter)))
                {
                    this.game.cScreen = Sokoban3D.Screens.Start;
                    this.visible = false;
                }
                oldKeyboardState = keyboardState;
                base.Update(gameTime);
            }
        }
    }
}
