﻿using System;
using System.Collections.Generic;
using System.Text;
using Sokoban3D.Scenes;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

namespace Sokoban3D.Screens
{
    /// <summary>
    /// screen derivate which displays an image containing simple instructions on how to play the game
    /// </summary>
    public class HelpScreen : Screen
    {
        private Sokoban3D game;
        private KeyboardState oldKeyboardState;
        private Texture2D background;
        private Rectangle imageRect;
        private SpriteBatch spriteBatch;

        public HelpScreen(Sokoban3D game, SceneManager sceneManager, Texture2D background)
            : base(game, new string[0], sceneManager, background)
        {
            this.game = game;
            this.background = background;
            this.spriteBatch = (SpriteBatch)game.Services.GetService(typeof(SpriteBatch));

            this.imageRect = new Rectangle((game.Window.ClientBounds.Width - background.Width) / 2, (game.Window.ClientBounds.Height - background.Height) / 2, background.Width, background.Height);

            this.oldKeyboardState = Keyboard.GetState();
        }


        public override void update(GameTime gameTime)
        {
            if (this.visible)
            {
                KeyboardState keyboardState = Keyboard.GetState();

                if ((oldKeyboardState.IsKeyDown(Keys.Escape) && keyboardState.IsKeyUp(Keys.Escape)) || (oldKeyboardState.IsKeyDown(Keys.Enter) && keyboardState.IsKeyUp(Keys.Enter)))
                {
                    this.game.cScreen = Sokoban3D.Screens.Start;
                    this.visible = false;
                }
                oldKeyboardState = keyboardState;

                base.Update(gameTime);
            }
        }
        public override void draw(GameTime gameTime)
        {
            if (this.visible)
            {
                menu.Draw(gameTime);
                this.spriteBatch.Draw(background, imageRect, Color.White);
            }

            base.Draw(gameTime);
        }
    }
}
