﻿using System;
using System.Collections.Generic;
using System.Text;
using Sokoban3D.Scenes;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

namespace Sokoban3D.Screens
{
    /// <summary>
    /// screen derivate to print the name of the level to the screen at the beginning of the game
    /// </summary>
    public class LevelStartScreen : Screen
    {
        private Sokoban3D game;
        private KeyboardState oldKeyboardState;

        public LevelStartScreen(Sokoban3D game, SceneManager sceneManager, Texture2D background)
            : base(game, new String[] {("  "+sceneManager.sceneName.ToUpper()), " ", "<Press Enter>"}, sceneManager, background)
        {
            this.game = game;
            this.oldKeyboardState = Keyboard.GetState();
        }

        public override void update(GameTime gameTime)
        {
            if (this.visible)
            {
                KeyboardState keyboardState = Keyboard.GetState();

                if ((oldKeyboardState.IsKeyDown(Keys.Escape) && keyboardState.IsKeyUp(Keys.Escape)) || (oldKeyboardState.IsKeyDown(Keys.Enter) && keyboardState.IsKeyUp(Keys.Enter)))
                {
                    this.game.cScreen = Sokoban3D.Screens.Game;
                    this.visible = false;
                    this.sceneManager.visible = true;
                }
                oldKeyboardState = keyboardState;

                base.Update(gameTime);
            }
        }
    }
}
