﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Sokoban3D;
using Sokoban3D.Scenes;

namespace Sokoban3D.Screens
{
    /// <summary>
    /// screens derivate which lists the contense of the save folder and uses them for loading games
    /// </summary>
    class LoadScreen : Screen
    {
        
        protected KeyboardState oldKeyboardState;
        private Sokoban3D game;
        private String[] savegames;

        public LoadScreen(Sokoban3D game, SceneManager sceneManager, Texture2D background)
            : base (game, files(), sceneManager, background)
        {
            this.game = game;
            this.savegames = files();
        }
        /// <summary>
        /// lists the files in the save directory if it exists and adds them to the menu list
        /// to be selected for loading.
        /// </summary>
        /// <returns>string array containing the filenames in save folder and game menu and exit</returns>
        private static String[] files() 
        {
            List<String> lines = new List<String>();

            if (Directory.Exists("Save"))
            {
                DirectoryInfo saves = new DirectoryInfo("Save");
                FileInfo[] info = saves.GetFiles("*.sav");

                if (info != null)
                {
                    foreach (FileInfo file in info)
                    {
                        lines.Add(file.Name);
                    }
                }
            }
            else
            {
                Directory.CreateDirectory("Save");
            }
            lines.Add("Game Menu");
            lines.Add("Main Menu");
            return lines.ToArray();
        }
                public void handleInput()
        {
            KeyboardState keyboardState = Keyboard.GetState();
            if (CheckEnterA())
            {
                if (base.menu.SelectedIndex == savegames.GetLength(0) - 2)
                    this.game.cScreen = Sokoban3D.Screens.Menu;
                else if (base.menu.SelectedIndex == savegames.GetLength(0) - 1)
                    this.game.cScreen = Sokoban3D.Screens.Start;
                else
                {
                    this.game.loadGame(savegames[base.menu.SelectedIndex]);
                    this.game.cScreen = Sokoban3D.Screens.Game;
                }
            }
            oldKeyboardState = Keyboard.GetState();
        }
        public override void update(GameTime gameTime)
        {
            if (this.visible)
            {
                menu.Update(gameTime);

                handleInput();

                base.Update(gameTime);
            }
        }

        /// <summary>
        /// function that checks if enter is pressed
        /// </summary>
        /// <returns></returns>
        private bool CheckEnterA()
        {
            KeyboardState keyboardState = Keyboard.GetState();

            bool enter = (oldKeyboardState.IsKeyDown(Keys.Enter) &&
                (keyboardState.IsKeyUp(Keys.Enter)));

            oldKeyboardState = keyboardState;

            return enter;
        }
    }
}