﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;
using Sokoban3D;
using Sokoban3D.Scenes;

namespace Sokoban3D.Screens
{
    /// <summary>
    /// screen derivate to present a different menu while a level is in progress
    /// </summary>
    public class MenuScreen : Screen
    {
        Sokoban3D game;
        protected KeyboardState oldKeyboardState;

        public MenuScreen(Sokoban3D game, SceneManager sceneManager, Texture2D background)
            : base(game, new string[] { "Resume", "Save Game", "Load Game", "Restart", "Main Menu" }, sceneManager, background)
        {
            this.game = game;

            oldKeyboardState = Keyboard.GetState();
            base.sceneManager.visible = true;
        }
        public void handleInput()
        {
            KeyboardState keyboardState = Keyboard.GetState();
            if (CheckEnterA())
            {
                switch (base.menu.SelectedIndex)
                {
                    case 0:
                        this.game.cScreen = Sokoban3D.Screens.Game;
                        break;
                    case 1:
                        this.game.cScreen = Sokoban3D.Screens.Save;
                        break;
                    case 2:
                        this.game.cScreen = Sokoban3D.Screens.Load;
                        break;
                    case 3:
                        this.sceneManager.sceneRestart();
                        this.game.cScreen = Sokoban3D.Screens.Game;
                        break;
                    case 4:
                        this.game.cScreen = Sokoban3D.Screens.Start;
                        break;
                    default:
                        break;
                }
            }
            oldKeyboardState = Keyboard.GetState();
        }
        public override void update(GameTime gameTime)
        {
            if (this.visible)
            {
                menu.Update(gameTime);

                handleInput();

                base.Update(gameTime);
            }
        }
        private bool CheckEnterA()
        {
            KeyboardState keyboardState = Keyboard.GetState();

            bool result = (oldKeyboardState.IsKeyDown(Keys.Enter) &&
                (keyboardState.IsKeyUp(Keys.Enter)));

            oldKeyboardState = keyboardState;

            return result;
        }
    }
}

