﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework;
using Sokoban3D;
using Sokoban3D.Scenes;

namespace Sokoban3D.Screens
{
    /// <summary>
    /// screen derivate to display alterable option values
    /// </summary>
    public class OptionsScreen : Screen
    {
        Sokoban3D game;
        protected KeyboardState oldKeyboardState;

        public OptionsScreen(Sokoban3D game, SceneManager sceneManager, Texture2D background)
            : base(game, new string[] { "Sounds " + game.sound.ToString(), "Main Menu" }, sceneManager, background)
        {
            this.game = game;
            oldKeyboardState = Keyboard.GetState();
        }
        /// <summary>
        /// function to handle input given to the screen.
        /// </summary>
        public void handleInput()
        {
            KeyboardState keyboardState = Keyboard.GetState();
            if (CheckEnterA())
            {
                switch (base.menu.SelectedIndex)
                {
                    case 0:
                        this.game.sound = !this.game.sound;
                        this.visible = false;
                        this.game.updateOptions();
                        break;
                    case 1:
                        this.game.cScreen = Sokoban3D.Screens.Start;
                        break;
                    default:
                        break;
                }
            }
            oldKeyboardState = Keyboard.GetState();
        }
        public override void update(GameTime gameTime)
        {
            if (this.visible)
            {
                menu.Update(gameTime);

                handleInput();

                base.Update(gameTime);
            }
        }
        private bool CheckEnterA()
        {
            KeyboardState keyboardState = Keyboard.GetState();

            bool result = (oldKeyboardState.IsKeyDown(Keys.Enter) &&
                (keyboardState.IsKeyUp(Keys.Enter)));

            oldKeyboardState = keyboardState;

            return result;
        }
    }
}
