﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;
using Sokoban3D;
using Sokoban3D.Scenes;

namespace Sokoban3D.Screens
{
    /// <summary>
    /// screen derivate to display the "main menu" with all the most important screen and game transitions
    /// </summary>
    public class StartScreen : Screen
    {
        private Sokoban3D game;
        protected KeyboardState oldKeyboardState;

        public StartScreen(Sokoban3D game, SceneManager sceneManager, Texture2D background)
            : base(game, new string[] { "New game", "Load Game", "Options", "Help", "Quit" }, sceneManager, background)
        {
            this.game = game;
            oldKeyboardState = Keyboard.GetState();
        }

        /// <summary>
        /// handleInput is called when someone presses enter inside the start screen
        /// </summary>
        public void handleInput()
        {
            KeyboardState keyboardState = Keyboard.GetState();
            if (CheckEnterA())
            {
                switch (base.menu.SelectedIndex)
                {
                    case 0:
                        this.game.cScreen = Sokoban3D.Screens.New;
                        break;
                    case 1:
                        this.game.cScreen = Sokoban3D.Screens.Load;
                        break;
                    case 2:
                        this.game.cScreen = Sokoban3D.Screens.Options;
                        break;
                    case 3:
                        this.game.cScreen = Sokoban3D.Screens.Help;
                        break;
                    case 4:
                        this.game.Exit();
                        break;
                }
            }
            oldKeyboardState = Keyboard.GetState();
        }

        public override void update(GameTime gameTime)
        {
            if (this.visible)
            {
                menu.Update(gameTime);

                handleInput();

                base.Update(gameTime);
            }
        }

        private bool CheckEnterA()
        {
            KeyboardState keyboardState = Keyboard.GetState();

            bool result = (oldKeyboardState.IsKeyDown(Keys.Enter) &&
                (keyboardState.IsKeyUp(Keys.Enter)));

            oldKeyboardState = keyboardState;

            return result;
        }
    }
}
