/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import org.apache.batik.apps.svgbrowser.Resources;
import org.apache.batik.ext.swing.GridBagConstants;
import org.apache.batik.ext.swing.JGridBagPanel;

public class AboutDialog
extends JWindow
implements GridBagConstants {
    public static final String ICON_BATIK_SPLASH = "AboutDialog.icon.batik.splash";
    public static final String ICON_APACHE_LOGO = "AboutDialog.icon.apache.logo";
    public static final String LABEL_APACHE_BATIK_PROJECT = "AboutDialog.label.apache.batik.project";
    public static final String LABEL_CONTRIBUTORS = "AboutDialog.label.contributors";
    public static final String LABEL_DEVELOPMENT_BUILD = "AboutDialog.label.development.build";

    public AboutDialog() {
        this.buildGUI();
    }

    public AboutDialog(Frame frame) {
        super(frame);
        this.buildGUI();
        this.setLocationRelativeTo(frame);
    }

    public void setLocationRelativeTo(Frame frame) {
        Dimension dimension = frame.getSize();
        Point point = frame.getLocation();
        Point point2 = new Point(point.x, point.y);
        Rectangle rectangle = this.getBounds();
        int n = point2.x + (dimension.width - rectangle.width) / 2;
        int n2 = point2.y + (dimension.height - rectangle.height) / 2;
        Dimension dimension2 = this.getToolkit().getScreenSize();
        if (n2 + rectangle.height > dimension2.height) {
            n2 = dimension2.height - rectangle.height;
            int n3 = n = point2.x < dimension2.width >> 1 ? point2.x + dimension.width : point2.x - rectangle.width;
        }
        if (n + rectangle.width > dimension2.width) {
            n = dimension2.width - rectangle.width;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        ((Component)this).setLocation(n, n2);
    }

    protected void buildGUI() {
        JGridBagPanel jGridBagPanel = new JGridBagPanel();
        jGridBagPanel.setBackground(Color.white);
        ClassLoader classLoader = this.getClass().getClassLoader();
        JGridBagPanel jGridBagPanel2 = new JGridBagPanel();
        jGridBagPanel2.setBackground(Color.white);
        jGridBagPanel2.add(new JLabel(new ImageIcon(classLoader.getResource(Resources.getString(ICON_APACHE_LOGO)))), 0, 0, 1, 1, 17, 0, 0.0, 0.0);
        jGridBagPanel2.add(new JLabel(Resources.getString(LABEL_APACHE_BATIK_PROJECT)), 1, 0, 1, 1, 17, 0, 0.0, 0.0);
        jGridBagPanel2.add(new JLabel(""), 2, 0, 1, 1, 17, 2, 1.0, 0.0);
        jGridBagPanel.add(jGridBagPanel2, 0, 0, 1, 1, 10, 2, 1.0, 0.0);
        jGridBagPanel.add(new JLabel(new ImageIcon(classLoader.getResource(Resources.getString(ICON_BATIK_SPLASH)))), 0, 1, 1, 1, 10, 0, 0.0, 0.0);
        String string = "$Name:  $";
        string = string.substring(6, string.length() - 1);
        if (string.trim().intern().equals("")) {
            string = Resources.getString(LABEL_DEVELOPMENT_BUILD);
        }
        jGridBagPanel.add(new JLabel(string), 0, 2, 1, 1, 13, 0, 0.0, 0.0);
        ((Component)this).setBackground(Color.white);
        this.getContentPane().setBackground(Color.white);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    ((Component)AboutDialog.this).setVisible(false);
                    AboutDialog.this.dispose();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ((Component)AboutDialog.this).setVisible(false);
                AboutDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.white);
        jPanel.add((Component)jGridBagPanel, "Center");
        JTextArea jTextArea = new JTextArea(Resources.getString(LABEL_CONTRIBUTORS)){
            {
                this.setLineWrap(true);
                this.setWrapStyleWord(true);
                this.setEnabled(false);
                this.setRows(7);
            }
        };
        jTextArea.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        jPanel.add((Component)jTextArea, "South");
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, Color.gray, Color.black), BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.black)), BorderFactory.createEmptyBorder(10, 10, 10, 10))));
        this.getContentPane().add(jPanel);
    }

    public static void main(String[] stringArray) {
        AboutDialog aboutDialog = new AboutDialog();
        ((Component)aboutDialog).setVisible(true);
    }
}

