/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.PlainDocument;
import org.apache.batik.apps.svgbrowser.AboutDialog;
import org.apache.batik.apps.svgbrowser.Application;
import org.apache.batik.apps.svgbrowser.FindDialog;
import org.apache.batik.apps.svgbrowser.LocalHistory;
import org.apache.batik.apps.svgbrowser.StatusBar;
import org.apache.batik.apps.svgbrowser.ThumbnailDialog;
import org.apache.batik.apps.svgbrowser.TransformHistory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.ext.swing.JAffineTransformChooser;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.LinkActivationEvent;
import org.apache.batik.swing.svg.LinkActivationListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.swing.svg.SVGFileFilter;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import org.apache.batik.transcoder.print.PrintTranscoder;
import org.apache.batik.util.MimeTypeConstants;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.gui.DOMViewer;
import org.apache.batik.util.gui.LocationBar;
import org.apache.batik.util.gui.MemoryMonitor;
import org.apache.batik.util.gui.URIChooser;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.JComponentModifier;
import org.apache.batik.util.gui.resource.MenuFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceManager;
import org.apache.batik.util.gui.resource.ToolBarFactory;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGDocument;

public class JSVGViewerFrame
extends JFrame
implements ActionMap,
SVGDocumentLoaderListener,
GVTTreeBuilderListener,
GVTTreeRendererListener,
LinkActivationListener {
    public static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.GUI";
    public static final String ABOUT_ACTION = "AboutAction";
    public static final String OPEN_ACTION = "OpenAction";
    public static final String OPEN_LOCATION_ACTION = "OpenLocationAction";
    public static final String NEW_WINDOW_ACTION = "NewWindowAction";
    public static final String RELOAD_ACTION = "ReloadAction";
    public static final String BACK_ACTION = "BackAction";
    public static final String FORWARD_ACTION = "ForwardAction";
    public static final String PRINT_ACTION = "PrintAction";
    public static final String EXPORT_AS_JPG_ACTION = "ExportAsJPGAction";
    public static final String EXPORT_AS_PNG_ACTION = "ExportAsPNGAction";
    public static final String EXPORT_AS_TIFF_ACTION = "ExportAsTIFFAction";
    public static final String PREFERENCES_ACTION = "PreferencesAction";
    public static final String CLOSE_ACTION = "CloseAction";
    public static final String VIEW_SOURCE_ACTION = "ViewSourceAction";
    public static final String EXIT_ACTION = "ExitAction";
    public static final String RESET_TRANSFORM_ACTION = "ResetTransformAction";
    public static final String ZOOM_IN_ACTION = "ZoomInAction";
    public static final String ZOOM_OUT_ACTION = "ZoomOutAction";
    public static final String PREVIOUS_TRANSFORM_ACTION = "PreviousTransformAction";
    public static final String NEXT_TRANSFORM_ACTION = "NextTransformAction";
    public static final String STOP_ACTION = "StopAction";
    public static final String MONITOR_ACTION = "MonitorAction";
    public static final String DOM_VIEWER_ACTION = "DOMViewerAction";
    public static final String SET_TRANSFORM_ACTION = "SetTransformAction";
    public static final String FIND_DIALOG_ACTION = "FindDialogAction";
    public static final String THUMBNAIL_DIALOG_ACTION = "ThumbnailDialogAction";
    public static final String FLUSH_ACTION = "FlushAction";
    public static final Cursor WAIT_CURSOR = new Cursor(3);
    public static final Cursor DEFAULT_CURSOR = new Cursor(0);
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.GUI", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected Application application;
    protected JSVGCanvas svgCanvas;
    protected static JFrame memoryMonitorFrame;
    protected File currentPath = new File("");
    protected File currentExportPath = new File("");
    protected BackAction backAction = new BackAction();
    protected ForwardAction forwardAction = new ForwardAction();
    protected StopAction stopAction = new StopAction();
    protected PreviousTransformAction previousTransformAction = new PreviousTransformAction();
    protected NextTransformAction nextTransformAction = new NextTransformAction();
    protected boolean debug;
    protected boolean autoAdjust = true;
    protected SVGUserAgent userAgent = new UserAgent();
    protected SVGDocument svgDocument;
    protected URIChooser uriChooser;
    protected DOMViewer domViewer;
    protected FindDialog findDialog;
    protected ThumbnailDialog thumbnailDialog;
    protected JAffineTransformChooser.Dialog transformDialog;
    protected LocationBar locationBar;
    protected StatusBar statusBar;
    protected String title;
    protected LocalHistory localHistory;
    protected TransformHistory transformHistory = new TransformHistory();
    protected Map listeners = new HashMap();
    long time;

    public JSVGViewerFrame(Application application) {
        Object object;
        this.application = application;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JSVGViewerFrame.this.application.closeJSVGViewerFrame(JSVGViewerFrame.this);
            }
        });
        this.svgCanvas = new JSVGCanvas(this.userAgent, true, true);
        this.svgCanvas.setDoubleBufferedRendering(true);
        this.listeners.put(ABOUT_ACTION, new AboutAction());
        this.listeners.put(OPEN_ACTION, new OpenAction());
        this.listeners.put(OPEN_LOCATION_ACTION, new OpenLocationAction());
        this.listeners.put(NEW_WINDOW_ACTION, new NewWindowAction());
        this.listeners.put(RELOAD_ACTION, new ReloadAction());
        this.listeners.put(BACK_ACTION, this.backAction);
        this.listeners.put(FORWARD_ACTION, this.forwardAction);
        this.listeners.put(PRINT_ACTION, new PrintAction());
        this.listeners.put(EXPORT_AS_JPG_ACTION, new ExportAsJPGAction());
        this.listeners.put(EXPORT_AS_PNG_ACTION, new ExportAsPNGAction());
        this.listeners.put(EXPORT_AS_TIFF_ACTION, new ExportAsTIFFAction());
        this.listeners.put(PREFERENCES_ACTION, new PreferencesAction());
        this.listeners.put(CLOSE_ACTION, new CloseAction());
        this.listeners.put(EXIT_ACTION, this.application.createExitAction(this));
        this.listeners.put(VIEW_SOURCE_ACTION, new ViewSourceAction());
        javax.swing.ActionMap actionMap = this.svgCanvas.getActionMap();
        this.listeners.put(RESET_TRANSFORM_ACTION, actionMap.get("ResetTransform"));
        this.listeners.put(ZOOM_IN_ACTION, actionMap.get("ZoomIn"));
        this.listeners.put(ZOOM_OUT_ACTION, actionMap.get("ZoomOut"));
        this.listeners.put(PREVIOUS_TRANSFORM_ACTION, this.previousTransformAction);
        this.listeners.put(NEXT_TRANSFORM_ACTION, this.nextTransformAction);
        this.listeners.put(STOP_ACTION, this.stopAction);
        this.listeners.put(MONITOR_ACTION, new MonitorAction());
        this.listeners.put(DOM_VIEWER_ACTION, new DOMViewerAction());
        this.listeners.put(SET_TRANSFORM_ACTION, new SetTransformAction());
        this.listeners.put(FIND_DIALOG_ACTION, new FindDialogAction());
        this.listeners.put(THUMBNAIL_DIALOG_ACTION, new ThumbnailDialogAction());
        this.listeners.put(FLUSH_ACTION, new FlushAction());
        JPanel jPanel = null;
        try {
            object = new MenuFactory(bundle, this);
            JMenuBar jMenuBar = ((MenuFactory)object).createJMenuBar("MenuBar");
            this.setJMenuBar(jMenuBar);
            this.localHistory = new LocalHistory(jMenuBar, this.svgCanvas);
            jPanel = new JPanel(new BorderLayout());
            ToolBarFactory toolBarFactory = new ToolBarFactory(bundle, this);
            JToolBar jToolBar = toolBarFactory.createJToolBar("ToolBar");
            jToolBar.setFloatable(false);
            this.getContentPane().add((Component)jPanel, "North");
            jPanel.add((Component)jToolBar, "North");
            jPanel.add((Component)new JSeparator(), "Center");
            this.locationBar = new LocationBar();
            jPanel.add((Component)this.locationBar, "South");
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(missingResourceException.getMessage());
            System.exit(0);
        }
        object = new JPanel(new BorderLayout());
        ((JComponent)object).setBorder(BorderFactory.createEtchedBorder());
        ((Container)object).add((Component)this.svgCanvas, "Center");
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)object, "Center");
        this.statusBar = new StatusBar();
        jPanel.add((Component)this.statusBar, "South");
        this.getContentPane().add((Component)jPanel, "Center");
        this.svgCanvas.addSVGDocumentLoaderListener(this);
        this.svgCanvas.addGVTTreeBuilderListener(this);
        this.svgCanvas.addGVTTreeRendererListener(this);
        this.svgCanvas.addLinkActivationListener(this);
        this.svgCanvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (JSVGViewerFrame.this.svgDocument == null) {
                    JSVGViewerFrame.this.statusBar.setXPosition(mouseEvent.getX());
                    JSVGViewerFrame.this.statusBar.setYPosition(mouseEvent.getY());
                } else {
                    try {
                        AffineTransform affineTransform = JSVGViewerFrame.this.svgCanvas.getRenderingTransform();
                        if (affineTransform != null) {
                            affineTransform = affineTransform.createInverse();
                            Point2D point2D = affineTransform.transform(new Point2D.Float(mouseEvent.getX(), mouseEvent.getY()), null);
                            JSVGViewerFrame.this.statusBar.setXPosition((float)point2D.getX());
                            JSVGViewerFrame.this.statusBar.setYPosition((float)point2D.getY());
                            return;
                        }
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    JSVGViewerFrame.this.statusBar.setXPosition(mouseEvent.getX());
                    JSVGViewerFrame.this.statusBar.setYPosition(mouseEvent.getY());
                }
            }
        });
        this.svgCanvas.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                Dimension dimension = JSVGViewerFrame.this.svgCanvas.getSize();
                if (JSVGViewerFrame.this.svgDocument == null) {
                    JSVGViewerFrame.this.statusBar.setWidth(dimension.width);
                    JSVGViewerFrame.this.statusBar.setHeight(dimension.height);
                } else {
                    try {
                        AffineTransform affineTransform = JSVGViewerFrame.this.svgCanvas.getRenderingTransform();
                        if (affineTransform != null) {
                            affineTransform = affineTransform.createInverse();
                            Point2D point2D = affineTransform.transform(new Point2D.Float(0.0f, 0.0f), null);
                            Point2D point2D2 = affineTransform.transform(new Point2D.Float(dimension.width, dimension.height), null);
                            JSVGViewerFrame.this.statusBar.setWidth((float)(point2D2.getX() - point2D.getX()));
                            JSVGViewerFrame.this.statusBar.setHeight((float)(point2D2.getY() - point2D.getY()));
                            return;
                        }
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    JSVGViewerFrame.this.statusBar.setWidth(dimension.width);
                    JSVGViewerFrame.this.statusBar.setHeight(dimension.height);
                }
            }
        });
        this.svgCanvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = JSVGViewerFrame.this.svgCanvas.getSize();
                if (JSVGViewerFrame.this.svgDocument == null) {
                    JSVGViewerFrame.this.statusBar.setWidth(dimension.width);
                    JSVGViewerFrame.this.statusBar.setHeight(dimension.height);
                } else {
                    try {
                        AffineTransform affineTransform = JSVGViewerFrame.this.svgCanvas.getRenderingTransform();
                        if (affineTransform != null) {
                            affineTransform = affineTransform.createInverse();
                            Point2D point2D = affineTransform.transform(new Point2D.Float(0.0f, 0.0f), null);
                            Point2D point2D2 = affineTransform.transform(new Point2D.Float(dimension.width, dimension.height), null);
                            JSVGViewerFrame.this.statusBar.setWidth((float)(point2D2.getX() - point2D.getX()));
                            JSVGViewerFrame.this.statusBar.setHeight((float)(point2D2.getY() - point2D.getY()));
                            return;
                        }
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    JSVGViewerFrame.this.statusBar.setWidth(dimension.width);
                    JSVGViewerFrame.this.statusBar.setHeight(dimension.height);
                }
            }
        });
        this.locationBar.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JSVGViewerFrame.this.locationBar.getText().trim();
                int n = string.indexOf("#");
                String string2 = "";
                if (n != -1) {
                    string2 = string.substring(n + 1);
                    string = string.substring(0, n);
                }
                if (!string.equals("")) {
                    Serializable serializable;
                    block14: {
                        try {
                            serializable = new File(string);
                            if (!((File)serializable).exists()) break block14;
                            if (((File)serializable).isDirectory()) {
                                string = null;
                                break block14;
                            }
                            try {
                                string = ((File)serializable).getCanonicalPath();
                                if (string.startsWith("/")) {
                                    string = "file:" + string;
                                    break block14;
                                }
                                string = "file:/" + string;
                            }
                            catch (IOException iOException) {}
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    if (string != null) {
                        if (JSVGViewerFrame.this.svgDocument != null) {
                            try {
                                serializable = (SVGOMDocument)JSVGViewerFrame.this.svgDocument;
                                URL uRL = ((SVGOMDocument)serializable).getURLObject();
                                URL uRL2 = new URL(uRL, string);
                                String string3 = JSVGViewerFrame.this.svgCanvas.getFragmentIdentifier();
                                String string4 = string3 = string3 == null ? "" : string3;
                                if (uRL.equals(uRL2) && string2.equals(string3)) {
                                    return;
                                }
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                        if (string2.length() != 0) {
                            string = string + "#" + string2;
                        }
                        JSVGViewerFrame.this.locationBar.setText(string);
                        JSVGViewerFrame.this.locationBar.addToHistory(string);
                        JSVGViewerFrame.this.svgCanvas.loadSVGDocument(string);
                    }
                }
            }
        });
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setAutoAdjust(boolean bl) {
        this.autoAdjust = bl;
    }

    public JSVGCanvas getJSVGCanvas() {
        return this.svgCanvas;
    }

    private static File makeAbsolute(File file) {
        if (!file.isAbsolute()) {
            return file.getAbsoluteFile();
        }
        return file;
    }

    public Action getAction(String string) throws MissingListenerException {
        Action action = (Action)this.listeners.get(string);
        if (action == null) {
            throw new MissingListenerException("Can't find action.", RESOURCES, string);
        }
        return action;
    }

    public void documentLoadingStarted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
        if (this.debug) {
            System.out.println("Load started...");
            this.time = System.currentTimeMillis();
        }
        this.statusBar.setMainMessage(resources.getString("Message.documentLoad"));
        this.stopAction.update(true);
        this.svgCanvas.setCursor(WAIT_CURSOR);
    }

    public void documentLoadingCompleted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
        String string;
        if (this.debug) {
            System.out.print("Load completed in ");
            System.out.println(System.currentTimeMillis() - this.time + " ms");
        }
        this.svgDocument = sVGDocumentLoaderEvent.getSVGDocument();
        if (this.domViewer != null) {
            if (this.domViewer.isVisible()) {
                this.domViewer.setDocument(this.svgDocument, (ViewCSS)((Object)this.svgDocument.getDocumentElement()));
            } else {
                this.domViewer.dispose();
                this.domViewer = null;
            }
        }
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
        String string2 = ((SVGOMDocument)this.svgDocument).getURLObject().toString();
        String string3 = this.svgCanvas.getFragmentIdentifier();
        if (string3 != null) {
            string2 = string2 + "#" + string3;
        }
        this.locationBar.setText(string2);
        if (this.title == null) {
            this.title = this.getTitle();
        }
        if ((string = this.svgDocument.getTitle()).length() != 0) {
            this.setTitle(this.title + ":" + string);
        } else {
            int n = string2.lastIndexOf("/");
            if (n == -1) {
                n = string2.lastIndexOf("\\");
                if (n == -1) {
                    this.setTitle(this.title + ":" + string2);
                } else {
                    this.setTitle(this.title + ":" + string2.substring(n + 1));
                }
            } else {
                this.setTitle(this.title + ":" + string2.substring(n + 1));
            }
        }
        this.localHistory.update(string2);
        this.backAction.update();
        this.forwardAction.update();
        this.transformHistory = new TransformHistory();
        this.previousTransformAction.update();
        this.nextTransformAction.update();
    }

    public void documentLoadingCancelled(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
        if (this.debug) {
            System.out.println("Load cancelled");
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(resources.getString("Message.documentCancelled"));
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
    }

    public void documentLoadingFailed(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
        if (this.debug) {
            System.out.println("Load failed");
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(resources.getString("Message.documentFailed"));
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
    }

    public void gvtBuildStarted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
        if (this.debug) {
            System.out.println("Build started...");
            this.time = System.currentTimeMillis();
        }
        this.statusBar.setMainMessage(resources.getString("Message.treeBuild"));
        this.stopAction.update(true);
        this.svgCanvas.setCursor(WAIT_CURSOR);
    }

    public void gvtBuildCompleted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
        if (this.debug) {
            System.out.print("Build completed in ");
            System.out.println(System.currentTimeMillis() - this.time + " ms");
        }
        if (this.findDialog != null) {
            if (this.findDialog.isVisible()) {
                this.findDialog.setGraphicsNode(this.svgCanvas.getGraphicsNode());
            } else {
                this.findDialog.dispose();
                this.findDialog = null;
            }
        }
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
        if (this.autoAdjust) {
            this.pack();
        }
    }

    public void gvtBuildCancelled(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
        if (this.debug) {
            System.out.println("Build cancelled");
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(resources.getString("Message.treeCancelled"));
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
    }

    public void gvtBuildFailed(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
        if (this.debug) {
            System.out.println("Build failed");
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(resources.getString("Message.treeFailed"));
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
        if (this.autoAdjust) {
            this.pack();
        }
    }

    public void gvtRenderingPrepare(GVTTreeRendererEvent gVTTreeRendererEvent) {
        if (this.debug) {
            System.out.println("Rendering preparation...");
            this.time = System.currentTimeMillis();
        }
        this.stopAction.update(true);
        this.svgCanvas.setCursor(WAIT_CURSOR);
        this.statusBar.setMainMessage(resources.getString("Message.treeRendering"));
    }

    public void gvtRenderingStarted(GVTTreeRendererEvent gVTTreeRendererEvent) {
        if (this.debug) {
            System.out.print("Rendering prepared in ");
            System.out.println(System.currentTimeMillis() - this.time + " ms");
            this.time = System.currentTimeMillis();
            System.out.println("Rendering started...");
        }
    }

    public void gvtRenderingCompleted(GVTTreeRendererEvent gVTTreeRendererEvent) {
        if (this.debug) {
            System.out.print("Rendering completed in ");
            System.out.println(System.currentTimeMillis() - this.time + " ms");
        }
        this.statusBar.setMainMessage("");
        this.statusBar.setMessage(resources.getString("Message.done"));
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
        this.transformHistory.update(this.svgCanvas.getRenderingTransform());
        this.previousTransformAction.update();
        this.nextTransformAction.update();
    }

    public void gvtRenderingCancelled(GVTTreeRendererEvent gVTTreeRendererEvent) {
        if (this.debug) {
            System.out.println("Rendering cancelled");
        }
        this.statusBar.setMainMessage("");
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
    }

    public void gvtRenderingFailed(GVTTreeRendererEvent gVTTreeRendererEvent) {
        if (this.debug) {
            System.out.println("Rendering failed");
        }
        this.statusBar.setMainMessage("");
        this.stopAction.update(false);
        this.svgCanvas.setCursor(DEFAULT_CURSOR);
    }

    public void linkActivated(LinkActivationEvent linkActivationEvent) {
        String string = linkActivationEvent.getReferencedURI();
        if (this.svgDocument != null) {
            try {
                SVGOMDocument sVGOMDocument = (SVGOMDocument)this.svgDocument;
                URL uRL = sVGOMDocument.getURLObject();
                URL uRL2 = new URL(uRL, string);
                if (!uRL2.sameFile(uRL)) {
                    return;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (string.indexOf("#") != -1) {
                this.localHistory.update(linkActivationEvent.getReferencedURI());
                this.backAction.update();
                this.forwardAction.update();
                this.transformHistory = new TransformHistory();
                this.previousTransformAction.update();
                this.nextTransformAction.update();
            }
        }
    }

    protected static class ImageFileFilter
    extends FileFilter {
        protected String extension;

        public ImageFileFilter(String string) {
            this.extension = string;
        }

        public boolean accept(File file) {
            boolean bl = false;
            String string = null;
            if (file != null) {
                if (file.isDirectory()) {
                    bl = true;
                } else {
                    string = file.getPath().toLowerCase();
                    if (string.endsWith(this.extension)) {
                        bl = true;
                    }
                }
            }
            return bl;
        }

        public String getDescription() {
            return this.extension;
        }
    }

    protected class UserAgent
    implements SVGUserAgent {
        protected UserAgent() {
        }

        public void displayError(String string) {
            JOptionPane jOptionPane = new JOptionPane(string, 0);
            JDialog jDialog = jOptionPane.createDialog(JSVGViewerFrame.this, "ERROR");
            jDialog.setModal(false);
            jDialog.show();
        }

        public void displayError(Exception exception) {
            if (JSVGViewerFrame.this.debug) {
                exception.printStackTrace();
            }
            this.displayError(exception.getMessage());
        }

        public void displayMessage(String string) {
            JSVGViewerFrame.this.statusBar.setMessage(string);
        }

        public float getPixelToMM() {
            return 0.26458332f;
        }

        public String getLanguages() {
            return JSVGViewerFrame.this.application.getLanguages();
        }

        public String getUserStyleSheetURI() {
            return JSVGViewerFrame.this.application.getUserStyleSheetURI();
        }

        public String getXMLParserClassName() {
            return JSVGViewerFrame.this.application.getXMLParserClassName();
        }

        public void openLink(String string, boolean bl) {
            if (bl) {
                JSVGViewerFrame.this.application.openLink(string);
            } else {
                JSVGViewerFrame.this.svgCanvas.loadSVGDocument(string);
            }
        }

        public boolean supportExtension(String string) {
            return false;
        }

        public void handleElement(Element element, Object object) {
        }
    }

    public class DOMViewerAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.domViewer == null) {
                JSVGViewerFrame.this.domViewer = new DOMViewer();
                if (JSVGViewerFrame.this.svgDocument != null) {
                    JSVGViewerFrame.this.domViewer.setDocument(JSVGViewerFrame.this.svgDocument, (ViewCSS)((Object)JSVGViewerFrame.this.svgDocument.getDocumentElement()));
                }
                Rectangle rectangle = JSVGViewerFrame.this.getBounds();
                Dimension dimension = JSVGViewerFrame.this.domViewer.getSize();
                ((Component)JSVGViewerFrame.this.domViewer).setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            }
            JSVGViewerFrame.this.domViewer.show();
        }
    }

    public class ThumbnailDialogAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.thumbnailDialog == null) {
                JSVGViewerFrame.this.thumbnailDialog = new ThumbnailDialog((Frame)JSVGViewerFrame.this, JSVGViewerFrame.this.svgCanvas);
                JSVGViewerFrame.this.thumbnailDialog.pack();
                Rectangle rectangle = JSVGViewerFrame.this.getBounds();
                Dimension dimension = JSVGViewerFrame.this.thumbnailDialog.getSize();
                ((Component)JSVGViewerFrame.this.thumbnailDialog).setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            }
            JSVGViewerFrame.this.thumbnailDialog.show();
        }
    }

    public class FindDialogAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.findDialog == null) {
                JSVGViewerFrame.this.findDialog = new FindDialog((Frame)JSVGViewerFrame.this, JSVGViewerFrame.this.svgCanvas);
                JSVGViewerFrame.this.findDialog.setGraphicsNode(JSVGViewerFrame.this.svgCanvas.getGraphicsNode());
                JSVGViewerFrame.this.findDialog.pack();
                Rectangle rectangle = JSVGViewerFrame.this.getBounds();
                Dimension dimension = JSVGViewerFrame.this.findDialog.getSize();
                ((Component)JSVGViewerFrame.this.findDialog).setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            }
            JSVGViewerFrame.this.findDialog.show();
        }
    }

    public class MonitorAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (memoryMonitorFrame == null) {
                memoryMonitorFrame = new MemoryMonitor();
                Rectangle rectangle = JSVGViewerFrame.this.getBounds();
                Dimension dimension = memoryMonitorFrame.getSize();
                ((Component)memoryMonitorFrame).setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            }
            memoryMonitorFrame.show();
        }
    }

    public class SetTransformAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            AffineTransform affineTransform;
            if (JSVGViewerFrame.this.transformDialog == null) {
                JSVGViewerFrame.this.transformDialog = JAffineTransformChooser.createDialog(JSVGViewerFrame.this, resources.getString("SetTransform.title"));
            }
            if ((affineTransform = JSVGViewerFrame.this.transformDialog.showDialog()) != null) {
                AffineTransform affineTransform2 = JSVGViewerFrame.this.svgCanvas.getRenderingTransform();
                if (affineTransform2 == null) {
                    affineTransform2 = new AffineTransform();
                }
                affineTransform.concatenate(affineTransform2);
                JSVGViewerFrame.this.svgCanvas.setRenderingTransform(affineTransform);
            }
        }
    }

    public class StopAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
            JSVGViewerFrame.this.svgCanvas.stopProcessing();
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        public void update(boolean bl) {
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }

    public class NextTransformAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.transformHistory.canGoForward()) {
                JSVGViewerFrame.this.transformHistory.forward();
                this.update();
                JSVGViewerFrame.this.previousTransformAction.update();
                JSVGViewerFrame.this.svgCanvas.setRenderingTransform(JSVGViewerFrame.this.transformHistory.currentTransform());
            }
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        protected void update() {
            boolean bl = JSVGViewerFrame.this.transformHistory.canGoForward();
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }

    public class PreviousTransformAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.transformHistory.canGoBack()) {
                JSVGViewerFrame.this.transformHistory.back();
                this.update();
                JSVGViewerFrame.this.nextTransformAction.update();
                JSVGViewerFrame.this.svgCanvas.setRenderingTransform(JSVGViewerFrame.this.transformHistory.currentTransform());
            }
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        protected void update() {
            boolean bl = JSVGViewerFrame.this.transformHistory.canGoBack();
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }

    public class FlushAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JSVGViewerFrame.this.svgCanvas.flush();
            JSVGViewerFrame.this.svgCanvas.setRenderingTransform(JSVGViewerFrame.this.svgCanvas.getRenderingTransform());
        }
    }

    public class ViewSourceAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.svgDocument == null) {
                return;
            }
            ParsedURL parsedURL = new ParsedURL(((SVGOMDocument)JSVGViewerFrame.this.svgDocument).getURLObject());
            JFrame jFrame = new JFrame(parsedURL.toString());
            ((Component)jFrame).setSize(resources.getInteger("ViewSource.width"), resources.getInteger("ViewSource.height"));
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setFont(new Font("monospaced", 0, 12));
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(jTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jFrame.getContentPane().add((Component)jScrollPane, "Center");
            new Thread(this, parsedURL, jTextArea, jFrame){
                private final /* synthetic */ ParsedURL val$u;
                private final /* synthetic */ JTextArea val$ta;
                private final /* synthetic */ JFrame val$fr;
                private final /* synthetic */ ViewSourceAction this$1;
                {
                    this.this$1 = viewSourceAction;
                    this.val$u = parsedURL;
                    this.val$ta = jTextArea;
                    this.val$fr = jFrame;
                }

                public void run() {
                    char[] cArray = new char[4096];
                    try {
                        int n;
                        PlainDocument plainDocument = new PlainDocument();
                        InputStream inputStream = this.val$u.openStream(MimeTypeConstants.MIME_TYPES_SVG);
                        Reader reader = XMLUtilities.createXMLDocumentReader(inputStream);
                        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                            plainDocument.insertString(plainDocument.getLength(), new String(cArray, 0, n), null);
                        }
                        this.val$ta.setDocument(plainDocument);
                        this.val$ta.setEditable(false);
                        this.val$ta.setBackground(Color.white);
                        this.val$fr.show();
                    }
                    catch (Exception exception) {
                        ViewSourceAction.access$500((ViewSourceAction)this.this$1).userAgent.displayError(exception);
                    }
                }
            }.start();
        }

        static /* synthetic */ JSVGViewerFrame access$500(ViewSourceAction viewSourceAction) {
            return viewSourceAction.JSVGViewerFrame.this;
        }
    }

    public class ExportAsTIFFAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(JSVGViewerFrame.makeAbsolute(JSVGViewerFrame.this.currentExportPath));
            jFileChooser.setDialogTitle(resources.getString("ExportAsTIFF.title"));
            jFileChooser.setFileHidingEnabled(false);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.addChoosableFileFilter(new ImageFileFilter(".tiff"));
            int n = jFileChooser.showSaveDialog(JSVGViewerFrame.this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                BufferedImage bufferedImage = JSVGViewerFrame.this.svgCanvas.getOffScreen();
                if (bufferedImage != null) {
                    JSVGViewerFrame.this.statusBar.setMessage(resources.getString("Message.exportAsTIFF"));
                    int n2 = bufferedImage.getWidth();
                    int n3 = bufferedImage.getHeight();
                    TIFFTranscoder tIFFTranscoder = new TIFFTranscoder();
                    tIFFTranscoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME, JSVGViewerFrame.this.application.getXMLParserClassName());
                    BufferedImage bufferedImage2 = ((ImageTranscoder)tIFFTranscoder).createImage(n2, n3);
                    Graphics2D graphics2D = bufferedImage2.createGraphics();
                    graphics2D.drawImage(bufferedImage, null, 0, 0);
                    new Thread(this, file, tIFFTranscoder, bufferedImage2){
                        private final /* synthetic */ File val$f;
                        private final /* synthetic */ ImageTranscoder val$trans;
                        private final /* synthetic */ BufferedImage val$img;
                        private final /* synthetic */ ExportAsTIFFAction this$1;
                        {
                            this.this$1 = exportAsTIFFAction;
                            this.val$f = file;
                            this.val$trans = imageTranscoder;
                            this.val$img = bufferedImage;
                        }

                        public void run() {
                            try {
                                ExportAsTIFFAction.access$400((ExportAsTIFFAction)this.this$1).currentExportPath = this.val$f;
                                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.val$f));
                                this.val$trans.writeImage(this.val$img, new TranscoderOutput(bufferedOutputStream));
                                ((OutputStream)bufferedOutputStream).flush();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ExportAsTIFFAction.access$400((ExportAsTIFFAction)this.this$1).statusBar.setMessage(resources.getString("Message.done"));
                        }
                    }.start();
                }
            }
        }

        static /* synthetic */ JSVGViewerFrame access$400(ExportAsTIFFAction exportAsTIFFAction) {
            return exportAsTIFFAction.JSVGViewerFrame.this;
        }
    }

    public class ExportAsPNGAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(JSVGViewerFrame.makeAbsolute(JSVGViewerFrame.this.currentExportPath));
            jFileChooser.setDialogTitle(resources.getString("ExportAsPNG.title"));
            jFileChooser.setFileHidingEnabled(false);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.addChoosableFileFilter(new ImageFileFilter(".png"));
            int n = jFileChooser.showSaveDialog(JSVGViewerFrame.this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                BufferedImage bufferedImage = JSVGViewerFrame.this.svgCanvas.getOffScreen();
                if (bufferedImage != null) {
                    JSVGViewerFrame.this.statusBar.setMessage(resources.getString("Message.exportAsPNG"));
                    int n2 = bufferedImage.getWidth();
                    int n3 = bufferedImage.getHeight();
                    PNGTranscoder pNGTranscoder = new PNGTranscoder();
                    pNGTranscoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME, JSVGViewerFrame.this.application.getXMLParserClassName());
                    pNGTranscoder.addTranscodingHint(PNGTranscoder.KEY_FORCE_TRANSPARENT_WHITE, new Boolean(true));
                    BufferedImage bufferedImage2 = ((ImageTranscoder)pNGTranscoder).createImage(n2, n3);
                    Graphics2D graphics2D = bufferedImage2.createGraphics();
                    graphics2D.drawImage(bufferedImage, null, 0, 0);
                    new Thread(this, file, pNGTranscoder, bufferedImage2){
                        private final /* synthetic */ File val$f;
                        private final /* synthetic */ ImageTranscoder val$trans;
                        private final /* synthetic */ BufferedImage val$img;
                        private final /* synthetic */ ExportAsPNGAction this$1;
                        {
                            this.this$1 = exportAsPNGAction;
                            this.val$f = file;
                            this.val$trans = imageTranscoder;
                            this.val$img = bufferedImage;
                        }

                        public void run() {
                            try {
                                ExportAsPNGAction.access$300((ExportAsPNGAction)this.this$1).currentExportPath = this.val$f;
                                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.val$f));
                                this.val$trans.writeImage(this.val$img, new TranscoderOutput(bufferedOutputStream));
                                ((OutputStream)bufferedOutputStream).flush();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ExportAsPNGAction.access$300((ExportAsPNGAction)this.this$1).statusBar.setMessage(resources.getString("Message.done"));
                        }
                    }.start();
                }
            }
        }

        static /* synthetic */ JSVGViewerFrame access$300(ExportAsPNGAction exportAsPNGAction) {
            return exportAsPNGAction.JSVGViewerFrame.this;
        }
    }

    public class ExportAsJPGAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(JSVGViewerFrame.makeAbsolute(JSVGViewerFrame.this.currentExportPath));
            jFileChooser.setDialogTitle(resources.getString("ExportAsJPG.title"));
            jFileChooser.setFileHidingEnabled(false);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.addChoosableFileFilter(new ImageFileFilter(".jpg"));
            int n = jFileChooser.showSaveDialog(JSVGViewerFrame.this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                BufferedImage bufferedImage = JSVGViewerFrame.this.svgCanvas.getOffScreen();
                if (bufferedImage != null) {
                    JSVGViewerFrame.this.statusBar.setMessage(resources.getString("Message.exportAsJPG"));
                    int n2 = bufferedImage.getWidth();
                    int n3 = bufferedImage.getHeight();
                    JPEGTranscoder jPEGTranscoder = new JPEGTranscoder();
                    jPEGTranscoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME, JSVGViewerFrame.this.application.getXMLParserClassName());
                    BufferedImage bufferedImage2 = ((ImageTranscoder)jPEGTranscoder).createImage(n2, n3);
                    Graphics2D graphics2D = bufferedImage2.createGraphics();
                    graphics2D.setColor(Color.white);
                    graphics2D.fillRect(0, 0, n2, n3);
                    graphics2D.drawImage(bufferedImage, null, 0, 0);
                    new Thread(this, file, jPEGTranscoder, bufferedImage2){
                        private final /* synthetic */ File val$f;
                        private final /* synthetic */ ImageTranscoder val$trans;
                        private final /* synthetic */ BufferedImage val$img;
                        private final /* synthetic */ ExportAsJPGAction this$1;
                        {
                            this.this$1 = exportAsJPGAction;
                            this.val$f = file;
                            this.val$trans = imageTranscoder;
                            this.val$img = bufferedImage;
                        }

                        public void run() {
                            try {
                                ExportAsJPGAction.access$200((ExportAsJPGAction)this.this$1).currentExportPath = this.val$f;
                                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.val$f));
                                this.val$trans.writeImage(this.val$img, new TranscoderOutput(bufferedOutputStream));
                                ((OutputStream)bufferedOutputStream).flush();
                                ((OutputStream)bufferedOutputStream).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ExportAsJPGAction.access$200((ExportAsJPGAction)this.this$1).statusBar.setMessage(resources.getString("Message.done"));
                        }
                    }.start();
                }
            }
        }

        static /* synthetic */ JSVGViewerFrame access$200(ExportAsJPGAction exportAsJPGAction) {
            return exportAsJPGAction.JSVGViewerFrame.this;
        }
    }

    public class PrintAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.svgDocument != null) {
                SVGDocument sVGDocument = JSVGViewerFrame.this.svgDocument;
                new Thread(this, sVGDocument){
                    private final /* synthetic */ SVGDocument val$doc;
                    private final /* synthetic */ PrintAction this$1;
                    {
                        this.this$1 = printAction;
                        this.val$doc = sVGDocument;
                    }

                    public void run() {
                        PrintTranscoder printTranscoder = new PrintTranscoder();
                        printTranscoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME, PrintAction.access$100((PrintAction)this.this$1).application.getXMLParserClassName());
                        printTranscoder.addTranscodingHint(PrintTranscoder.KEY_SHOW_PAGE_DIALOG, Boolean.TRUE);
                        printTranscoder.addTranscodingHint(PrintTranscoder.KEY_SHOW_PRINTER_DIALOG, Boolean.TRUE);
                        printTranscoder.transcode(new TranscoderInput(this.val$doc), null);
                        try {
                            printTranscoder.print();
                        }
                        catch (PrinterException printerException) {
                            PrintAction.access$100((PrintAction)this.this$1).userAgent.displayError(printerException);
                        }
                    }
                }.start();
            }
        }

        static /* synthetic */ JSVGViewerFrame access$100(PrintAction printAction) {
            return printAction.JSVGViewerFrame.this;
        }
    }

    public class ForwardAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.localHistory.canGoForward()) {
                JSVGViewerFrame.this.localHistory.forward();
            }
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        protected void update() {
            boolean bl = JSVGViewerFrame.this.localHistory.canGoForward();
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }

    public class BackAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.localHistory.canGoBack()) {
                JSVGViewerFrame.this.localHistory.back();
            }
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        protected void update() {
            boolean bl = JSVGViewerFrame.this.localHistory.canGoBack();
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }

    public class ReloadAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (JSVGViewerFrame.this.svgDocument != null) {
                JSVGViewerFrame.this.localHistory.reload();
            }
        }
    }

    public class CloseAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JSVGViewerFrame.this.application.closeJSVGViewerFrame(JSVGViewerFrame.this);
        }
    }

    public class PreferencesAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JSVGViewerFrame.this.application.showPreferenceDialog(JSVGViewerFrame.this);
        }
    }

    public class NewWindowAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JSVGViewerFrame jSVGViewerFrame = JSVGViewerFrame.this.application.createAndShowJSVGViewerFrame();
            jSVGViewerFrame.autoAdjust = JSVGViewerFrame.this.autoAdjust;
            jSVGViewerFrame.debug = JSVGViewerFrame.this.debug;
            jSVGViewerFrame.svgCanvas.setProgressivePaint(JSVGViewerFrame.this.svgCanvas.getProgressivePaint());
            jSVGViewerFrame.svgCanvas.setDoubleBufferedRendering(JSVGViewerFrame.this.svgCanvas.getDoubleBufferedRendering());
        }
    }

    public class OpenLocationAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (JSVGViewerFrame.this.uriChooser == null) {
                JSVGViewerFrame.this.uriChooser = new URIChooser(JSVGViewerFrame.this);
                JSVGViewerFrame.this.uriChooser.setFileFilter(new SVGFileFilter());
                JSVGViewerFrame.this.uriChooser.pack();
                object = JSVGViewerFrame.this.getBounds();
                Dimension dimension = JSVGViewerFrame.this.uriChooser.getSize();
                ((Component)JSVGViewerFrame.this.uriChooser).setLocation(((Rectangle)object).x + (((Rectangle)object).width - dimension.width) / 2, ((Rectangle)object).y + (((Rectangle)object).height - dimension.height) / 2);
            }
            if (JSVGViewerFrame.this.uriChooser.showDialog() == 0) {
                object = JSVGViewerFrame.this.uriChooser.getText();
                int n = ((String)object).indexOf("#");
                String string = "";
                if (n != -1) {
                    string = ((String)object).substring(n + 1);
                    object = ((String)object).substring(0, n);
                }
                if (!((String)object).equals("")) {
                    File file = new File((String)object);
                    if (file.exists()) {
                        if (file.isDirectory()) {
                            object = null;
                        } else {
                            try {
                                object = file.getCanonicalPath();
                                object = ((String)object).startsWith("/") ? "file:" + (String)object : "file:/" + (String)object;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    if (object != null) {
                        if (JSVGViewerFrame.this.svgDocument != null) {
                            try {
                                SVGOMDocument sVGOMDocument = (SVGOMDocument)JSVGViewerFrame.this.svgDocument;
                                URL uRL = sVGOMDocument.getURLObject();
                                URL uRL2 = new URL(uRL, (String)object);
                                String string2 = JSVGViewerFrame.this.svgCanvas.getFragmentIdentifier();
                                if (uRL.equals(uRL2) && string.equals(string2)) {
                                    return;
                                }
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                        if (string.length() != 0) {
                            object = (String)object + "#" + string;
                        }
                        JSVGViewerFrame.this.svgCanvas.loadSVGDocument((String)object);
                    }
                }
            }
        }
    }

    public class OpenAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(JSVGViewerFrame.makeAbsolute(JSVGViewerFrame.this.currentPath));
            jFileChooser.setFileHidingEnabled(false);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.addChoosableFileFilter(new SVGFileFilter());
            int n = jFileChooser.showOpenDialog(JSVGViewerFrame.this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                try {
                    JSVGViewerFrame.this.currentPath = file;
                    JSVGViewerFrame.this.svgCanvas.loadSVGDocument(file.toURL().toString());
                }
                catch (IOException iOException) {
                    JSVGViewerFrame.this.userAgent.displayError(iOException);
                }
            }
        }
    }

    public class AboutAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            AboutDialog aboutDialog = new AboutDialog(JSVGViewerFrame.this);
            ((Component)aboutDialog).setSize(aboutDialog.getPreferredSize());
            aboutDialog.setLocationRelativeTo(JSVGViewerFrame.this);
            aboutDialog.show();
            aboutDialog.toFront();
        }
    }
}

