/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.ClipBridge;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.FilterBridge;
import org.apache.batik.bridge.MaskBridge;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.css.AbstractViewCSS;
import org.apache.batik.css.CSSOMReadOnlyStyleDeclaration;
import org.apache.batik.css.CSSOMReadOnlyValue;
import org.apache.batik.css.value.ImmutableString;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.image.renderable.ClipRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.filter.Mask;
import org.apache.batik.util.CSSConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.Rect;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGColor;

public abstract class CSSUtilities
implements CSSConstants,
ErrorConstants {
    public static final Composite TRANSPARENT = AlphaComposite.getInstance(3, 0.0f);

    protected CSSUtilities() {
    }

    public static AbstractViewCSS getViewCSS(Element element) {
        return (AbstractViewCSS)((SVGOMDocument)element.getOwnerDocument()).getDefaultView();
    }

    public static CSSOMReadOnlyStyleDeclaration getComputedStyle(Element element) {
        return CSSUtilities.getViewCSS(element).getComputedStyleInternal(element, null);
    }

    public static Rectangle2D convertEnableBackground(Element element, UnitProcessor.Context context) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSValue cSSValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("enable-background");
        if (cSSValue.getCssValueType() != 2) {
            return null;
        }
        CSSValueList cSSValueList = cSSValue;
        int n = cSSValueList.getLength();
        switch (n) {
            case 1: {
                return CompositeGraphicsNode.VIEWPORT;
            }
            case 5: {
                cSSValue = cSSValueList.item(1);
                float f = UnitProcessor.cssHorizontalCoordinateToUserSpace(cSSValue, "enable-background", context);
                cSSValue = cSSValueList.item(2);
                float f2 = UnitProcessor.cssVerticalCoordinateToUserSpace(cSSValue, "enable-background", context);
                cSSValue = cSSValueList.item(3);
                float f3 = UnitProcessor.cssHorizontalLengthToUserSpace(cSSValue, "enable-background", context);
                cSSValue = cSSValueList.item(4);
                float f4 = UnitProcessor.cssVerticalLengthToUserSpace(cSSValue, "enable-background", context);
                return new Rectangle2D.Float(f, f2, f3, f4);
            }
        }
        return null;
    }

    public static boolean convertColorInterpolationFilters(Element element) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("color-interpolation-filters");
        return "linearrgb".equals(cSSOMReadOnlyValue.getStringValue());
    }

    public static MultipleGradientPaint.ColorSpaceEnum convertColorInterpolation(Element element) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("color-interpolation");
        return "linearrgb".equals(cSSOMReadOnlyValue.getStringValue()) ? MultipleGradientPaint.LINEAR_RGB : MultipleGradientPaint.SRGB;
    }

    public static Map convertShapeRendering(Element element) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("shape-rendering");
        String string = cSSOMReadOnlyValue.getStringValue();
        if (string.charAt(0) == 'a') {
            return null;
        }
        HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
        switch (string.charAt(0)) {
            case 'o': {
                hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                break;
            }
            case 'c': {
                hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
                hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                break;
            }
            case 'g': {
                hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }
        return hashMap;
    }

    public static Map convertTextRendering(Element element) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("text-rendering");
        String string = cSSOMReadOnlyValue.getStringValue();
        if (string.charAt(0) == 'a') {
            return null;
        }
        HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
        switch (string.charAt(8)) {
            case 's': {
                hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                hashMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                break;
            }
            case 'l': {
                hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                hashMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                break;
            }
            case 'c': {
                hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
                hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
                hashMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
        }
        return hashMap;
    }

    public static Map convertImageRendering(Element element) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("image-rendering");
        String string = cSSOMReadOnlyValue.getStringValue();
        if (string.charAt(0) == 'a') {
            return null;
        }
        HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
        switch (string.charAt(8)) {
            case 's': {
                hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                hashMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                break;
            }
            case 'q': {
                hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                hashMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
        }
        return hashMap;
    }

    public static Map convertColorRendering(Element element) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("color-rendering");
        String string = cSSOMReadOnlyValue.getStringValue();
        if (string.charAt(0) == 'a') {
            return null;
        }
        HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
        switch (string.charAt(8)) {
            case 's': {
                hashMap.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                hashMap.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                break;
            }
            case 'q': {
                hashMap.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                hashMap.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            }
        }
        return hashMap;
    }

    public static boolean convertDisplay(Element element) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("display");
        return ((CSSPrimitiveValue)cSSOMReadOnlyValue).getStringValue().charAt(0) != 'n';
    }

    public static boolean convertVisibility(Element element) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("visibility");
        if (cSSOMReadOnlyValue.getCssValueType() == 0) {
            return true;
        }
        return ((CSSPrimitiveValue)cSSOMReadOnlyValue).getStringValue().charAt(0) == 'v';
    }

    public static Composite convertOpacity(Element element) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("opacity");
        float f = PaintServer.convertOpacity(cSSOMReadOnlyValue);
        if (f <= 0.0f) {
            return TRANSPARENT;
        }
        if (f >= 1.0f) {
            return AlphaComposite.SrcOver;
        }
        return AlphaComposite.getInstance(3, f);
    }

    public static boolean convertOverflow(Element element) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("overflow");
        String string = cSSOMReadOnlyValue.getStringValue();
        return string.charAt(0) == 'h' || string.charAt(0) == 's';
    }

    public static float[] convertClip(Element element) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("clip");
        switch (cSSOMReadOnlyValue.getPrimitiveType()) {
            case 24: {
                float[] fArray = new float[4];
                Rect rect = cSSOMReadOnlyValue.getRectValue();
                fArray[0] = rect.getTop().getFloatValue((short)1);
                fArray[1] = rect.getRight().getFloatValue((short)1);
                fArray[2] = rect.getBottom().getFloatValue((short)1);
                fArray[3] = rect.getLeft().getFloatValue((short)1);
                return fArray;
            }
            case 21: {
                return null;
            }
        }
        throw new Error();
    }

    public static Filter convertFilter(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("filter");
        switch (cSSOMReadOnlyValue.getPrimitiveType()) {
            case 21: {
                return null;
            }
            case 20: {
                String string = cSSOMReadOnlyValue.getStringValue();
                Element element2 = bridgeContext.getReferencedElement(element, string);
                Bridge bridge = bridgeContext.getBridge(element2);
                if (bridge == null || !(bridge instanceof FilterBridge)) {
                    throw new BridgeException(element, "css.uri.badTarget", new Object[]{string});
                }
                return ((FilterBridge)bridge).createFilter(bridgeContext, element2, element, graphicsNode);
            }
        }
        throw new Error();
    }

    public static ClipRable convertClipPath(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("clip-path");
        switch (cSSOMReadOnlyValue.getPrimitiveType()) {
            case 21: {
                return null;
            }
            case 20: {
                String string = cSSOMReadOnlyValue.getStringValue();
                Element element2 = bridgeContext.getReferencedElement(element, string);
                Bridge bridge = bridgeContext.getBridge(element2);
                if (bridge == null || !(bridge instanceof ClipBridge)) {
                    throw new BridgeException(element, "css.uri.badTarget", new Object[]{string});
                }
                return ((ClipBridge)bridge).createClip(bridgeContext, element2, element, graphicsNode);
            }
        }
        throw new Error();
    }

    public static int convertClipRule(Element element) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        return CSSUtilities.rule(cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("clip-rule"));
    }

    public static Mask convertMask(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("mask");
        switch (cSSOMReadOnlyValue.getPrimitiveType()) {
            case 21: {
                return null;
            }
            case 20: {
                String string = cSSOMReadOnlyValue.getStringValue();
                Element element2 = bridgeContext.getReferencedElement(element, string);
                Bridge bridge = bridgeContext.getBridge(element2);
                if (bridge == null || !(bridge instanceof MaskBridge)) {
                    throw new BridgeException(element, "css.uri.badTarget", new Object[]{string});
                }
                return ((MaskBridge)bridge).createMask(bridgeContext, element2, element, graphicsNode);
            }
        }
        throw new Error();
    }

    public static int convertFillRule(Element element) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        return CSSUtilities.rule(cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("fill-rule"));
    }

    public static Color convertLightingColor(Element element, BridgeContext bridgeContext) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("lighting-color");
        if (cSSOMReadOnlyValue.getCssValueType() == 1) {
            CSSPrimitiveValue cSSPrimitiveValue = cSSOMReadOnlyValue;
            return PaintServer.convertColor(cSSPrimitiveValue.getRGBColorValue(), 1.0f);
        }
        return PaintServer.convertRGBICCColor(element, (SVGColor)((Object)cSSOMReadOnlyValue), 1.0f, bridgeContext);
    }

    public static Color convertFloodColor(Element element, BridgeContext bridgeContext) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        float f = PaintServer.convertOpacity(cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("flood-opacity"));
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("flood-color");
        if (cSSOMReadOnlyValue.getCssValueType() == 1) {
            CSSPrimitiveValue cSSPrimitiveValue = cSSOMReadOnlyValue;
            return PaintServer.convertColor(cSSPrimitiveValue.getRGBColorValue(), f);
        }
        return PaintServer.convertRGBICCColor(element, (SVGColor)((Object)cSSOMReadOnlyValue), f, bridgeContext);
    }

    public static Color convertStopColor(Element element, float f, BridgeContext bridgeContext) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("stop-color");
        float f2 = PaintServer.convertOpacity(cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("stop-opacity"));
        f *= f2;
        if (cSSOMReadOnlyValue.getCssValueType() == 1) {
            CSSPrimitiveValue cSSPrimitiveValue = cSSOMReadOnlyValue;
            return PaintServer.convertColor(cSSPrimitiveValue.getRGBColorValue(), f);
        }
        return PaintServer.convertRGBICCColor(element, (SVGColor)((Object)cSSOMReadOnlyValue), f, bridgeContext);
    }

    public static void computeStyleAndURIs(Element element, Element element2) {
        SVGOMDocument sVGOMDocument = (SVGOMDocument)element2.getOwnerDocument();
        ViewCSS viewCSS = (ViewCSS)sVGOMDocument.getDefaultView();
        SVGOMDocument sVGOMDocument2 = (SVGOMDocument)element.getOwnerDocument();
        ViewCSS viewCSS2 = (ViewCSS)sVGOMDocument2.getDefaultView();
        URL uRL = sVGOMDocument2.getURLObject();
        CSSUtilities.computeStyleAndURIs(element, viewCSS2, element2, viewCSS, uRL);
    }

    static void computeStyleAndURIs(Element element, ViewCSS viewCSS, Element element2, ViewCSS viewCSS2, URL uRL) {
        String string = XLinkSupport.getXLinkHref(element2);
        if (!string.equals("")) {
            try {
                XLinkSupport.setXLinkHref(element2, new URL(uRL, string).toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        AbstractViewCSS abstractViewCSS = (AbstractViewCSS)viewCSS;
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = abstractViewCSS.computeStyle(element, null);
        try {
            CSSUtilities.updateURIs(cSSOMReadOnlyStyleDeclaration, uRL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        ((AbstractViewCSS)viewCSS2).setComputedStyle(element2, null, cSSOMReadOnlyStyleDeclaration);
        Node node = element.getFirstChild();
        Node node2 = element2.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                CSSUtilities.computeStyleAndURIs((Element)node, viewCSS, (Element)node2, viewCSS2, uRL);
            }
            node = node.getNextSibling();
            node2 = node2.getNextSibling();
        }
    }

    public static void updateURIs(CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration, URL uRL) throws MalformedURLException {
        int n = cSSOMReadOnlyStyleDeclaration.getLength();
        int n2 = 0;
        while (n2 < n) {
            CSSPrimitiveValue cSSPrimitiveValue;
            String string = cSSOMReadOnlyStyleDeclaration.item(n2);
            CSSValue cSSValue = cSSOMReadOnlyStyleDeclaration.getLocalPropertyCSSValue(string);
            if (cSSValue != null && cSSValue.getCssValueType() == 1 && (cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue).getPrimitiveType() == 20) {
                CSSOMReadOnlyValue cSSOMReadOnlyValue = new CSSOMReadOnlyValue(new ImmutableString(20, new URL(uRL, cSSPrimitiveValue.getStringValue()).toString()));
                cSSOMReadOnlyStyleDeclaration.setPropertyCSSValue(string, cSSOMReadOnlyValue, cSSOMReadOnlyStyleDeclaration.getLocalPropertyPriority(string), cSSOMReadOnlyStyleDeclaration.getLocalPropertyOrigin(string));
            }
            ++n2;
        }
    }

    protected static int rule(CSSValue cSSValue) {
        return ((CSSPrimitiveValue)cSSValue).getStringValue().charAt(0) == 'n' ? 1 : 0;
    }
}

