/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.bridge.SVGAltGlyphHandler;
import org.apache.batik.bridge.SVGFontUtilities;
import org.apache.batik.bridge.SVGTextPathElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.css.AbstractViewCSS;
import org.apache.batik.css.CSSOMReadOnlyStyleDeclaration;
import org.apache.batik.css.CSSOMReadOnlyValue;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class SVGTextElementBridge
extends AbstractSVGBridge
implements GraphicsNodeBridge,
ErrorConstants {
    public String getLocalName() {
        return "text";
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Object object;
        Object object2;
        String string;
        TextNode textNode = new TextNode();
        if (bridgeContext.getTextPainter() != null) {
            textNode.setTextPainter(bridgeContext.getTextPainter());
        }
        if ((string = element.getAttributeNS(null, "transform")).length() != 0) {
            textNode.setTransform(SVGUtilities.convertTransform(element, "transform", string));
        }
        textNode.setVisible(CSSUtilities.convertVisibility(element));
        Map map = CSSUtilities.convertTextRendering(element);
        Map map2 = CSSUtilities.convertColorRendering(element);
        if (map != null || map2 != null) {
            if (map == null) {
                object2 = new RenderingHints(map2);
            } else if (map2 == null) {
                object2 = new RenderingHints(map);
            } else {
                object2 = new RenderingHints(map);
                ((RenderingHints)object2).putAll((Map<?, ?>)map2);
            }
            textNode.setRenderingHints((RenderingHints)object2);
        }
        object2 = UnitProcessor.createContext(bridgeContext, element);
        string = element.getAttributeNS(null, "x");
        float f = 0.0f;
        if (string.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            object = stringTokenizer.nextToken();
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace((String)object, "x", (UnitProcessor.Context)object2);
        }
        string = element.getAttributeNS(null, "y");
        float f2 = 0.0f;
        if (string.length() != 0) {
            object = new StringTokenizer(string);
            String string2 = ((StringTokenizer)object).nextToken();
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string2, "y", (UnitProcessor.Context)object2);
        }
        textNode.setLocation(new Point2D.Float(f, f2));
        return textNode;
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        element.normalize();
        AttributedString attributedString = this.buildAttributedString(bridgeContext, element, graphicsNode);
        this.addGlyphPositionAttributes(attributedString, element, bridgeContext);
        ((TextNode)graphicsNode).setAttributedCharacterIterator(attributedString.getIterator());
        TextDecoration textDecoration = this.getTextDecoration(element, (TextNode)graphicsNode, new TextDecoration(), bridgeContext);
        this.addPaintAttributes(attributedString, element, (TextNode)graphicsNode, textDecoration, bridgeContext);
        ((TextNode)graphicsNode).setAttributedCharacterIterator(attributedString.getIterator());
        graphicsNode.setFilter(CSSUtilities.convertFilter(element, graphicsNode, bridgeContext));
        graphicsNode.setMask(CSSUtilities.convertMask(element, graphicsNode, bridgeContext));
        graphicsNode.setClip(CSSUtilities.convertClipPath(element, graphicsNode, bridgeContext));
        if (bridgeContext.isDynamic()) {
            bridgeContext.bind(element, graphicsNode);
        }
        SVGUtilities.bridgeChildren(bridgeContext, element);
    }

    public boolean isComposite() {
        return false;
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
        throw new Error("Not implemented");
    }

    protected AttributedString buildAttributedString(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        Object object;
        AttributedString attributedString = null;
        List list = this.buildAttributedStrings(bridgeContext, element, graphicsNode, true, null, new LinkedList());
        switch (list.size()) {
            case 0: {
                return new AttributedString(" ");
            }
            case 1: {
                return (AttributedString)list.get(0);
            }
        }
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            AttributedString attributedString2 = (AttributedString)iterator.next();
            object = attributedString2.getIterator();
            char c = object.first();
            while (c != '\uffff') {
                stringBuffer.append(c);
                c = object.next();
            }
        }
        attributedString = new AttributedString(stringBuffer.toString());
        int n = 0;
        iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (AttributedString)iterator.next();
            AttributedCharacterIterator attributedCharacterIterator = ((AttributedString)object).getIterator();
            Iterator<AttributedCharacterIterator.Attribute> iterator2 = attributedCharacterIterator.getAllAttributeKeys().iterator();
            while (iterator2.hasNext()) {
                int n2;
                AttributedCharacterIterator.Attribute attribute = iterator2.next();
                attributedCharacterIterator.first();
                do {
                    int n3 = attributedCharacterIterator.getRunStart(attribute);
                    n2 = attributedCharacterIterator.getRunLimit(attribute);
                    attributedCharacterIterator.setIndex(n3);
                    Object object2 = attributedCharacterIterator.getAttribute(attribute);
                    attributedString.addAttribute(attribute, object2, n + n3, n + n2);
                    attributedCharacterIterator.setIndex(n2);
                } while (n2 < attributedCharacterIterator.getEndIndex());
            }
            n += attributedCharacterIterator.getEndIndex();
        }
        return attributedString;
    }

    protected List buildAttributedStrings(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode, boolean bl, TextPath textPath, LinkedList linkedList) {
        Map map = this.getAttributeMap(bridgeContext, element, graphicsNode, textPath);
        String string = XMLSupport.getXMLSpace(element);
        boolean bl2 = string.equals("preserve");
        boolean bl3 = true;
        boolean bl4 = !bl2;
        boolean bl5 = !bl2;
        Element element2 = element;
        AttributedString attributedString = null;
        if (!linkedList.isEmpty()) {
            attributedString = (AttributedString)linkedList.getLast();
        }
        Node node = element.getFirstChild();
        while (node != null) {
            boolean bl6 = node.getNextSibling() == null;
            int n = attributedString != null ? (int)attributedString.getIterator().last() : 65535;
            bl4 = !bl2 && bl3 && (bl || n == 32 || n == 65535);
            switch (node.getNodeType()) {
                case 1: {
                    AttributedString attributedString2;
                    int[] nArray;
                    Object object;
                    Object object2;
                    Object object3;
                    element2 = (Element)node;
                    if (node.getLocalName().equals("tspan") || node.getLocalName().equals("altGlyph")) {
                        this.buildAttributedStrings(bridgeContext, element2, graphicsNode, false, textPath, linkedList);
                        break;
                    }
                    if (node.getLocalName().equals("textPath")) {
                        object3 = (SVGTextPathElementBridge)bridgeContext.getBridge(element2);
                        object2 = ((SVGTextPathElementBridge)object3).createTextPath(bridgeContext, element2);
                        if (object2 == null) break;
                        this.buildAttributedStrings(bridgeContext, element2, graphicsNode, false, (TextPath)object2, linkedList);
                        break;
                    }
                    if (!node.getLocalName().equals("tref") || (attributedString = this.createAttributedString(string = this.getElementContent((Element)(object2 = bridgeContext.getReferencedElement((Element)node, (String)(object3 = XLinkSupport.getXLinkHref((Element)node))))), (Map)(object = this.getAttributeMap(bridgeContext, element2, graphicsNode, textPath)), nArray = new int[string.length()], bl2, bl4, bl6 && bl)) == null) break;
                    boolean bl7 = bl5 = !bl2 && attributedString.getIterator().first() == ' ';
                    if (bl5 && (attributedString2 = (AttributedString)linkedList.removeLast()) != null) {
                        int n2;
                        AttributedCharacterIterator attributedCharacterIterator = attributedString2.getIterator();
                        if (attributedCharacterIterator.setIndex(n2 = attributedCharacterIterator.getEndIndex() - 1) == ' ') {
                            attributedString2 = new AttributedString(attributedString2.getIterator(null, attributedCharacterIterator.getBeginIndex(), n2));
                        }
                        linkedList.add(attributedString2);
                    }
                    linkedList.add(attributedString);
                    break;
                }
                case 3: {
                    Object object;
                    Object object2;
                    string = node.getNodeValue();
                    Object object3 = new int[string.length()];
                    attributedString = this.createAttributedString(string, map, (int[])object3, bl2, bl4, bl6 && bl);
                    if (attributedString == null) break;
                    boolean bl8 = bl5 = !bl2 && attributedString.getIterator().first() == ' ';
                    if (bl5 && !linkedList.isEmpty() && (object2 = (AttributedString)linkedList.removeLast()) != null) {
                        int n3;
                        object = ((AttributedString)object2).getIterator();
                        if (object.setIndex(n3 = object.getEndIndex() - 1) == ' ') {
                            object2 = new AttributedString(((AttributedString)object2).getIterator(null, object.getBeginIndex(), n3));
                        }
                        linkedList.add(object2);
                    }
                    linkedList.add(attributedString);
                }
            }
            bl3 = false;
            node = node.getNextSibling();
        }
        return linkedList;
    }

    protected String getElementContent(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        Node node = element.getFirstChild();
        while (node != null) {
            switch (node.getNodeType()) {
                case 1: {
                    stringBuffer.append(this.getElementContent((Element)node));
                    break;
                }
                case 3: {
                    stringBuffer.append(node.getNodeValue());
                }
            }
            node = node.getNextSibling();
        }
        return stringBuffer.toString();
    }

    protected AttributedString createAttributedString(String string, Map map, int[] nArray, boolean bl, boolean bl2, boolean bl3) {
        AttributedString attributedString = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        stringBuffer.append(' ');
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                nArray[n] = n;
                ++n;
            }
        } else {
            int n;
            boolean bl4 = false;
            int n2 = 0;
            while (n2 < string.length()) {
                n = string.charAt(n2);
                switch (n) {
                    case 10: 
                    case 13: {
                        break;
                    }
                    case 9: 
                    case 32: {
                        if (bl4) break;
                        stringBuffer.append(' ');
                        nArray[stringBuffer.length() - 1] = n2;
                        bl4 = true;
                        break;
                    }
                    default: {
                        stringBuffer.append((char)n);
                        nArray[stringBuffer.length() - 1] = n2;
                        bl4 = false;
                    }
                }
                ++n2;
            }
            if (bl2) {
                while (stringBuffer.length() > 0) {
                    if (stringBuffer.charAt(0) != ' ') break;
                    stringBuffer.deleteCharAt(0);
                    System.arraycopy(nArray, 1, nArray, 0, stringBuffer.length());
                }
            }
            if (bl3) {
                while ((n = stringBuffer.length()) > 0) {
                    if (stringBuffer.charAt(n - '\u0001') != ' ') break;
                    stringBuffer.deleteCharAt(n - 1);
                }
            }
            n = stringBuffer.length();
            while (n < nArray.length) {
                nArray[n] = -1;
                ++n;
            }
        }
        if (stringBuffer.length() > 0) {
            attributedString = new AttributedString(stringBuffer.toString(), map);
        } else if (bl2 && bl3) {
            attributedString = new AttributedString(" ", map);
        }
        return attributedString;
    }

    private boolean nodeAncestorOf(Node node, Node node2) {
        if (node2 == null || node == null) {
            return false;
        }
        Node node3 = node2.getParentNode();
        while (node3 != null && node3 != node) {
            node3 = node3.getParentNode();
        }
        return node3 == node;
    }

    protected void addGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        int n;
        Object object;
        String string = element.getAttributeNS(null, "x");
        String string2 = element.getAttributeNS(null, "y");
        String string3 = element.getAttributeNS(null, "dx");
        String string4 = element.getAttributeNS(null, "dy");
        String string5 = element.getAttributeNS(null, "rotate");
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n2 = 0;
        int n3 = 0;
        while (n3 < attributedCharacterIterator.getEndIndex()) {
            attributedCharacterIterator.setIndex(n3);
            Element element2 = (Element)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (element2 == element || this.nodeAncestorOf(element, element2)) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        int n4 = attributedCharacterIterator.getEndIndex() - 1;
        int n5 = attributedCharacterIterator.getEndIndex() - 1;
        while (n5 >= 0) {
            attributedCharacterIterator.setIndex(n5);
            object = (Element)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (object == element || this.nodeAncestorOf(element, (Node)object)) {
                n4 = n5;
                break;
            }
            --n5;
        }
        if (string.length() != 0) {
            object = TextUtilities.svgHorizontalCoordinateArrayToUserSpace(element, "x", string, bridgeContext);
            n = 0;
            while (n < ((float[])object).length) {
                if (n2 + n <= n4) {
                    attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.X, new Float((float)object[n]), n2 + n, n2 + n + 1);
                }
                ++n;
            }
        }
        if (string2.length() != 0) {
            object = TextUtilities.svgVerticalCoordinateArrayToUserSpace(element, "y", string2, bridgeContext);
            n = 0;
            while (n < ((float[])object).length) {
                if (n2 + n <= n4) {
                    attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.Y, new Float((float)object[n]), n2 + n, n2 + n + 1);
                }
                ++n;
            }
        }
        if (string3.length() != 0) {
            object = TextUtilities.svgHorizontalCoordinateArrayToUserSpace(element, "dx", string3, bridgeContext);
            n = 0;
            while (n < ((float[])object).length) {
                if (n2 + n <= n4) {
                    attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.DX, new Float((float)object[n]), n2 + n, n2 + n + 1);
                }
                ++n;
            }
        }
        if (string4.length() != 0) {
            object = TextUtilities.svgVerticalCoordinateArrayToUserSpace(element, "dy", string4, bridgeContext);
            n = 0;
            while (n < ((float[])object).length) {
                if (n2 + n <= n4) {
                    attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.DY, new Float((float)object[n]), n2 + n, n2 + n + 1);
                }
                ++n;
            }
        }
        if (string5.length() != 0) {
            object = TextUtilities.svgRotateArrayToFloats(element, "rotate", string5, bridgeContext);
            if (((float[])object).length == 1) {
                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ROTATION, new Float((float)object[0]), n2, n4 + 1);
            } else {
                n = 0;
                while (n < ((Object)object).length) {
                    if (n2 + n <= n4) {
                        attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ROTATION, new Float((float)object[n]), n2 + n, n2 + n + 1);
                    }
                    ++n;
                }
            }
        }
        object = element.getChildNodes();
        n = 0;
        while (n < object.getLength()) {
            Node node = object.item(n);
            if (node.getNodeType() == 1) {
                this.addGlyphPositionAttributes(attributedString, (Element)node, bridgeContext);
            }
            ++n;
        }
    }

    protected void addPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextDecoration textDecoration, BridgeContext bridgeContext) {
        Object object;
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n = 0;
        int n2 = 0;
        while (n2 < attributedCharacterIterator.getEndIndex()) {
            attributedCharacterIterator.setIndex(n2);
            Element element2 = (Element)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (element2 == element || this.nodeAncestorOf(element, element2)) {
                n = n2;
                break;
            }
            ++n2;
        }
        int n3 = attributedCharacterIterator.getEndIndex() - 1;
        int n4 = attributedCharacterIterator.getEndIndex() - 1;
        while (n4 >= 0) {
            attributedCharacterIterator.setIndex(n4);
            object = (Element)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (object == element || this.nodeAncestorOf(element, (Node)object)) {
                n3 = n4;
                break;
            }
            --n4;
        }
        object = CSSUtilities.convertOpacity(element);
        attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.OPACITY, object, n, n3 + 1);
        Paint paint = PaintServer.convertFillPaint(element, textNode, bridgeContext);
        attributedString.addAttribute(TextAttribute.FOREGROUND, paint, n, n3 + 1);
        Paint paint2 = PaintServer.convertStrokePaint(element, textNode, bridgeContext);
        attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE_PAINT, paint2, n, n3 + 1);
        Stroke stroke = PaintServer.convertStroke(element, bridgeContext);
        attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE, stroke, n, n3 + 1);
        if (textDecoration != null) {
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT, textDecoration.underlinePaint, n, n3 + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT, textDecoration.underlineStrokePaint, n, n3 + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE, textDecoration.underlineStroke, n, n3 + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT, textDecoration.overlinePaint, n, n3 + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT, textDecoration.overlineStrokePaint, n, n3 + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE, textDecoration.overlineStroke, n, n3 + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT, textDecoration.strikethroughPaint, n, n3 + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT, textDecoration.strikethroughStrokePaint, n, n3 + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE, textDecoration.strikethroughStroke, n, n3 + 1);
        }
        NodeList nodeList = element.getChildNodes();
        int n5 = 0;
        while (n5 < nodeList.getLength()) {
            Node node = nodeList.item(n5);
            if (node.getNodeType() == 1) {
                Element element3 = (Element)node;
                TextDecoration textDecoration2 = this.getTextDecoration(element3, textNode, textDecoration, bridgeContext);
                this.addPaintAttributes(attributedString, element3, textNode, textDecoration2, bridgeContext);
            }
            ++n5;
        }
    }

    protected Map getAttributeMap(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode, TextPath textPath) {
        float f;
        String string;
        String string2;
        TextNode.Anchor anchor;
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        HashMap<AttributedCharacterIterator.Attribute, Object> hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        boolean bl = false;
        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER, element);
        if (element.getTagName().equals("altGlyph")) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER, new SVGAltGlyphHandler(bridgeContext, element));
        }
        if (textPath != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH, textPath);
        }
        CSSPrimitiveValue cSSPrimitiveValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("text-anchor");
        String string3 = cSSPrimitiveValue.getStringValue();
        switch (string3.charAt(0)) {
            case 's': {
                anchor = TextNode.Anchor.START;
                break;
            }
            case 'm': {
                anchor = TextNode.Anchor.MIDDLE;
                break;
            }
            default: {
                anchor = TextNode.Anchor.END;
            }
        }
        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE, anchor);
        float f2 = TextUtilities.convertFontSize(element, bridgeContext, cSSOMReadOnlyStyleDeclaration, context);
        hashMap.put(TextAttribute.SIZE, new Float(f2));
        cSSPrimitiveValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("font-weight");
        if (cSSPrimitiveValue.getPrimitiveType() == 21) {
            string2 = cSSPrimitiveValue.getStringValue();
            if (cSSPrimitiveValue.getStringValue().charAt(0) == 'n') {
                hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
            } else if (cSSPrimitiveValue.getStringValue().charAt(0) == 'l') {
                hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
            } else {
                hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
        } else {
            string2 = "" + cSSPrimitiveValue.getFloatValue((short)1);
            switch ((int)cSSPrimitiveValue.getFloatValue((short)1)) {
                case 100: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRA_LIGHT);
                    break;
                }
                case 200: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
                    break;
                }
                case 300: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMILIGHT);
                    break;
                }
                case 400: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
                    break;
                }
                case 500: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_SEMIBOLD);
                    break;
                }
                case 600: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                    break;
                }
                case 700: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                    break;
                }
                case 800: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                    break;
                }
                case 900: {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                }
            }
        }
        cSSPrimitiveValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("font-style");
        String string4 = cSSPrimitiveValue.getStringValue();
        switch (string4.charAt(0)) {
            case 'n': {
                hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
                break;
            }
            case 'i': 
            case 'o': {
                hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
        }
        cSSPrimitiveValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("font-stretch");
        String string5 = cSSPrimitiveValue.getStringValue();
        switch (string5.charAt(0)) {
            case 'u': {
                if (string5.charAt(6) == 'c') {
                    hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED);
                    break;
                }
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_EXTENDED);
                break;
            }
            case 'e': {
                if (string5.charAt(6) == 'c') {
                    hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED);
                    break;
                }
                if (string5.length() == 8) {
                    hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
                    break;
                }
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_EXTENDED);
                break;
            }
            case 's': {
                if (string5.charAt(6) == 'c') {
                    hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_CONDENSED);
                    break;
                }
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
                break;
            }
            default: {
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_REGULAR);
            }
        }
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("font-family");
        Vector<GVTFontFamily> vector = new Vector<GVTFontFamily>();
        int n = 0;
        while (n < cSSOMReadOnlyValue.getLength()) {
            cSSPrimitiveValue = (CSSPrimitiveValue)cSSOMReadOnlyValue.item(n);
            string = cSSPrimitiveValue.getStringValue();
            GVTFontFamily gVTFontFamily = SVGFontUtilities.getFontFamily(element, bridgeContext, string, string2, string4);
            vector.add(gVTFontFamily);
            ++n;
        }
        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES, vector);
        cSSPrimitiveValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("baseline-shift");
        if (cSSPrimitiveValue.getPrimitiveType() == 21) {
            string3 = cSSPrimitiveValue.getStringValue();
            switch (string3.charAt(2)) {
                case 'p': {
                    hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT, TextAttribute.SUPERSCRIPT_SUPER);
                    break;
                }
                case 'b': {
                    hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT, TextAttribute.SUPERSCRIPT_SUB);
                    break;
                }
            }
        } else if (cSSPrimitiveValue.getPrimitiveType() == 2) {
            f = cSSPrimitiveValue.getFloatValue(cSSPrimitiveValue.getPrimitiveType());
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT, new Float(f * f2 / 100.0f));
        } else {
            f = UnitProcessor.cssOtherLengthToUserSpace(cSSPrimitiveValue, "baseline-shift", context);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT, new Float(f));
        }
        cSSPrimitiveValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("unicode-bidi");
        string3 = cSSPrimitiveValue.getStringValue();
        if (string3.charAt(0) == 'n') {
            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(0));
        } else {
            cSSPrimitiveValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("direction");
            string = cSSPrimitiveValue.getStringValue();
            block28 : switch (string.charAt(0)) {
                case 'l': {
                    hashMap.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                    switch (string3.charAt(0)) {
                        case 'b': {
                            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(-2));
                            break;
                        }
                        case 'e': {
                            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(2));
                        }
                    }
                    break;
                }
                case 'r': {
                    hashMap.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                    switch (string3.charAt(0)) {
                        case 'b': {
                            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(-1));
                            break block28;
                        }
                        case 'e': {
                            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(1));
                        }
                    }
                }
            }
        }
        boolean bl2 = true;
        cSSPrimitiveValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("writing-mode");
        string3 = cSSPrimitiveValue.getStringValue();
        switch (string3.charAt(0)) {
            case 'l': {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_LTR);
                break;
            }
            case 'r': {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL);
                break;
            }
            case 't': {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB);
                bl2 = false;
            }
        }
        cSSPrimitiveValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("glyph-orientation-vertical");
        string3 = cSSPrimitiveValue.getCssText();
        switch (string3.charAt(0)) {
            case 'a': {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_AUTO);
                break;
            }
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float(string3));
            }
        }
        cSSPrimitiveValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("font-stretch");
        string3 = cSSPrimitiveValue.getStringValue();
        switch (string3.charAt(0)) {
            case 'u': {
                if (string3.charAt(6) == 'c') {
                    hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED);
                    break;
                }
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_EXTENDED);
                break;
            }
            case 'e': {
                if (string3.charAt(6) == 'c') {
                    hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED);
                    break;
                }
                if (string3.length() == 8) {
                    hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
                    break;
                }
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_EXTENDED);
                break;
            }
            case 's': {
                if (string3.charAt(6) == 'c') {
                    hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_CONDENSED);
                    break;
                }
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
                break;
            }
            default: {
                hashMap.put(TextAttribute.WIDTH, TextAttribute.WIDTH_REGULAR);
            }
        }
        cSSPrimitiveValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("letter-spacing");
        short s = cSSPrimitiveValue.getPrimitiveType();
        if (s != 21) {
            f = bl2 ? UnitProcessor.cssHorizontalCoordinateToUserSpace(cSSPrimitiveValue, "letter-spacing", context) : UnitProcessor.cssVerticalCoordinateToUserSpace(cSSPrimitiveValue, "letter-spacing", context);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING, new Float(f));
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((s = (cSSPrimitiveValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("word-spacing")).getPrimitiveType()) != 21) {
            f = bl2 ? UnitProcessor.cssHorizontalCoordinateToUserSpace(cSSPrimitiveValue, "word-spacing", context) : UnitProcessor.cssVerticalCoordinateToUserSpace(cSSPrimitiveValue, "word-spacing", context);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING, new Float(f));
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((string3 = element.getAttributeNS(null, "kerning")).length() != 0) {
            f = bl2 ? UnitProcessor.svgHorizontalLengthToUserSpace(string3, "kerning", context) : UnitProcessor.svgVerticalLengthToUserSpace(string3, "kerning", context);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.KERNING, new Float(f));
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((string3 = element.getAttributeNS(null, "textLength")).length() != 0) {
            f = bl2 ? UnitProcessor.svgHorizontalLengthToUserSpace(string3, "textLength", context) : UnitProcessor.svgVerticalLengthToUserSpace(string3, "textLength", context);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH, new Float(f));
            string3 = element.getAttributeNS(null, "lengthAdjust");
            if (string3.length() < 10) {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING);
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
            } else {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL);
            }
        }
        return hashMap;
    }

    private TextDecoration getTextDecoration(Element element, GraphicsNode graphicsNode, TextDecoration textDecoration, BridgeContext bridgeContext) {
        TextDecoration textDecoration2 = new TextDecoration(textDecoration);
        AbstractViewCSS abstractViewCSS = CSSUtilities.getViewCSS(element);
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = abstractViewCSS.getCascadedStyle(element, null);
        CSSValue cSSValue = cSSOMReadOnlyStyleDeclaration.getLocalPropertyCSSValue("text-decoration");
        if (cSSValue == null) {
            return textDecoration2;
        }
        short s = cSSValue.getCssValueType();
        if (s == 2) {
            CSSValueList cSSValueList = (CSSValueList)cSSValue;
            Paint paint = PaintServer.convertFillPaint(element, graphicsNode, bridgeContext);
            Paint paint2 = PaintServer.convertStrokePaint(element, graphicsNode, bridgeContext);
            Stroke stroke = PaintServer.convertStroke(element, bridgeContext);
            int n = 0;
            while (n < cSSValueList.getLength()) {
                CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSValueList.item(n);
                String string = cSSPrimitiveValue.getStringValue();
                switch (string.charAt(0)) {
                    case 'u': {
                        if (paint != null) {
                            textDecoration2.underlinePaint = paint;
                        }
                        if (paint2 != null) {
                            textDecoration2.underlineStrokePaint = paint2;
                        }
                        if (stroke == null) break;
                        textDecoration2.underlineStroke = stroke;
                        break;
                    }
                    case 'o': {
                        if (paint != null) {
                            textDecoration2.overlinePaint = paint;
                        }
                        if (paint2 != null) {
                            textDecoration2.overlineStrokePaint = paint2;
                        }
                        if (stroke == null) break;
                        textDecoration2.overlineStroke = stroke;
                        break;
                    }
                    case 'l': {
                        if (paint != null) {
                            textDecoration2.strikethroughPaint = paint;
                        }
                        if (paint2 != null) {
                            textDecoration2.strikethroughStrokePaint = paint2;
                        }
                        if (stroke == null) break;
                        textDecoration2.strikethroughStroke = stroke;
                    }
                }
                ++n;
            }
        } else if (s == 1) {
            return new TextDecoration();
        }
        return textDecoration2;
    }

    private class TextDecoration {
        Paint underlinePaint;
        Paint underlineStrokePaint;
        Stroke underlineStroke;
        Paint overlinePaint;
        Paint overlineStrokePaint;
        Stroke overlineStroke;
        Paint strikethroughPaint;
        Paint strikethroughStrokePaint;
        Stroke strikethroughStroke;

        TextDecoration() {
            this.underlinePaint = null;
            this.underlineStrokePaint = null;
            this.underlineStroke = null;
            this.overlinePaint = null;
            this.overlineStrokePaint = null;
            this.overlineStroke = null;
            this.strikethroughPaint = null;
            this.strikethroughStrokePaint = null;
            this.strikethroughStroke = null;
        }

        TextDecoration(TextDecoration textDecoration) {
            this.underlinePaint = textDecoration.underlinePaint;
            this.underlineStrokePaint = textDecoration.underlineStrokePaint;
            this.underlineStroke = textDecoration.underlineStroke;
            this.overlinePaint = textDecoration.overlinePaint;
            this.overlineStrokePaint = textDecoration.overlineStrokePaint;
            this.overlineStroke = textDecoration.overlineStroke;
            this.strikethroughPaint = textDecoration.strikethroughPaint;
            this.strikethroughStrokePaint = textDecoration.strikethroughStrokePaint;
            this.strikethroughStroke = textDecoration.strikethroughStroke;
        }
    }
}

