/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.css.ElementWithID;
import org.apache.batik.css.ElementWithPseudoClass;
import org.apache.batik.css.HiddenChildElement;
import org.apache.batik.css.HiddenChildElementSupport;
import org.apache.batik.dom.AbstractAttr;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractElement;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.svg.AttributeInitializer;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.util.SoftDoublyIndexedTable;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractElement
extends org.apache.batik.dom.AbstractElement
implements ElementWithID,
ElementWithPseudoClass,
HiddenChildElement {
    protected transient Element parentElement;
    protected transient SoftDoublyIndexedTable liveAttributeValues;

    protected AbstractElement() {
    }

    protected AbstractElement(String string, AbstractDocument abstractDocument) {
        this.ownerDocument = abstractDocument;
        this.setPrefix(string);
        this.initializeAttributes();
    }

    public void setIDName(String string, String string2) {
        if (string != null || string2 == null || !string2.equals("id")) {
            throw this.createDOMException((short)7, "id.name", new Object[]{string2});
        }
    }

    public String getID() {
        return this.getAttribute("id");
    }

    public boolean matchPseudoClass(String string) {
        if (string.equals("first-child")) {
            Node node = this.getPreviousSibling();
            while (node != null && node.getNodeType() != 1) {
                node = node.getPreviousSibling();
            }
            return node == null;
        }
        return false;
    }

    public Element getParentElement() {
        return this.parentElement;
    }

    public void setParentElement(Element element) {
        this.parentElement = element;
    }

    public NodeEventTarget getParentNodeEventTarget() {
        return (NodeEventTarget)((Object)HiddenChildElementSupport.getParentElement(this));
    }

    public LiveAttributeValue getLiveAttributeValue(String string, String string2) {
        if (this.liveAttributeValues == null) {
            return null;
        }
        return (LiveAttributeValue)this.liveAttributeValues.get(string, string2);
    }

    public void putLiveAttributeValue(String string, String string2, LiveAttributeValue liveAttributeValue) {
        if (this.liveAttributeValues == null) {
            this.liveAttributeValues = new SoftDoublyIndexedTable();
        }
        this.liveAttributeValues.put(string, string2, liveAttributeValue);
    }

    protected AttributeInitializer getAttributeInitializer() {
        return null;
    }

    protected void initializeAttributes() {
        AttributeInitializer attributeInitializer = this.getAttributeInitializer();
        if (attributeInitializer != null) {
            attributeInitializer.initializeAttributes(this);
        }
    }

    protected boolean resetAttribute(String string, String string2, String string3) {
        AttributeInitializer attributeInitializer = this.getAttributeInitializer();
        if (attributeInitializer == null) {
            return false;
        }
        return attributeInitializer.resetAttribute(this, string, string2, string3);
    }

    protected NamedNodeMap createAttributes() {
        return new ExtendedNamedNodeHashMap();
    }

    public void setUnspecifiedAttribute(String string, String string2, String string3) {
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        ((ExtendedNamedNodeHashMap)this.attributes).setUnspecifiedAttribute(string, string2, string3);
    }

    protected class ExtendedNamedNodeHashMap
    extends AbstractElement.NamedNodeHashMap {
        public ExtendedNamedNodeHashMap() {
            super(AbstractElement.this);
        }

        public Node setNamedItem(String string, String string2, Node node) throws DOMException {
            Attr attr = (Attr)super.setNamedItem(string, string2, node);
            LiveAttributeValue liveAttributeValue = AbstractElement.this.getLiveAttributeValue(string, string2);
            if (liveAttributeValue != null) {
                liveAttributeValue.valueChanged(attr, (Attr)node);
            }
            return attr;
        }

        public void setUnspecifiedAttribute(String string, String string2, String string3) {
            Attr attr = AbstractElement.this.getOwnerDocument().createAttributeNS(string, string2);
            attr.setValue(string3);
            ((AbstractAttr)attr).setSpecified(false);
            this.setNamedItemNS(attr);
        }

        public Node removeNamedItemNS(String string, String string2) throws DOMException {
            if (AbstractElement.this.isReadonly()) {
                throw AbstractElement.this.createDOMException((short)7, "readonly.node.map", new Object[0]);
            }
            if (string2 == null) {
                throw AbstractElement.this.createDOMException((short)8, "attribute.missing", new Object[]{""});
            }
            AbstractAttr abstractAttr = (AbstractAttr)this.remove(string, string2);
            if (abstractAttr == null) {
                throw AbstractElement.this.createDOMException((short)8, "attribute.missing", new Object[]{string2});
            }
            abstractAttr.setOwnerElement(null);
            String string3 = abstractAttr.getPrefix();
            if (!AbstractElement.this.resetAttribute(string, string3, string2)) {
                AbstractElement.this.fireDOMAttrModifiedEvent(abstractAttr.getNodeName(), abstractAttr.getNodeValue(), "");
            }
            return abstractAttr;
        }
    }
}

