/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLSupport {
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";

    protected XMLSupport() {
    }

    public static String getXMLLang(Element element) {
        Attr attr = element.getAttributeNodeNS(XML_NAMESPACE_URI, "lang");
        if (attr != null) {
            return attr.getNodeValue();
        }
        Node node = element.getParentNode();
        while (node != null) {
            if (node.getNodeType() == 1 && (attr = ((Element)node).getAttributeNodeNS(XML_NAMESPACE_URI, "lang")) != null) {
                return attr.getNodeValue();
            }
            node = node.getParentNode();
        }
        return "en";
    }

    public static void setXMLLang(Element element, String string) {
        element.setAttributeNS(XML_NAMESPACE_URI, "lang", string);
    }

    public static String getXMLSpace(Element element) {
        Attr attr = element.getAttributeNodeNS(XML_NAMESPACE_URI, "space");
        if (attr != null) {
            return attr.getNodeValue();
        }
        Node node = element.getParentNode();
        while (node != null) {
            if (node.getNodeType() == 1 && (attr = ((Element)node).getAttributeNodeNS(XML_NAMESPACE_URI, "space")) != null) {
                return attr.getNodeValue();
            }
            node = node.getParentNode();
        }
        return "default";
    }

    public static void setXMLSpace(Element element, String string) throws DOMException {
        if (!"default".equals(string) && !"preserve".equals(string)) {
            throw new DOMException(12, "Invalid attribute Value: " + string);
        }
        element.setAttributeNS(XML_NAMESPACE_URI, "space", string);
    }

    public static String defaultXMLSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\n': 
                case '\r': {
                    bl = false;
                    break;
                }
                case '\t': 
                case ' ': {
                    if (bl) break;
                    stringBuffer.append(' ');
                    bl = true;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                    bl = false;
                }
            }
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    public static String preserveXMLSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    stringBuffer.append(' ');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

