/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.g2d;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import org.apache.batik.ext.awt.g2d.GraphicContext;

public abstract class AbstractGraphics2D
extends Graphics2D
implements Cloneable {
    protected GraphicContext gc;
    protected boolean textAsShapes = false;

    public AbstractGraphics2D(boolean bl) {
        this.textAsShapes = bl;
    }

    public AbstractGraphics2D(AbstractGraphics2D abstractGraphics2D) {
        this.gc = (GraphicContext)abstractGraphics2D.gc.clone();
        this.gc.validateTransformStack();
        this.textAsShapes = abstractGraphics2D.textAsShapes;
    }

    public void translate(int n, int n2) {
        this.gc.translate(n, n2);
    }

    public Color getColor() {
        return this.gc.getColor();
    }

    public void setColor(Color color) {
        this.gc.setColor(color);
    }

    public void setPaintMode() {
        this.gc.setComposite(AlphaComposite.SrcOver);
    }

    public Font getFont() {
        return this.gc.getFont();
    }

    public void setFont(Font font) {
        this.gc.setFont(font);
    }

    public Rectangle getClipBounds() {
        return this.gc.getClipBounds();
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.gc.clipRect(n, n2, n3, n4);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.gc.setClip(n, n2, n3, n4);
    }

    public Shape getClip() {
        return this.gc.getClip();
    }

    public void setClip(Shape shape) {
        this.gc.setClip(shape);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        Line2D.Float float_ = new Line2D.Float(n, n2, n3, n4);
        this.draw(float_);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.fill(rectangle);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.draw(rectangle);
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        Paint paint = this.gc.getPaint();
        this.gc.setColor(this.gc.getBackground());
        this.fillRect(n, n2, n3, n4);
        this.gc.setPaint(paint);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6);
        this.draw(float_);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6);
        this.fill(float_);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(n, n2, n3, n4);
        this.draw(float_);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(n, n2, n3, n4);
        this.fill(float_);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Arc2D.Float float_ = new Arc2D.Float(n, n2, n3, n4, n5, n6, 0);
        this.draw(float_);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Arc2D.Float float_ = new Arc2D.Float(n, n2, n3, n4, n5, n6, 2);
        this.fill(float_);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (n > 0) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(nArray[0], nArray2[0]);
            int n2 = 1;
            while (n2 < n) {
                generalPath.lineTo(nArray[n2], nArray2[n2]);
                ++n2;
            }
            this.draw(generalPath);
        }
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon(nArray, nArray2, n);
        this.draw(polygon);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon(nArray, nArray2, n);
        this.fill(polygon);
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(null), image.getHeight(null), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        Paint paint = this.gc.getPaint();
        this.gc.setPaint(color);
        this.fillRect(n, n2, n3, n4);
        this.gc.setPaint(paint);
        this.drawImage(image, n, n2, imageObserver);
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        bufferedImage = bufferedImage.getSubimage(n5, n6, n7 - n5, n8 - n6);
        return this.drawImage(bufferedImage, n, n2, n3 - n, n4 - n2, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        Paint paint = this.gc.getPaint();
        this.gc.setPaint(color);
        this.fillRect(n, n2, n3 - n, n4 - n2);
        this.gc.setPaint(paint);
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        boolean bl = true;
        if (affineTransform.getDeterminant() != 0.0) {
            AffineTransform affineTransform2 = null;
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new Error();
            }
            this.gc.transform(affineTransform);
            bl = this.drawImage(image, 0, 0, null);
            this.gc.transform(affineTransform2);
        } else {
            AffineTransform affineTransform3 = new AffineTransform(this.gc.getTransform());
            this.gc.transform(affineTransform);
            bl = this.drawImage(image, 0, 0, null);
            this.gc.setTransform(affineTransform3);
        }
        return bl;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        this.drawImage((Image)bufferedImage, n, n2, null);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        Shape shape = glyphVector.getOutline(f, f2);
        this.fill(shape);
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        if (bl) {
            shape = this.gc.getStroke().createStrokedShape(shape);
        }
        shape = this.gc.getTransform().createTransformedShape(shape);
        return shape.intersects(rectangle);
    }

    public void setComposite(Composite composite) {
        this.gc.setComposite(composite);
    }

    public void setPaint(Paint paint) {
        this.gc.setPaint(paint);
    }

    public void setStroke(Stroke stroke) {
        this.gc.setStroke(stroke);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.gc.setRenderingHint(key, object);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.gc.getRenderingHint(key);
    }

    public void setRenderingHints(Map map) {
        this.gc.setRenderingHints(map);
    }

    public void addRenderingHints(Map map) {
        this.gc.addRenderingHints(map);
    }

    public RenderingHints getRenderingHints() {
        return this.gc.getRenderingHints();
    }

    public void translate(double d, double d2) {
        this.gc.translate(d, d2);
    }

    public void rotate(double d) {
        this.gc.rotate(d);
    }

    public void rotate(double d, double d2, double d3) {
        this.gc.rotate(d, d2, d3);
    }

    public void scale(double d, double d2) {
        this.gc.scale(d, d2);
    }

    public void shear(double d, double d2) {
        this.gc.shear(d, d2);
    }

    public void transform(AffineTransform affineTransform) {
        this.gc.transform(affineTransform);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.gc.setTransform(affineTransform);
    }

    public AffineTransform getTransform() {
        return this.gc.getTransform();
    }

    public Paint getPaint() {
        return this.gc.getPaint();
    }

    public Composite getComposite() {
        return this.gc.getComposite();
    }

    public void setBackground(Color color) {
        this.gc.setBackground(color);
    }

    public Color getBackground() {
        return this.gc.getBackground();
    }

    public Stroke getStroke() {
        return this.gc.getStroke();
    }

    public void clip(Shape shape) {
        this.gc.clip(shape);
    }

    public FontRenderContext getFontRenderContext() {
        return this.gc.getFontRenderContext();
    }
}

