/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Color;
import org.apache.batik.ext.awt.image.Light;

public class PointLight
implements Light {
    private double lightX;
    private double lightY;
    private double lightZ;
    private double[] color;

    public double getLightX() {
        return this.lightX;
    }

    public double getLightY() {
        return this.lightY;
    }

    public double getLightZ() {
        return this.lightZ;
    }

    public double[] getColor() {
        return this.color;
    }

    public PointLight(double d, double d2, double d3, Color color) {
        this.lightX = d;
        this.lightY = d2;
        this.lightZ = d3;
        this.setColor(color);
    }

    public void setColor(Color color) {
        double[] dArray = new double[]{(double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0};
        this.color = dArray;
    }

    public boolean isConstant() {
        return false;
    }

    public final void getLight(double d, double d2, double d3, double[] dArray) {
        dArray[0] = this.lightX - d;
        dArray[1] = this.lightY - d2;
        dArray[2] = this.lightZ - d3;
        double d4 = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        if (d4 > 0.0) {
            double d5 = 1.0 / d4;
            dArray[0] = dArray[0] * d5;
            dArray[1] = dArray[1] * d5;
            dArray[2] = dArray[2] * d5;
        }
    }

    public double[][][] getLightMap(double d, double d2, double d3, double d4, int n, int n2, double[][][] dArray) {
        double[][][] dArrayArray = new double[n2][][];
        int n3 = 0;
        while (n3 < n2) {
            dArrayArray[n3] = this.getLightRow(d, d2, d3, n, dArray[n3], null);
            d2 += d4;
            ++n3;
        }
        return dArrayArray;
    }

    public double[][] getLightRow(double d, double d2, double d3, int n, double[][] dArray, double[][] dArray2) {
        double[][] dArray3 = dArray2;
        if (dArray3 == null) {
            dArray3 = new double[n][3];
        }
        int n2 = 0;
        while (n2 < n) {
            this.getLight(d, d2, dArray[n2][3], dArray3[n2]);
            d += d3;
            ++n2;
        }
        return dArray3;
    }
}

