/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class GaussianBlurRed8Bit
extends AbstractRed {
    int xinset;
    int yinset;
    double stdDevX;
    double stdDevY;
    RenderingHints hints;
    ConvolveOp[] convOp = new ConvolveOp[2];
    int dX;
    int dY;
    static final float SQRT2PI = (float)Math.sqrt(Math.PI * 2);
    static final float DSQRT2PI = SQRT2PI * 3.0f / 4.0f;
    static final float precision = 0.499f;

    public GaussianBlurRed8Bit(CachableRed cachableRed, double d, RenderingHints renderingHints) {
        this(cachableRed, d, d, renderingHints);
    }

    /*
     * Unable to fully structure code
     */
    public GaussianBlurRed8Bit(CachableRed var1_1, double var2_2, double var4_3, RenderingHints var6_4) {
        super();
        this.stdDevX = var2_2;
        this.stdDevY = var4_3;
        this.hints = var6_4;
        this.xinset = GaussianBlurRed8Bit.surroundPixels(var2_2, var6_4);
        this.yinset = GaussianBlurRed8Bit.surroundPixels(var4_3, var6_4);
        var7_5 = var1_1.getBounds();
        var7_5.x += this.xinset;
        var7_5.y += this.yinset;
        var7_5.width -= 2 * this.xinset;
        var7_5.height -= 2 * this.yinset;
        if (var7_5.width <= 0 || var7_5.height <= 0) {
            var7_5.width = 0;
            var7_5.height = 0;
        }
        var8_6 = GaussianBlurRed8Bit.fixColorModel(var1_1);
        var9_7 = var1_1.getSampleModel();
        var10_8 = var9_7.getWidth();
        var11_9 = var9_7.getHeight();
        if (var10_8 > var7_5.width) {
            var10_8 = var7_5.width;
        }
        if (var11_9 > var7_5.height) {
            var11_9 = var7_5.height;
        }
        var9_7 = var8_6.createCompatibleSampleModel(var10_8, var11_9);
        this.init(var1_1, var7_5, var8_6, var9_7, var1_1.getTileGridXOffset() + this.xinset, var1_1.getTileGridYOffset() + this.yinset, null);
        if (this.hints == null) ** GOTO lbl-1000
        if (RenderingHints.VALUE_RENDER_QUALITY.equals(this.hints.get(RenderingHints.KEY_RENDERING))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var12_10 = false;
        }
        if (var2_2 < 2.0 || var12_10) {
            this.convOp[0] = new ConvolveOp(this.makeQualityKernelX(this.xinset * 2 + 1));
        } else {
            this.dX = (int)Math.floor((double)GaussianBlurRed8Bit.DSQRT2PI * var2_2 + 0.5);
        }
        if (var4_3 < 2.0 || var12_10) {
            this.convOp[1] = new ConvolveOp(this.makeQualityKernelY(this.yinset * 2 + 1));
        } else {
            this.dY = (int)Math.floor((double)GaussianBlurRed8Bit.DSQRT2PI * var4_3 + 0.5);
        }
    }

    public static int surroundPixels(double d) {
        return GaussianBlurRed8Bit.surroundPixels(d, null);
    }

    public static int surroundPixels(double d, RenderingHints renderingHints) {
        boolean bl;
        boolean bl2 = bl = renderingHints != null && RenderingHints.VALUE_RENDER_QUALITY.equals(renderingHints.get(RenderingHints.KEY_RENDERING));
        if (d < 2.0 || bl) {
            float f = (float)(0.5 / (d * (double)SQRT2PI));
            int n = 0;
            while (f < 0.499f) {
                f += (float)(Math.pow(Math.E, (double)(-n * n) / (2.0 * d * d)) / (d * (double)SQRT2PI));
                ++n;
            }
            return n;
        }
        int n = (int)Math.floor((double)DSQRT2PI * d + 0.5);
        if (n % 2 == 0) {
            return n - 1 + n / 2;
        }
        return n - 2 + n / 2;
    }

    private float[] computeQualityKernelData(int n, double d) {
        float[] fArray = new float[n];
        int n2 = n / 2;
        float f = 0.0f;
        int n3 = 0;
        while (n3 < n) {
            fArray[n3] = (float)(Math.pow(Math.E, (double)(-(n3 - n2) * (n3 - n2)) / (2.0 * d * d)) / ((double)SQRT2PI * d));
            f += fArray[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            int n5 = n4++;
            fArray[n5] = fArray[n5] / f;
        }
        return fArray;
    }

    private Kernel makeQualityKernelX(int n) {
        return new Kernel(n, 1, this.computeQualityKernelData(n, this.stdDevX));
    }

    private Kernel makeQualityKernelY(int n) {
        return new Kernel(1, n, this.computeQualityKernelData(n, this.stdDevY));
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        int n;
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        Rectangle rectangle = writableRaster.getBounds();
        rectangle.x -= this.xinset;
        rectangle.y -= this.yinset;
        rectangle.width += 2 * this.xinset;
        rectangle.height += 2 * this.yinset;
        ColorModel colorModel = cachableRed.getColorModel();
        ColorModel colorModel2 = this.getColorModel();
        WritableRaster writableRaster2 = null;
        WritableRaster writableRaster3 = null;
        writableRaster2 = colorModel.createCompatibleWritableRaster(rectangle.width, rectangle.height);
        WritableRaster writableRaster4 = writableRaster2.createWritableTranslatedChild(rectangle.x, rectangle.y);
        cachableRed.copyData(writableRaster4);
        if (colorModel.hasAlpha() && !colorModel.isAlphaPremultiplied()) {
            GraphicsUtil.coerceData(writableRaster2, colorModel, true);
        }
        if (this.convOp[0] != null) {
            writableRaster3 = this.getColorModel().createCompatibleWritableRaster(rectangle.width, rectangle.height);
            writableRaster3 = this.convOp[0].filter(writableRaster2, writableRaster3);
            n = this.convOp[0].getKernel().getXOrigin();
            WritableRaster writableRaster5 = writableRaster2;
            writableRaster2 = writableRaster3;
            writableRaster3 = writableRaster5;
        } else if ((this.dX & 1) == 0) {
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, 0, 0, this.dX, this.dX / 2);
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, this.dX / 2, 0, this.dX, this.dX / 2 - 1);
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, this.dX - 1, 0, this.dX + 1, this.dX / 2);
            n = this.dX - 1 + this.dX / 2;
        } else {
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, 0, 0, this.dX, this.dX / 2);
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, this.dX / 2, 0, this.dX, this.dX / 2);
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, this.dX - 2, 0, this.dX, this.dX / 2);
            n = this.dX - 2 + this.dX / 2;
        }
        if (this.convOp[1] != null) {
            if (writableRaster3 == null) {
                writableRaster3 = this.getColorModel().createCompatibleWritableRaster(rectangle.width, rectangle.height);
            }
            writableRaster3 = this.convOp[1].filter(writableRaster2, writableRaster3);
        } else {
            if ((this.dY & 1) == 0) {
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n, 0, this.dY, this.dY / 2);
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n, this.dY / 2, this.dY, this.dY / 2 - 1);
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n, this.dY - 1, this.dY + 1, this.dY / 2);
            } else {
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n, 0, this.dY, this.dY / 2);
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n, this.dY / 2, this.dY, this.dY / 2);
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n, this.dY - 2, this.dY, this.dY / 2);
            }
            writableRaster3 = writableRaster2;
        }
        writableRaster3 = writableRaster3.createWritableTranslatedChild(rectangle.x, rectangle.y);
        GraphicsUtil.copyData(writableRaster3, writableRaster);
        return writableRaster;
    }

    private WritableRaster boxFilterH(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4) {
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        if (n5 < 2 * n + n3) {
            return writableRaster;
        }
        if (n6 < 2 * n2) {
            return writableRaster;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n7 = singlePixelPackedSampleModel.getScanlineStride();
        int n8 = singlePixelPackedSampleModel2.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n9 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
        int n10 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int n11 = 0x1000000 / n3;
        int n12 = n2;
        while (n12 < n6 - n2) {
            int n13;
            int n14 = n9 + n12 * n7;
            int n15 = n10 + n12 * n8;
            int n16 = n14 + (n5 - n);
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            int n22 = (n14 += n) + n3;
            while (n14 < n22) {
                n13 = nArray[n14];
                nArray3[n17] = n13 >>> 24;
                n18 += nArray3[n17];
                nArray4[n17] = n13 >> 16 & 0xFF;
                n19 += nArray4[n17];
                nArray5[n17] = n13 >> 8 & 0xFF;
                n20 += nArray5[n17];
                nArray6[n17] = n13 & 0xFF;
                n21 += nArray6[n17];
                ++n17;
                ++n14;
            }
            nArray2[n15 += n + n4] = n18 * n11 & 0xFF000000 | (n19 * n11 & 0xFF000000) >>> 8 | (n20 * n11 & 0xFF000000) >>> 16 | (n21 * n11 & 0xFF000000) >>> 24;
            ++n15;
            n17 = 0;
            while (n14 < n16) {
                n13 = nArray[n14];
                n18 -= nArray3[n17];
                nArray3[n17] = n13 >>> 24;
                n18 += nArray3[n17];
                n19 -= nArray4[n17];
                nArray4[n17] = n13 >> 16 & 0xFF;
                n20 -= nArray5[n17];
                nArray5[n17] = n13 >> 8 & 0xFF;
                n21 -= nArray6[n17];
                nArray6[n17] = n13 & 0xFF;
                nArray2[n15] = n18 * n11 & 0xFF000000 | ((n19 += nArray4[n17]) * n11 & 0xFF000000) >>> 8 | ((n20 += nArray5[n17]) * n11 & 0xFF000000) >>> 16 | ((n21 += nArray6[n17]) * n11 & 0xFF000000) >>> 24;
                n17 = (n17 + 1) % n3;
                ++n14;
                ++n15;
            }
            ++n12;
        }
        return writableRaster;
    }

    private WritableRaster boxFilterV(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4) {
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        if (n5 < 2 * n) {
            return writableRaster;
        }
        if (n6 < 2 * n2 + n3) {
            return writableRaster;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n7 = singlePixelPackedSampleModel.getScanlineStride();
        int n8 = singlePixelPackedSampleModel2.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n9 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
        int n10 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int n11 = 0x1000000 / n3;
        int n12 = n;
        while (n12 < n5 - n) {
            int n13;
            int n14 = n9 + n12;
            int n15 = n10 + n12;
            int n16 = n14 + (n6 - n2) * n7;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            int n22 = (n14 += n2 * n7) + n3 * n7;
            while (n14 < n22) {
                n13 = nArray[n14];
                nArray3[n17] = n13 >>> 24;
                n18 += nArray3[n17];
                nArray4[n17] = n13 >> 16 & 0xFF;
                n19 += nArray4[n17];
                nArray5[n17] = n13 >> 8 & 0xFF;
                n20 += nArray5[n17];
                nArray6[n17] = n13 & 0xFF;
                n21 += nArray6[n17];
                ++n17;
                n14 += n7;
            }
            nArray2[n15 += (n2 + n4) * n8] = n18 * n11 & 0xFF000000 | (n19 * n11 & 0xFF000000) >>> 8 | (n20 * n11 & 0xFF000000) >>> 16 | (n21 * n11 & 0xFF000000) >>> 24;
            n15 += n8;
            n17 = 0;
            while (n14 < n16) {
                n13 = nArray[n14];
                n18 -= nArray3[n17];
                nArray3[n17] = n13 >>> 24;
                n18 += nArray3[n17];
                n19 -= nArray4[n17];
                nArray4[n17] = n13 >> 16 & 0xFF;
                n20 -= nArray5[n17];
                nArray5[n17] = n13 >> 8 & 0xFF;
                n21 -= nArray6[n17];
                nArray6[n17] = n13 & 0xFF;
                nArray2[n15] = n18 * n11 & 0xFF000000 | ((n19 += nArray4[n17]) * n11 & 0xFF000000) >>> 8 | ((n20 += nArray5[n17]) * n11 & 0xFF000000) >>> 16 | ((n21 += nArray6[n17]) * n11 & 0xFF000000) >>> 24;
                n17 = (n17 + 1) % n3;
                n14 += n7;
                n15 += n8;
            }
            ++n12;
        }
        return writableRaster;
    }

    protected static ColorModel fixColorModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        int n = cachableRed.getSampleModel().getNumBands();
        int[] nArray = new int[4];
        switch (n) {
            case 1: {
                nArray[0] = 255;
                break;
            }
            case 2: {
                nArray[0] = 255;
                nArray[3] = 65280;
                break;
            }
            case 3: {
                nArray[0] = 0xFF0000;
                nArray[1] = 65280;
                nArray[2] = 255;
                break;
            }
            case 4: {
                nArray[0] = 0xFF0000;
                nArray[1] = 65280;
                nArray[2] = 255;
                nArray[3] = -16777216;
                break;
            }
            default: {
                throw new IllegalArgumentException("GaussianBlurRed8Bit only supports one to four band images");
            }
        }
        ColorSpace colorSpace = colorModel.getColorSpace();
        return new DirectColorModel(colorSpace, 8 * n, nArray[0], nArray[1], nArray[2], nArray[3], true, 3);
    }
}

