/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.text.ArabicTextHandler;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;

public class AWTGVTGlyphVector
implements GVTGlyphVector {
    private GlyphVector awtGlyphVector;
    private AWTGVTFont gvtFont;
    private CharacterIterator ci;
    private Point2D[] glyphPositions;
    private AffineTransform[] glyphTransforms;
    private Shape[] glyphOutlines;
    private Shape[] glyphVisualBounds;
    private Shape[] glyphLogicalBounds;
    private boolean[] glyphVisible;
    private GeneralPath outline;
    private Rectangle2D logicalBounds;
    private float scaleFactor;

    public AWTGVTGlyphVector(GlyphVector glyphVector, AWTGVTFont aWTGVTFont, float f, CharacterIterator characterIterator) {
        this.awtGlyphVector = glyphVector;
        this.gvtFont = aWTGVTFont;
        this.scaleFactor = f;
        this.ci = characterIterator;
        int n = glyphVector.getNumGlyphs();
        this.outline = null;
        this.logicalBounds = null;
        this.glyphTransforms = new AffineTransform[n];
        this.glyphPositions = new Point2D.Float[n];
        this.glyphOutlines = new Shape[n];
        this.glyphVisualBounds = new Shape[n];
        this.glyphLogicalBounds = new Shape[n];
        this.glyphVisible = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            this.glyphVisible[n2] = true;
            ++n2;
        }
    }

    public GVTFont getFont() {
        return this.gvtFont;
    }

    public FontRenderContext getFontRenderContext() {
        return this.awtGlyphVector.getFontRenderContext();
    }

    public int getGlyphCode(int n) {
        return this.awtGlyphVector.getGlyphCode(n);
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) {
        return this.awtGlyphVector.getGlyphCodes(n, n2, nArray);
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        return this.awtGlyphVector.getGlyphJustificationInfo(n);
    }

    public Shape getGlyphLogicalBounds(int n) {
        if (this.glyphLogicalBounds[n] == null && this.glyphVisible[n]) {
            this.computeGlyphLogicalBounds();
        }
        return this.glyphLogicalBounds[n];
    }

    private void computeGlyphLogicalBounds() {
        Cloneable cloneable;
        Cloneable cloneable2;
        Cloneable cloneable3;
        GVTLineMetrics gVTLineMetrics = this.gvtFont.getLineMetrics("By", this.awtGlyphVector.getFontRenderContext());
        float f = gVTLineMetrics.getAscent();
        float f2 = gVTLineMetrics.getDescent();
        Shape[] shapeArray = new Shape[this.getNumGlyphs()];
        boolean[] blArray = new boolean[this.getNumGlyphs()];
        boolean[] blArray2 = new boolean[this.getNumGlyphs()];
        boolean[] blArray3 = new boolean[this.getNumGlyphs()];
        double d = -1.0;
        double d2 = -1.0;
        int n = 0;
        while (n < this.getNumGlyphs()) {
            if (!this.glyphVisible[n]) {
                shapeArray[n] = null;
            } else {
                float f3;
                cloneable3 = this.getGlyphTransform(n);
                float f4 = 0.0f;
                float f5 = -f;
                GVTGlyphMetrics gVTGlyphMetrics = this.getGlyphMetrics(n);
                float f6 = gVTGlyphMetrics.getHorizontalAdvance();
                Rectangle2D.Double double_ = new Rectangle2D.Double(f4, f5, f6, f3 = gVTGlyphMetrics.getVerticalAdvance());
                if (((RectangularShape)double_).isEmpty()) {
                    if (n > 0) {
                        blArray[n] = blArray[n - 1];
                        blArray2[n] = blArray2[n - 1];
                        blArray3[n] = blArray3[n - 1];
                    } else {
                        blArray[n] = true;
                        blArray2[n] = false;
                        blArray3[n] = false;
                    }
                } else {
                    Rectangle2D rectangle2D;
                    double d3;
                    Point2D.Double double_2 = new Point2D.Double(double_.getMinX(), double_.getMinY());
                    Point2D.Double double_3 = new Point2D.Double(double_.getMaxX(), double_.getMinY());
                    cloneable2 = new Point2D.Double(double_.getMinX(), double_.getMaxY());
                    AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.getGlyphPosition(n).getX(), this.getGlyphPosition(n).getY());
                    if (cloneable3 != null) {
                        affineTransform.concatenate((AffineTransform)cloneable3);
                    }
                    shapeArray[n] = affineTransform.createTransformedShape(double_);
                    Point2D.Double double_4 = new Point2D.Double();
                    Point2D.Double double_5 = new Point2D.Double();
                    cloneable = new Point2D.Double();
                    affineTransform.transform(double_2, double_4);
                    affineTransform.transform(double_3, double_5);
                    affineTransform.transform((Point2D)cloneable2, (Point2D)cloneable);
                    double d4 = ((Point2D)double_4).getX() - ((Point2D)double_5).getX();
                    double d5 = ((Point2D)double_4).getX() - ((Point2D)cloneable).getX();
                    double d6 = ((Point2D)double_4).getY() - ((Point2D)double_5).getY();
                    double d7 = ((Point2D)double_4).getY() - ((Point2D)cloneable).getY();
                    if (Math.abs(d4) < 0.001 && Math.abs(d7) < 0.001) {
                        blArray[n] = false;
                        double d8 = ((Point2D)double_2).getX() - ((Point2D)cloneable2).getX();
                        d3 = ((Point2D)double_2).getY() - ((Point2D)double_3).getY();
                        if (Math.abs(d5 + d8) < 0.001) {
                            blArray2[n] = true;
                        }
                        if (Math.abs(d6 + d3) < 0.001) {
                            blArray3[n] = true;
                        }
                    } else if (Math.abs(d5) < 0.001 && Math.abs(d6) < 0.001) {
                        blArray[n] = false;
                        double d9 = ((Point2D)double_2).getX() - ((Point2D)double_3).getX();
                        d3 = ((Point2D)double_2).getY() - ((Point2D)cloneable2).getY();
                        if (Math.abs(d4 + d9) < 0.001) {
                            blArray2[n] = true;
                        }
                        if (Math.abs(d7 + d3) < 0.001) {
                            blArray3[n] = true;
                        }
                    } else {
                        blArray[n] = true;
                        blArray2[n] = false;
                        blArray3[n] = false;
                    }
                    if ((rectangle2D = shapeArray[n].getBounds2D()).getWidth() > d) {
                        d = rectangle2D.getWidth();
                    }
                    if (rectangle2D.getHeight() > d2) {
                        d2 = rectangle2D.getHeight();
                    }
                }
            }
            ++n;
        }
        cloneable3 = new GeneralPath();
        int n2 = 0;
        while (n2 < this.getNumGlyphs()) {
            if (shapeArray[n2] != null) {
                ((Path2D)cloneable3).append(shapeArray[n2], false);
            }
            ++n2;
        }
        Rectangle2D rectangle2D = ((Path2D.Float)cloneable3).getBounds2D();
        if (rectangle2D.getHeight() < d2 * 1.5) {
            int n3 = 0;
            while (n3 < this.getNumGlyphs()) {
                if (!blArray[n3] && shapeArray[n3] != null) {
                    Rectangle2D rectangle2D2 = shapeArray[n3].getBounds2D();
                    double d10 = rectangle2D2.getMinX();
                    double d11 = rectangle2D2.getWidth();
                    if (n3 < this.getNumGlyphs() - 1 && shapeArray[n3 + 1] != null) {
                        cloneable2 = shapeArray[n3 + 1].getBounds2D();
                        if (((RectangularShape)cloneable2).getX() > d10) {
                            d11 = ((RectangularShape)cloneable2).getX() - d10;
                        } else {
                            double d12 = ((RectangularShape)cloneable2).getX() + ((RectangularShape)cloneable2).getWidth();
                            d11 += d10 - d12;
                            d10 = d12;
                        }
                    }
                    float f7 = (float)d10;
                    float f8 = (float)((double)f7 + d11);
                    float f9 = (float)rectangle2D.getMinY();
                    float f10 = (float)((double)f9 + rectangle2D.getHeight());
                    if (blArray2[n3]) {
                        if (blArray3[n3]) {
                            cloneable = new GeneralPath();
                            ((Path2D.Float)cloneable).moveTo(f8, f10);
                            ((Path2D.Float)cloneable).lineTo(f7, f10);
                            ((Path2D.Float)cloneable).lineTo(f7, f9);
                            ((Path2D.Float)cloneable).lineTo(f8, f9);
                            ((Path2D.Float)cloneable).lineTo(f8, f10);
                            ((Path2D)cloneable).closePath();
                            shapeArray[n3] = cloneable;
                        } else {
                            cloneable = new GeneralPath();
                            ((Path2D.Float)cloneable).moveTo(f8, f9);
                            ((Path2D.Float)cloneable).lineTo(f7, f9);
                            ((Path2D.Float)cloneable).lineTo(f7, f10);
                            ((Path2D.Float)cloneable).lineTo(f8, f10);
                            ((Path2D.Float)cloneable).lineTo(f8, f9);
                            ((Path2D)cloneable).closePath();
                            shapeArray[n3] = cloneable;
                        }
                    } else if (blArray3[n3]) {
                        cloneable = new GeneralPath();
                        ((Path2D.Float)cloneable).moveTo(f7, f10);
                        ((Path2D.Float)cloneable).lineTo(f8, f10);
                        ((Path2D.Float)cloneable).lineTo(f8, f9);
                        ((Path2D.Float)cloneable).lineTo(f7, f9);
                        ((Path2D.Float)cloneable).lineTo(f7, f10);
                        ((Path2D)cloneable).closePath();
                        shapeArray[n3] = cloneable;
                    } else {
                        shapeArray[n3] = new Rectangle2D.Double(f7, f9, f8 - f7, f10 - f9);
                    }
                }
                ++n3;
            }
        } else if (rectangle2D.getWidth() < d * 1.5) {
            int n4 = 0;
            while (n4 < this.getNumGlyphs()) {
                if (!blArray[n4] && shapeArray[n4] != null) {
                    Rectangle2D rectangle2D3 = shapeArray[n4].getBounds2D();
                    double d13 = rectangle2D3.getMinY();
                    double d14 = rectangle2D3.getHeight();
                    if (n4 < this.getNumGlyphs() - 1 && shapeArray[n4 + 1] != null) {
                        cloneable2 = shapeArray[n4 + 1].getBounds2D();
                        if (((RectangularShape)cloneable2).getY() > d13) {
                            d14 = ((RectangularShape)cloneable2).getY() - d13;
                        } else {
                            double d15 = ((RectangularShape)cloneable2).getY() + ((RectangularShape)cloneable2).getHeight();
                            d14 += d13 - d15;
                            d13 = d15;
                        }
                    }
                    float f11 = (float)rectangle2D.getMinX();
                    float f12 = (float)((double)f11 + rectangle2D.getWidth());
                    float f13 = (float)d13;
                    float f14 = (float)((double)f13 + d14);
                    if (blArray2[n4]) {
                        if (blArray3[n4]) {
                            cloneable = new GeneralPath();
                            ((Path2D.Float)cloneable).moveTo(f12, f14);
                            ((Path2D.Float)cloneable).lineTo(f11, f14);
                            ((Path2D.Float)cloneable).lineTo(f11, f13);
                            ((Path2D.Float)cloneable).lineTo(f12, f13);
                            ((Path2D.Float)cloneable).lineTo(f12, f14);
                            ((Path2D)cloneable).closePath();
                            shapeArray[n4] = cloneable;
                        } else {
                            cloneable = new GeneralPath();
                            ((Path2D.Float)cloneable).moveTo(f12, f13);
                            ((Path2D.Float)cloneable).lineTo(f11, f13);
                            ((Path2D.Float)cloneable).lineTo(f11, f14);
                            ((Path2D.Float)cloneable).lineTo(f12, f14);
                            ((Path2D.Float)cloneable).lineTo(f12, f13);
                            ((Path2D)cloneable).closePath();
                            shapeArray[n4] = cloneable;
                        }
                    } else if (blArray3[n4]) {
                        cloneable = new GeneralPath();
                        ((Path2D.Float)cloneable).moveTo(f11, f14);
                        ((Path2D.Float)cloneable).lineTo(f12, f14);
                        ((Path2D.Float)cloneable).lineTo(f12, f13);
                        ((Path2D.Float)cloneable).lineTo(f11, f13);
                        ((Path2D.Float)cloneable).lineTo(f11, f14);
                        ((Path2D)cloneable).closePath();
                        shapeArray[n4] = cloneable;
                    } else {
                        shapeArray[n4] = new Rectangle2D.Double(f11, f13, f12 - f11, f14 - f13);
                    }
                }
                ++n4;
            }
        }
        int n5 = 0;
        while (n5 < this.getNumGlyphs()) {
            this.glyphLogicalBounds[n5] = shapeArray[n5];
            ++n5;
        }
    }

    public GVTGlyphMetrics getGlyphMetrics(int n) {
        GVTLineMetrics gVTLineMetrics = this.gvtFont.getLineMetrics("By", this.awtGlyphVector.getFontRenderContext());
        float f = gVTLineMetrics.getAscent() * this.scaleFactor;
        float f2 = gVTLineMetrics.getDescent() * this.scaleFactor;
        GlyphMetrics glyphMetrics = this.awtGlyphVector.getGlyphMetrics(n);
        Rectangle2D rectangle2D = glyphMetrics.getBounds2D();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() * (double)this.scaleFactor, rectangle2D.getY() * (double)this.scaleFactor, rectangle2D.getWidth() * (double)this.scaleFactor, rectangle2D.getHeight() * (double)this.scaleFactor);
        return new GVTGlyphMetrics(glyphMetrics.getAdvance() * this.scaleFactor, f + f2, double_, 0);
    }

    public Shape getGlyphOutline(int n) {
        if (this.glyphOutlines[n] == null) {
            Shape shape = this.awtGlyphVector.getGlyphOutline(n);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.getGlyphPosition(n).getX(), this.getGlyphPosition(n).getY());
            AffineTransform affineTransform2 = this.getGlyphTransform(n);
            if (affineTransform2 != null) {
                affineTransform.concatenate(affineTransform2);
            }
            affineTransform.scale(this.scaleFactor, this.scaleFactor);
            this.glyphOutlines[n] = affineTransform.createTransformedShape(shape);
        }
        return this.glyphOutlines[n];
    }

    public Point2D getGlyphPosition(int n) {
        return this.glyphPositions[n];
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        if (fArray == null) {
            fArray = new float[n2 * 2];
        }
        int n3 = n;
        while (n3 < n + n2) {
            Point2D point2D = this.getGlyphPosition(n3);
            fArray[(n3 - n) * 2] = (float)point2D.getX();
            fArray[(n3 - n) * 2 + 1] = (float)point2D.getY();
            ++n3;
        }
        return fArray;
    }

    public AffineTransform getGlyphTransform(int n) {
        return this.glyphTransforms[n];
    }

    public Shape getGlyphVisualBounds(int n) {
        if (this.glyphVisualBounds[n] == null) {
            Shape shape = this.awtGlyphVector.getGlyphOutline(n);
            Rectangle2D rectangle2D = shape.getBounds2D();
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.getGlyphPosition(n).getX(), this.getGlyphPosition(n).getY());
            AffineTransform affineTransform2 = this.getGlyphTransform(n);
            if (affineTransform2 != null) {
                affineTransform.concatenate(affineTransform2);
            }
            affineTransform.scale(this.scaleFactor, this.scaleFactor);
            this.glyphVisualBounds[n] = affineTransform.createTransformedShape(rectangle2D);
        }
        return this.glyphVisualBounds[n];
    }

    public Rectangle2D getLogicalBounds() {
        if (this.logicalBounds == null) {
            GeneralPath generalPath = new GeneralPath();
            int n = 0;
            while (n < this.getNumGlyphs()) {
                Shape shape = this.getGlyphLogicalBounds(n);
                if (shape != null) {
                    generalPath.append(shape, false);
                }
                ++n;
            }
            this.logicalBounds = generalPath.getBounds2D();
        }
        return this.logicalBounds;
    }

    public int getNumGlyphs() {
        return this.awtGlyphVector.getNumGlyphs();
    }

    public Shape getOutline() {
        if (this.outline == null) {
            this.outline = new GeneralPath();
            int n = 0;
            while (n < this.getNumGlyphs()) {
                if (this.glyphVisible[n]) {
                    Shape shape = this.getGlyphOutline(n);
                    this.outline.append(shape, false);
                }
                ++n;
            }
        }
        return this.outline;
    }

    public Shape getOutline(float f, float f2) {
        Shape shape = this.getOutline();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        shape = affineTransform.createTransformedShape(shape);
        return shape;
    }

    public Rectangle2D getVisualBounds() {
        Shape shape = this.getOutline();
        return shape.getBounds2D();
    }

    public void performDefaultLayout() {
        this.awtGlyphVector.performDefaultLayout();
        this.outline = null;
        this.logicalBounds = null;
        float f = 0.0f;
        int n = 0;
        while (n < this.getNumGlyphs()) {
            Point2D point2D = this.awtGlyphVector.getGlyphPosition(n);
            this.glyphPositions[n] = new Point2D.Float((float)((point2D.getX() - (double)f) * (double)this.scaleFactor), (float)(point2D.getY() * (double)this.scaleFactor));
            this.glyphTransforms[n] = null;
            this.glyphVisualBounds[n] = null;
            this.glyphLogicalBounds[n] = null;
            this.glyphOutlines[n] = null;
            char c = this.ci.setIndex(n + this.ci.getBeginIndex());
            if (ArabicTextHandler.arabicCharTransparent(c)) {
                GlyphMetrics glyphMetrics = this.awtGlyphVector.getGlyphMetrics(n);
                f = glyphMetrics.getAdvance();
            }
            ++n;
        }
    }

    public void setGlyphPosition(int n, Point2D point2D) {
        this.glyphPositions[n] = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
        this.outline = null;
        this.logicalBounds = null;
        this.glyphVisualBounds[n] = null;
        this.glyphLogicalBounds[n] = null;
        this.glyphOutlines[n] = null;
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        this.glyphTransforms[n] = affineTransform;
        this.outline = null;
        this.logicalBounds = null;
        this.glyphVisualBounds[n] = null;
        this.glyphLogicalBounds[n] = null;
        this.glyphOutlines[n] = null;
    }

    public void setGlyphVisible(int n, boolean bl) {
        this.glyphVisible[n] = bl;
        this.outline = null;
        this.logicalBounds = null;
        this.glyphVisualBounds[n] = null;
        this.glyphLogicalBounds[n] = null;
        this.glyphOutlines[n] = null;
    }

    public int getCharacterCount(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.getNumGlyphs() - 1) {
            n2 = this.getNumGlyphs() - 1;
        }
        int n3 = 0;
        int n4 = this.ci.getBeginIndex() + n;
        while (n4 <= this.ci.getBeginIndex() + n2) {
            char c = this.ci.setIndex(n4);
            n3 = ArabicTextHandler.isLigature(c) ? (n3 += ArabicTextHandler.getNumChars(c)) : ++n3;
            ++n4;
        }
        return n3;
    }

    public void draw(Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        Shape shape = this.getOutline();
        Paint paint = (Paint)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND);
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(shape);
        }
        Stroke stroke = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE);
        paint = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE_PAINT);
        if (stroke != null && paint != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(shape);
        }
    }
}

