/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.parser.DefaultErrorHandler;
import org.apache.batik.parser.ErrorHandler;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.Parser;

public abstract class AbstractParser
implements Parser {
    public static final String BUNDLE_CLASSNAME = "org.apache.batik.parser.resources.Messages";
    protected ErrorHandler errorHandler = new DefaultErrorHandler();
    protected LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.parser.resources.Messages");
    protected Reader reader;
    protected int line = 1;
    protected int column = 1;
    protected char[] buffer = new char[4096];
    protected int position;
    protected int count;
    protected int current;
    protected int previous;

    public int getCurrent() {
        return this.current;
    }

    public void setLocale(Locale locale) {
        this.localizableSupport.setLocale(locale);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        return this.localizableSupport.formatMessage(string, objectArray);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected void initialize(Reader reader) {
        this.reader = reader;
    }

    protected void read() {
        try {
            if (this.position == this.count) {
                this.position = 0;
                this.count = this.reader.read(this.buffer, 0, this.buffer.length);
                if (this.count == -1) {
                    this.count = 0;
                    this.current = -1;
                    return;
                }
            }
            int n = this.buffer[this.position++];
            switch (n) {
                case -1: {
                    this.previous = -1;
                    this.current = -1;
                    return;
                }
                case 10: {
                    if (this.previous == 13) {
                        this.previous = 10;
                        this.read();
                        return;
                    }
                    ++this.line;
                    this.column = 1;
                    this.previous = n;
                    break;
                }
                case 13: {
                    this.previous = n;
                    n = 10;
                    ++this.line;
                    this.column = 1;
                    break;
                }
                default: {
                    this.previous = n;
                    ++this.column;
                }
            }
            this.current = n;
        }
        catch (IOException iOException) {
            this.errorHandler.error(new ParseException(this.createErrorMessage("io.exception", null), iOException));
        }
    }

    protected void reportError(String string, Object[] objectArray) throws ParseException {
        this.errorHandler.error(new ParseException(this.createErrorMessage(string, objectArray), this.line, this.column));
    }

    protected String createErrorMessage(String string, Object[] objectArray) {
        try {
            return this.formatMessage(string, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    protected String getBundleClassName() {
        return BUNDLE_CLASSNAME;
    }

    protected void skipSpaces() {
        while (true) {
            switch (this.current) {
                default: {
                    return;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
            }
            this.read();
        }
    }

    protected void skipCommaSpaces() {
        block6: while (true) {
            switch (this.current) {
                default: {
                    break block6;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.read();
                    continue block6;
                }
            }
            break;
        }
        if (this.current == 44) {
            block7: while (true) {
                this.read();
                switch (this.current) {
                    default: {
                        break block7;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        continue block7;
                    }
                }
                break;
            }
        }
    }

    public abstract void parse(Reader var1) throws ParseException;
}

