/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.io.Reader;
import org.apache.batik.parser.DefaultTransformListHandler;
import org.apache.batik.parser.NumberParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.TransformListHandler;

public class TransformListParser
extends NumberParser {
    protected TransformListHandler transformListHandler = DefaultTransformListHandler.INSTANCE;

    public void setTransformListHandler(TransformListHandler transformListHandler) {
        this.transformListHandler = transformListHandler;
    }

    public TransformListHandler getTransformListHandler() {
        return this.transformListHandler;
    }

    public void parse(Reader reader) throws ParseException {
        this.initialize(reader);
        this.transformListHandler.startTransformList();
        block11: while (true) {
            this.read();
            switch (this.current) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 44: {
                    continue block11;
                }
                case 109: {
                    this.parseMatrix();
                    continue block11;
                }
                case 114: {
                    this.parseRotate();
                    continue block11;
                }
                case 116: {
                    this.parseTranslate();
                    continue block11;
                }
                case 115: {
                    this.read();
                    switch (this.current) {
                        case 99: {
                            this.parseScale();
                            continue block11;
                        }
                        case 107: {
                            this.parseSkew();
                            continue block11;
                        }
                    }
                    this.reportError("character.unexpected", new Object[]{new Integer(this.current)});
                    this.skipTransform();
                    continue block11;
                }
            }
            if (this.current == -1) break;
            this.reportError("character.unexpected", new Object[]{new Integer(this.current)});
            this.skipTransform();
        }
        this.skipSpaces();
        if (this.current != -1) {
            this.reportError("end.of.stream.expected", new Object[]{new Integer(this.current)});
        }
        this.transformListHandler.endTransformList();
    }

    protected void parseMatrix() throws ParseException {
        this.read();
        if (this.current != 97) {
            this.reportError("character.expected", new Object[]{new Character('a'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 116) {
            this.reportError("character.expected", new Object[]{new Character('t'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 114) {
            this.reportError("character.expected", new Object[]{new Character('r'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 105) {
            this.reportError("character.expected", new Object[]{new Character('i'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 120) {
            this.reportError("character.expected", new Object[]{new Character('x'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        this.skipSpaces();
        if (this.current != 40) {
            this.reportError("character.expected", new Object[]{new Character('('), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        this.skipSpaces();
        try {
            float f = this.parseFloat();
            this.skipCommaSpaces();
            float f2 = this.parseFloat();
            this.skipCommaSpaces();
            float f3 = this.parseFloat();
            this.skipCommaSpaces();
            float f4 = this.parseFloat();
            this.skipCommaSpaces();
            float f5 = this.parseFloat();
            this.skipCommaSpaces();
            float f6 = this.parseFloat();
            this.skipSpaces();
            if (this.current != 41) {
                this.reportError("character.expected", new Object[]{new Character(')'), new Integer(this.current)});
                this.skipTransform();
                return;
            }
            this.transformListHandler.matrix(f, f2, f3, f4, f5, f6);
        }
        catch (NumberFormatException numberFormatException) {
            this.reportError("float.format", new Object[]{this.getBufferContent()});
            this.skipTransform();
        }
    }

    protected void parseRotate() throws ParseException {
        this.read();
        if (this.current != 111) {
            this.reportError("character.expected", new Object[]{new Character('o'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 116) {
            this.reportError("character.expected", new Object[]{new Character('t'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 97) {
            this.reportError("character.expected", new Object[]{new Character('a'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 116) {
            this.reportError("character.expected", new Object[]{new Character('t'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 101) {
            this.reportError("character.expected", new Object[]{new Character('e'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        this.skipSpaces();
        if (this.current != 40) {
            this.reportError("character.expected", new Object[]{new Character('('), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        this.skipSpaces();
        try {
            float f = this.parseFloat();
            this.skipSpaces();
            switch (this.current) {
                case 41: {
                    this.transformListHandler.rotate(f);
                    return;
                }
                case 44: {
                    this.read();
                    this.skipSpaces();
                }
            }
            float f2 = this.parseFloat();
            this.skipCommaSpaces();
            float f3 = this.parseFloat();
            this.skipSpaces();
            if (this.current != 41) {
                this.reportError("character.expected", new Object[]{new Character(')'), new Integer(this.current)});
                this.skipTransform();
                return;
            }
            this.transformListHandler.rotate(f, f2, f3);
        }
        catch (NumberFormatException numberFormatException) {
            this.reportError("float.format", new Object[]{this.getBufferContent()});
            this.skipTransform();
        }
    }

    protected void parseTranslate() throws ParseException {
        this.read();
        if (this.current != 114) {
            this.reportError("character.expected", new Object[]{new Character('r'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 97) {
            this.reportError("character.expected", new Object[]{new Character('a'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 110) {
            this.reportError("character.expected", new Object[]{new Character('n'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 115) {
            this.reportError("character.expected", new Object[]{new Character('s'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 108) {
            this.reportError("character.expected", new Object[]{new Character('l'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 97) {
            this.reportError("character.expected", new Object[]{new Character('a'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 116) {
            this.reportError("character.expected", new Object[]{new Character('t'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 101) {
            this.reportError("character.expected", new Object[]{new Character('e'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        this.skipSpaces();
        if (this.current != 40) {
            this.reportError("character.expected", new Object[]{new Character('('), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        this.skipSpaces();
        try {
            float f = this.parseFloat();
            this.skipSpaces();
            switch (this.current) {
                case 41: {
                    this.transformListHandler.translate(f);
                    return;
                }
                case 44: {
                    this.read();
                    this.skipSpaces();
                }
            }
            float f2 = this.parseFloat();
            this.skipSpaces();
            if (this.current != 41) {
                this.reportError("character.expected", new Object[]{new Character(')'), new Integer(this.current)});
                this.skipTransform();
                return;
            }
            this.transformListHandler.translate(f, f2);
        }
        catch (NumberFormatException numberFormatException) {
            this.reportError("float.format", new Object[]{this.getBufferContent()});
            this.skipTransform();
        }
    }

    protected void parseScale() throws ParseException {
        this.read();
        if (this.current != 97) {
            this.reportError("character.expected", new Object[]{new Character('a'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 108) {
            this.reportError("character.expected", new Object[]{new Character('l'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 101) {
            this.reportError("character.expected", new Object[]{new Character('e'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        this.skipSpaces();
        if (this.current != 40) {
            this.reportError("character.expected", new Object[]{new Character('('), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        this.skipSpaces();
        try {
            float f = this.parseFloat();
            this.skipSpaces();
            switch (this.current) {
                case 41: {
                    this.transformListHandler.scale(f);
                    return;
                }
                case 44: {
                    this.read();
                    this.skipSpaces();
                }
            }
            float f2 = this.parseFloat();
            this.skipSpaces();
            if (this.current != 41) {
                this.reportError("character.expected", new Object[]{new Character(')'), new Integer(this.current)});
                this.skipTransform();
                return;
            }
            this.transformListHandler.scale(f, f2);
        }
        catch (NumberFormatException numberFormatException) {
            this.reportError("float.format", new Object[]{this.getBufferContent()});
            this.skipTransform();
        }
    }

    protected void parseSkew() throws ParseException {
        this.read();
        if (this.current != 101) {
            this.reportError("character.expected", new Object[]{new Character('e'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        if (this.current != 119) {
            this.reportError("character.expected", new Object[]{new Character('w'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        boolean bl = false;
        switch (this.current) {
            case 88: {
                bl = true;
            }
            case 89: {
                break;
            }
            default: {
                this.reportError("character.expected", new Object[]{new Character('X'), new Integer(this.current)});
                this.skipTransform();
                return;
            }
        }
        this.read();
        this.skipSpaces();
        if (this.current != 40) {
            this.reportError("character.expected", new Object[]{new Character('('), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.read();
        this.skipSpaces();
        try {
            float f = this.parseFloat();
            this.skipSpaces();
            if (this.current != 41) {
                this.reportError("character.expected", new Object[]{new Character(')'), new Integer(this.current)});
                this.skipTransform();
                return;
            }
            if (bl) {
                this.transformListHandler.skewX(f);
            } else {
                this.transformListHandler.skewY(f);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.reportError("float.format", new Object[]{this.getBufferContent()});
            this.skipTransform();
        }
    }

    protected void skipTransform() {
        block3: while (true) {
            this.read();
            switch (this.current) {
                case 41: {
                    break block3;
                }
                default: {
                    if (this.current != -1) continue block3;
                    break block3;
                }
            }
            break;
        }
    }

    protected void readNumber() throws ParseException {
        this.bufferSize = 0;
        this.bufferize();
        while (true) {
            this.read();
            switch (this.current) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 41: 
                case 44: {
                    return;
                }
            }
            if (this.current == -1) {
                this.reportError("end.of.stream", new Object[0]);
                this.skipTransform();
                return;
            }
            this.bufferize();
        }
    }
}

