/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.AlphaComposite;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.SVGCompositeDescriptor;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.w3c.dom.Element;

public class SVGAlphaComposite
extends AbstractSVGConverter {
    private Map compositeDefsMap = new HashMap();
    private boolean backgroundAccessRequired = false;

    public SVGAlphaComposite(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
        this.compositeDefsMap.put(AlphaComposite.Src, this.compositeToSVG(AlphaComposite.Src));
        this.compositeDefsMap.put(AlphaComposite.SrcIn, this.compositeToSVG(AlphaComposite.SrcIn));
        this.compositeDefsMap.put(AlphaComposite.SrcOut, this.compositeToSVG(AlphaComposite.SrcOut));
        this.compositeDefsMap.put(AlphaComposite.DstIn, this.compositeToSVG(AlphaComposite.DstIn));
        this.compositeDefsMap.put(AlphaComposite.DstOut, this.compositeToSVG(AlphaComposite.DstOut));
        this.compositeDefsMap.put(AlphaComposite.DstOver, this.compositeToSVG(AlphaComposite.DstOver));
        this.compositeDefsMap.put(AlphaComposite.Clear, this.compositeToSVG(AlphaComposite.Clear));
    }

    public List getAlphaCompositeFilterSet() {
        return new LinkedList(this.compositeDefsMap.values());
    }

    public boolean requiresBackgroundAccess() {
        return this.backgroundAccessRequired;
    }

    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        return this.toSVG((AlphaComposite)graphicContext.getComposite());
    }

    public SVGCompositeDescriptor toSVG(AlphaComposite alphaComposite) {
        SVGCompositeDescriptor sVGCompositeDescriptor = (SVGCompositeDescriptor)this.descMap.get(alphaComposite);
        if (sVGCompositeDescriptor == null) {
            String string = AbstractSVGConverter.doubleString(alphaComposite.getAlpha());
            String string2 = null;
            Element element = null;
            if (alphaComposite.getRule() != 3) {
                AlphaComposite alphaComposite2 = AlphaComposite.getInstance(alphaComposite.getRule());
                element = (Element)this.compositeDefsMap.get(alphaComposite2);
                this.defSet.add(element);
                StringBuffer stringBuffer = new StringBuffer("url(");
                stringBuffer.append("#");
                stringBuffer.append(element.getAttributeNS(null, "id"));
                stringBuffer.append(")");
                string2 = stringBuffer.toString();
            } else {
                string2 = "none";
            }
            sVGCompositeDescriptor = new SVGCompositeDescriptor(string, string2, element);
            this.descMap.put(alphaComposite, sVGCompositeDescriptor);
        }
        if (alphaComposite.getRule() != 3) {
            this.backgroundAccessRequired = true;
        }
        return sVGCompositeDescriptor;
    }

    private Element compositeToSVG(AlphaComposite alphaComposite) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "0";
        String string5 = null;
        switch (alphaComposite.getRule()) {
            case 1: {
                string = "arithmetic";
                string2 = "SourceGraphic";
                string3 = "BackgroundImage";
                string5 = "alphaCompositeClear";
                break;
            }
            case 2: {
                string = "arithmetic";
                string2 = "SourceGraphic";
                string3 = "BackgroundImage";
                string5 = "alphaCompositeSrc";
                string4 = "1";
                break;
            }
            case 5: {
                string = "in";
                string2 = "SourceGraphic";
                string3 = "BackgroundImage";
                string5 = "alphaCompositeSrcIn";
                break;
            }
            case 7: {
                string = "out";
                string2 = "SourceGraphic";
                string3 = "BackgroundImage";
                string5 = "alphaCompositeSrcOut";
                break;
            }
            case 6: {
                string = "in";
                string3 = "SourceGraphic";
                string2 = "BackgroundImage";
                string5 = "alphaCompositeDstIn";
                break;
            }
            case 8: {
                string = "out";
                string3 = "SourceGraphic";
                string2 = "BackgroundImage";
                string5 = "alphaCompositeDstOut";
                break;
            }
            case 4: {
                string = "over";
                string3 = "SourceGraphic";
                string2 = "BackgroundImage";
                string5 = "alphaCompositeDstOver";
                break;
            }
            default: {
                throw new Error();
            }
        }
        Element element = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "filter");
        element.setAttributeNS(null, "id", string5);
        element.setAttributeNS(null, "filterUnits", "objectBoundingBox");
        element.setAttributeNS(null, "x", "0%");
        element.setAttributeNS(null, "y", "0%");
        element.setAttributeNS(null, "width", "100%");
        element.setAttributeNS(null, "height", "100%");
        Element element2 = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "feComposite");
        element2.setAttributeNS(null, "operator", string);
        element2.setAttributeNS(null, "in", string2);
        element2.setAttributeNS(null, "in2", string3);
        element2.setAttributeNS(null, "k2", string4);
        element2.setAttributeNS(null, "result", "composite");
        Element element3 = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "feFlood");
        element3.setAttributeNS(null, "flood-color", "white");
        element3.setAttributeNS(null, "flood-opacity", "1");
        element3.setAttributeNS(null, "result", "flood");
        Element element4 = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "feMerge");
        Element element5 = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "feMergeNode");
        element5.setAttributeNS(null, "in", "flood");
        Element element6 = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "feMergeNode");
        element6.setAttributeNS(null, "in", "composite");
        element4.appendChild(element5);
        element4.appendChild(element6);
        element.appendChild(element3);
        element.appendChild(element2);
        element.appendChild(element4);
        return element;
    }
}

