/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.Selectable;
import org.apache.batik.gvt.event.AWTEventDispatcher;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseListener;
import org.apache.batik.gvt.event.SelectionEvent;
import org.apache.batik.gvt.event.SelectionListener;
import org.apache.batik.gvt.text.ConcreteTextSelector;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.gvt.Overlay;

public class TextSelectionManager {
    public static final Cursor TEXT_CURSOR = new Cursor(2);
    protected ConcreteTextSelector textSelector;
    protected JGVTComponent component;
    protected Overlay selectionOverlay = new SelectionOverlay();
    protected GraphicsNode gvtRoot;
    protected MouseListener mouseListener;
    protected Cursor previousCursor;
    protected Shape selectionHighlight;
    protected SelectionListener textSelectionListener;
    static final Color fillColor = new Color(200, 200, 200, 100);
    static final Color strokeColor = new Color(0, 0, 0, 255);

    public TextSelectionManager(JGVTComponent jGVTComponent, AWTEventDispatcher aWTEventDispatcher) {
        this.textSelector = new ConcreteTextSelector();
        this.textSelectionListener = new TextSelectionListener();
        this.textSelector.addSelectionListener(this.textSelectionListener);
        this.mouseListener = new MouseListener();
        this.component = jGVTComponent;
        this.component.getOverlays().add(this.selectionOverlay);
        aWTEventDispatcher.addGraphicsNodeMouseListener(this.mouseListener);
    }

    public Overlay getSelectionOverlay() {
        return this.selectionOverlay;
    }

    protected Rectangle outset(Rectangle rectangle, int n) {
        rectangle.x -= n;
        rectangle.y -= n;
        rectangle.width += 2 * n;
        rectangle.height += 2 * n;
        return rectangle;
    }

    protected Rectangle getHighlightBounds() {
        AffineTransform affineTransform = this.component.getRenderingTransform();
        Shape shape = affineTransform.createTransformedShape(this.selectionHighlight);
        return this.outset(shape.getBounds(), 1);
    }

    protected class SelectionOverlay
    implements Overlay {
        protected SelectionOverlay() {
        }

        public void paint(Graphics graphics) {
            if (TextSelectionManager.this.selectionHighlight != null) {
                AffineTransform affineTransform = TextSelectionManager.this.component.getRenderingTransform();
                Shape shape = affineTransform.createTransformedShape(TextSelectionManager.this.selectionHighlight);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(fillColor);
                graphics2D.fill(shape);
                graphics2D.setStroke(new BasicStroke(2.0f));
                graphics2D.setColor(strokeColor);
                graphics2D.draw(shape);
            }
        }
    }

    protected class TextSelectionListener
    implements SelectionListener {
        protected TextSelectionListener() {
        }

        public void selectionDone(SelectionEvent selectionEvent) {
            this.selectionChanged(selectionEvent);
        }

        public void selectionCleared(SelectionEvent selectionEvent) {
            this.selectionStarted(selectionEvent);
        }

        public void selectionStarted(SelectionEvent selectionEvent) {
            if (TextSelectionManager.this.selectionHighlight != null) {
                Rectangle rectangle = TextSelectionManager.this.getHighlightBounds();
                TextSelectionManager.this.selectionHighlight = null;
                TextSelectionManager.this.component.paintImmediately(rectangle);
            }
        }

        public void selectionChanged(SelectionEvent selectionEvent) {
            Rectangle rectangle = null;
            AffineTransform affineTransform = TextSelectionManager.this.component.getRenderingTransform();
            if (TextSelectionManager.this.selectionHighlight != null) {
                rectangle = affineTransform.createTransformedShape(TextSelectionManager.this.selectionHighlight).getBounds();
                TextSelectionManager.this.outset(rectangle, 1);
            }
            TextSelectionManager.this.selectionHighlight = selectionEvent.getHighlightShape();
            if (TextSelectionManager.this.selectionHighlight != null) {
                if (rectangle != null) {
                    Rectangle rectangle2 = TextSelectionManager.this.getHighlightBounds();
                    TextSelectionManager.this.component.paintImmediately(rectangle.union(rectangle2));
                } else {
                    TextSelectionManager.this.component.paintImmediately(TextSelectionManager.this.getHighlightBounds());
                }
            } else if (rectangle != null) {
                TextSelectionManager.this.component.paintImmediately(rectangle);
            }
        }
    }

    protected class MouseListener
    implements GraphicsNodeMouseListener {
        protected MouseListener() {
        }

        public void mouseClicked(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            if (graphicsNodeMouseEvent.getSource() instanceof Selectable) {
                TextSelectionManager.this.textSelector.mouseClicked(graphicsNodeMouseEvent);
            }
        }

        public void mousePressed(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            if (graphicsNodeMouseEvent.getSource() instanceof Selectable) {
                TextSelectionManager.this.textSelector.mousePressed(graphicsNodeMouseEvent);
            } else if (TextSelectionManager.this.selectionHighlight != null) {
                Rectangle rectangle = TextSelectionManager.this.getHighlightBounds();
                TextSelectionManager.this.selectionHighlight = null;
                TextSelectionManager.this.component.paintImmediately(rectangle);
            }
        }

        public void mouseReleased(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            if (graphicsNodeMouseEvent.getSource() instanceof Selectable) {
                TextSelectionManager.this.textSelector.mouseReleased(graphicsNodeMouseEvent);
            }
        }

        public void mouseEntered(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            if (graphicsNodeMouseEvent.getSource() instanceof Selectable) {
                TextSelectionManager.this.textSelector.mouseEntered(graphicsNodeMouseEvent);
                TextSelectionManager.this.previousCursor = TextSelectionManager.this.component.getCursor();
                if (TextSelectionManager.this.previousCursor.getType() == 0) {
                    TextSelectionManager.this.component.setCursor(TEXT_CURSOR);
                }
            }
        }

        public void mouseExited(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            if (graphicsNodeMouseEvent.getSource() instanceof Selectable) {
                TextSelectionManager.this.textSelector.mouseExited(graphicsNodeMouseEvent);
                if (TextSelectionManager.this.component.getCursor() == TEXT_CURSOR) {
                    TextSelectionManager.this.component.setCursor(TextSelectionManager.this.previousCursor);
                }
            }
        }

        public void mouseDragged(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            if (graphicsNodeMouseEvent.getSource() instanceof Selectable) {
                TextSelectionManager.this.textSelector.mouseDragged(graphicsNodeMouseEvent);
            }
        }

        public void mouseMoved(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            if (graphicsNodeMouseEvent.getSource() instanceof Selectable) {
                TextSelectionManager.this.textSelector.mouseMoved(graphicsNodeMouseEvent);
            }
        }
    }
}

