/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.svg.GVTTreeBuilder;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.LinkActivationEvent;
import org.apache.batik.swing.svg.LinkActivationListener;
import org.apache.batik.swing.svg.SVGDocumentLoader;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class JSVGComponent
extends JGVTComponent {
    protected SVGDocumentLoader documentLoader;
    protected SVGDocumentLoader nextDocumentLoader;
    protected DocumentLoader loader;
    protected GVTTreeBuilder gvtTreeBuilder;
    protected GVTTreeBuilder nextGVTTreeBuilder;
    protected SVGDocument svgDocument;
    protected List svgDocumentLoaderListeners = new LinkedList();
    protected List gvtTreeBuilderListeners = new LinkedList();
    protected List linkActivationListeners = new LinkedList();
    protected UserAgent userAgent;
    protected SVGUserAgent svgUserAgent;
    protected BridgeContext bridgeContext;
    protected String fragmentIdentifier;
    protected static final Set FEATURES = new HashSet();

    public JSVGComponent() {
        this(null, false, false);
    }

    public JSVGComponent(SVGUserAgent sVGUserAgent, boolean bl, boolean bl2) {
        super(bl, bl2);
        this.svgUserAgent = sVGUserAgent;
        this.userAgent = this.createUserAgent();
        this.addSVGDocumentLoaderListener((SVGListener)this.listener);
        this.addGVTTreeBuilderListener((SVGListener)this.listener);
    }

    public void stopProcessing() {
        this.nextDocumentLoader = null;
        this.nextGVTTreeBuilder = null;
        if (this.documentLoader != null) {
            this.documentLoader.interrupt();
        } else if (this.gvtTreeBuilder != null) {
            this.gvtTreeBuilder.interrupt();
        } else {
            super.stopProcessing();
        }
    }

    public void loadSVGDocument(String string) {
        this.stopProcessing();
        URL uRL = null;
        if (this.svgDocument != null) {
            uRL = ((SVGOMDocument)this.svgDocument).getURLObject();
        }
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            this.userAgent.displayError(malformedURLException);
            return;
        }
        string = uRL2.toString();
        this.fragmentIdentifier = uRL2.getRef();
        this.loader = new DocumentLoader(this.userAgent);
        this.nextDocumentLoader = new SVGDocumentLoader(string, this.loader);
        this.nextDocumentLoader.setPriority(1);
        Iterator iterator = this.svgDocumentLoaderListeners.iterator();
        while (iterator.hasNext()) {
            this.nextDocumentLoader.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)iterator.next());
        }
        if (this.documentLoader == null && this.gvtTreeBuilder == null && this.gvtTreeRenderer == null) {
            this.startDocumentLoader();
        }
    }

    private void startDocumentLoader() {
        this.documentLoader = this.nextDocumentLoader;
        this.nextDocumentLoader = null;
        this.documentLoader.start();
    }

    public void setSVGDocument(SVGDocument sVGDocument) {
        Object object;
        this.stopProcessing();
        if (!(sVGDocument.getImplementation() instanceof SVGDOMImplementation)) {
            throw new IllegalArgumentException("Invalid DOM implementation.");
        }
        if (this.eventsEnabled && this.svgDocument != null) {
            object = this.svgDocument.createEvent("SVGEvents");
            object.initEvent("SVGUnload", false, false);
            this.svgDocument.getRootElement().dispatchEvent((Event)object);
        }
        this.svgDocument = sVGDocument;
        object = sVGDocument.getDocumentElement();
        String string = object.getAttributeNS(null, "zoomAndPan");
        this.disableInteractions = !string.equals("magnify");
        this.bridgeContext = this.createBridgeContext();
        this.nextGVTTreeBuilder = new GVTTreeBuilder(sVGDocument, this.bridgeContext);
        this.nextGVTTreeBuilder.setPriority(1);
        Iterator iterator = this.gvtTreeBuilderListeners.iterator();
        while (iterator.hasNext()) {
            this.nextGVTTreeBuilder.addGVTTreeBuilderListener((GVTTreeBuilderListener)iterator.next());
        }
        this.releaseRenderingReferences();
        this.initializeEventHandling();
        if (this.gvtTreeBuilder == null && this.documentLoader == null && this.gvtTreeRenderer == null) {
            this.startGVTTreeBuilder();
        }
    }

    private void startGVTTreeBuilder() {
        this.gvtTreeBuilder = this.nextGVTTreeBuilder;
        this.nextGVTTreeBuilder = null;
        this.gvtTreeBuilder.start();
    }

    public SVGDocument getSVGDocument() {
        return this.svgDocument;
    }

    public Dimension2D getSVGDocumentSize() {
        return this.bridgeContext.getDocumentSize();
    }

    public String getFragmentIdentifier() {
        return this.fragmentIdentifier;
    }

    public void setFragmentIdentifier(String string) {
        this.fragmentIdentifier = string;
        this.computeRenderingTransform();
    }

    protected BridgeContext createBridgeContext() {
        if (this.loader == null) {
            this.loader = new DocumentLoader(this.userAgent);
        }
        return new BridgeContext(this.userAgent, this.loader);
    }

    protected void computeRenderingTransform() {
        try {
            if (this.svgDocument != null) {
                SVGSVGElement sVGSVGElement = this.svgDocument.getRootElement();
                Dimension dimension = this.getSize();
                this.setRenderingTransform(ViewBox.getViewTransform(this.fragmentIdentifier, sVGSVGElement, dimension.width, dimension.height));
                this.initialTransform = this.renderingTransform;
            }
        }
        catch (BridgeException bridgeException) {
            this.userAgent.displayError(bridgeException);
        }
    }

    protected void updateRenderingTransform() {
        if (this.initialTransform == this.renderingTransform) {
            this.computeRenderingTransform();
        }
    }

    protected void handleException(Exception exception) {
        this.userAgent.displayError(exception);
    }

    public void addSVGDocumentLoaderListener(SVGDocumentLoaderListener sVGDocumentLoaderListener) {
        this.svgDocumentLoaderListeners.add(sVGDocumentLoaderListener);
    }

    public void removeSVGDocumentLoaderListener(SVGDocumentLoaderListener sVGDocumentLoaderListener) {
        this.svgDocumentLoaderListeners.remove(sVGDocumentLoaderListener);
    }

    public void addGVTTreeBuilderListener(GVTTreeBuilderListener gVTTreeBuilderListener) {
        this.gvtTreeBuilderListeners.add(gVTTreeBuilderListener);
    }

    public void removeGVTTreeBuilderListener(GVTTreeBuilderListener gVTTreeBuilderListener) {
        this.gvtTreeBuilderListeners.remove(gVTTreeBuilderListener);
    }

    public void addLinkActivationListener(LinkActivationListener linkActivationListener) {
        this.linkActivationListeners.add(linkActivationListener);
    }

    public void removeLinkActivationListener(LinkActivationListener linkActivationListener) {
        this.linkActivationListeners.remove(linkActivationListener);
    }

    protected JGVTComponent.Listener createListener() {
        return new SVGListener();
    }

    protected UserAgent createUserAgent() {
        return new BridgeUserAgent();
    }

    static {
        FEATURES.add("org.w3c.svg");
        FEATURES.add("org.w3c.svg.lang");
        FEATURES.add("org.w3c.svg.static");
    }

    protected class BridgeUserAgent
    implements UserAgent {
        protected Map extensions = new HashMap();

        protected BridgeUserAgent() {
        }

        public Dimension2D getViewportSize() {
            return JSVGComponent.this.getSize();
        }

        public EventDispatcher getEventDispatcher() {
            return JSVGComponent.this.eventDispatcher;
        }

        public void displayError(String string) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.displayError(string);
            }
        }

        public void displayError(Exception exception) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.displayError(exception);
            }
        }

        public void displayMessage(String string) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.displayMessage(string);
            }
        }

        public float getPixelToMM() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getPixelToMM();
            }
            return 0.26458332f;
        }

        public String getLanguages() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getLanguages();
            }
            return "en";
        }

        public String getUserStyleSheetURI() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getUserStyleSheetURI();
            }
            return null;
        }

        public void openLink(SVGAElement sVGAElement) {
            String string = XLinkSupport.getXLinkShow(sVGAElement);
            String string2 = XLinkSupport.getXLinkHref(sVGAElement);
            if (string.equals("new")) {
                this.fireLinkActivatedEvent(sVGAElement, string2);
                if (JSVGComponent.this.svgUserAgent != null) {
                    URL uRL = ((SVGOMDocument)JSVGComponent.this.svgDocument).getURLObject();
                    URL uRL2 = null;
                    try {
                        uRL2 = new URL(uRL, string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        JSVGComponent.this.userAgent.displayError(malformedURLException);
                        return;
                    }
                    string2 = uRL2.toString();
                    JSVGComponent.this.svgUserAgent.openLink(string2, true);
                } else {
                    JSVGComponent.this.loadSVGDocument(string2);
                }
                return;
            }
            if (JSVGComponent.this.svgDocument != null) {
                URL uRL = ((SVGOMDocument)JSVGComponent.this.svgDocument).getURLObject();
                URL uRL3 = null;
                try {
                    uRL3 = new URL(uRL, string2);
                }
                catch (MalformedURLException malformedURLException) {
                    JSVGComponent.this.userAgent.displayError(malformedURLException);
                    return;
                }
                String string3 = uRL3.getRef();
                if (uRL3.sameFile(uRL)) {
                    if (JSVGComponent.this.fragmentIdentifier == null && string3 != null || string3 == null && JSVGComponent.this.fragmentIdentifier != null || string3 != null && !string3.equals(JSVGComponent.this.fragmentIdentifier)) {
                        JSVGComponent.this.fragmentIdentifier = string3;
                        JSVGComponent.this.computeRenderingTransform();
                    }
                    this.fireLinkActivatedEvent(sVGAElement, uRL3.toString());
                    return;
                }
            }
            this.fireLinkActivatedEvent(sVGAElement, string2);
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.openLink(string2, false);
            } else {
                JSVGComponent.this.loadSVGDocument(string2);
            }
        }

        protected void fireLinkActivatedEvent(SVGAElement sVGAElement, String string) {
            Object[] objectArray = JSVGComponent.this.linkActivationListeners.toArray();
            if (objectArray.length > 0) {
                LinkActivationEvent linkActivationEvent = new LinkActivationEvent(JSVGComponent.this, sVGAElement, string);
                int n = 0;
                while (n < objectArray.length) {
                    LinkActivationListener linkActivationListener = (LinkActivationListener)objectArray[n];
                    linkActivationListener.linkActivated(linkActivationEvent);
                    ++n;
                }
            }
        }

        public void setSVGCursor(Cursor cursor) {
            JSVGComponent.this.setCursor(cursor);
        }

        public String getXMLParserClassName() {
            if (JSVGComponent.this.svgUserAgent != null) {
                return JSVGComponent.this.svgUserAgent.getXMLParserClassName();
            }
            return "org.apache.crimson.parser.XMLReaderImpl";
        }

        public AffineTransform getTransform() {
            return JSVGComponent.this.renderingTransform;
        }

        public Point getClientAreaLocationOnScreen() {
            return JSVGComponent.this.getLocationOnScreen();
        }

        public boolean hasFeature(String string) {
            return FEATURES.contains(string);
        }

        public boolean supportExtension(String string) {
            boolean bl = false;
            if (JSVGComponent.this.svgUserAgent != null && JSVGComponent.this.svgUserAgent.supportExtension(string)) {
                return true;
            }
            return this.extensions.containsKey(string);
        }

        public void registerExtension(BridgeExtension bridgeExtension) {
            Iterator iterator = bridgeExtension.getImplementedExtensions();
            while (iterator.hasNext()) {
                this.extensions.put(iterator.next(), bridgeExtension);
            }
        }

        public void handleElement(Element element, Object object) {
            if (JSVGComponent.this.svgUserAgent != null) {
                JSVGComponent.this.svgUserAgent.handleElement(element, object);
            }
        }
    }

    protected class SVGListener
    extends JGVTComponent.Listener
    implements SVGDocumentLoaderListener,
    GVTTreeBuilderListener {
        protected SVGListener() {
            super(JSVGComponent.this);
        }

        public void documentLoadingStarted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
        }

        public void documentLoadingCompleted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.documentLoader = null;
            JSVGComponent.this.setSVGDocument(sVGDocumentLoaderEvent.getSVGDocument());
        }

        public void documentLoadingCancelled(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.documentLoader = null;
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
        }

        public void documentLoadingFailed(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.documentLoader = null;
            JSVGComponent.this.userAgent.displayError(((SVGDocumentLoader)sVGDocumentLoaderEvent.getSource()).getException());
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
        }

        public void gvtBuildStarted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            JSVGComponent.this.computeRenderingTransform();
        }

        public void gvtBuildCompleted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            JSVGComponent.this.loader = null;
            JSVGComponent.this.gvtTreeBuilder = null;
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.super.setGraphicsNode(gVTTreeBuilderEvent.getGVTRoot(), false);
            Dimension2D dimension2D = JSVGComponent.this.bridgeContext.getDocumentSize();
            JSVGComponent.this.setPreferredSize(new Dimension((int)dimension2D.getWidth(), (int)dimension2D.getHeight()));
            JSVGComponent.this.invalidate();
        }

        public void gvtBuildCancelled(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            JSVGComponent.this.loader = null;
            JSVGComponent.this.gvtTreeBuilder = null;
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            JSVGComponent.this.image = null;
            JSVGComponent.this.repaint();
        }

        public void gvtBuildFailed(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            JSVGComponent.this.loader = null;
            JSVGComponent.this.gvtTreeBuilder = null;
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            GraphicsNode graphicsNode = gVTTreeBuilderEvent.getGVTRoot();
            Dimension2D dimension2D = JSVGComponent.this.bridgeContext.getDocumentSize();
            if (graphicsNode == null || dimension2D == null) {
                JSVGComponent.this.image = null;
                JSVGComponent.this.repaint();
            } else {
                JSVGComponent.super.setGraphicsNode(graphicsNode, false);
                JSVGComponent.this.setPreferredSize(new Dimension((int)dimension2D.getWidth(), (int)dimension2D.getHeight()));
                JSVGComponent.this.invalidate();
            }
            JSVGComponent.this.userAgent.displayError(((GVTTreeBuilder)gVTTreeBuilderEvent.getSource()).getException());
        }

        public void gvtRenderingCompleted(GVTTreeRendererEvent gVTTreeRendererEvent) {
            super.gvtRenderingCompleted(gVTTreeRendererEvent);
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
            if (JSVGComponent.this.eventsEnabled) {
                Event event = JSVGComponent.this.svgDocument.createEvent("SVGEvents");
                event.initEvent("SVGLoad", false, false);
                JSVGComponent.this.svgDocument.getRootElement().dispatchEvent(event);
                ((EventTarget)((Object)JSVGComponent.this.svgDocument)).addEventListener("DOMAttrModified", new MutationListener(JSVGComponent.this.bridgeContext), false);
            }
        }

        public void gvtRenderingCancelled(GVTTreeRendererEvent gVTTreeRendererEvent) {
            super.gvtRenderingCancelled(gVTTreeRendererEvent);
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        public void gvtRenderingFailed(GVTTreeRendererEvent gVTTreeRendererEvent) {
            super.gvtRenderingFailed(gVTTreeRendererEvent);
            if (JSVGComponent.this.nextGVTTreeBuilder != null) {
                JSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (JSVGComponent.this.nextDocumentLoader != null) {
                JSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        protected class MutationListener
        implements EventListener {
            BridgeContext bridgeContext;

            public MutationListener(BridgeContext bridgeContext) {
                this.bridgeContext = bridgeContext;
            }

            public void handleEvent(Event event) {
                Element element = (Element)((Object)event.getTarget());
                BridgeMutationEvent bridgeMutationEvent = new BridgeMutationEvent(element, this.bridgeContext, 0);
                MutationEvent mutationEvent = (MutationEvent)event;
                bridgeMutationEvent.setAttrName(mutationEvent.getAttrName());
                bridgeMutationEvent.setAttrNewValue(mutationEvent.getNewValue());
                GraphicsNodeBridge graphicsNodeBridge = (GraphicsNodeBridge)this.bridgeContext.getBridge(element);
                graphicsNodeBridge.update(bridgeMutationEvent);
            }
        }
    }
}

