/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.codec.PNGEncodeParam;
import org.apache.batik.ext.awt.image.codec.PNGImageEncoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;
import org.apache.batik.transcoder.keys.BooleanKey;

public class PNGTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_FORCE_TRANSPARENT_WHITE = new BooleanKey();

    public PNGTranscoder() {
        this.hints.put(KEY_FORCE_TRANSPARENT_WHITE, new Boolean(false));
    }

    public BufferedImage createImage(int n, int n2) {
        return new BufferedImage(n, n2, 2);
    }

    public void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        OutputStream outputStream = transcoderOutput.getOutputStream();
        if (outputStream == null) {
            throw new TranscoderException(Messages.formatMessage("png.badoutput", null));
        }
        PNGEncodeParam.RGB rGB = (PNGEncodeParam.RGB)PNGEncodeParam.getDefaultEncodeParam(bufferedImage);
        rGB.setBackgroundRGB(new int[]{255, 255, 255});
        rGB.setSRGBIntent(0);
        boolean bl = true;
        if (this.hints.containsKey(KEY_FORCE_TRANSPARENT_WHITE)) {
            bl = (Boolean)this.hints.get(KEY_FORCE_TRANSPARENT_WHITE);
        }
        if (bl) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
            int n3 = ((SinglePixelPackedSampleModel)bufferedImage.getSampleModel()).getScanlineStride();
            int n4 = dataBufferInt.getOffset();
            int[] nArray = dataBufferInt.getBankData()[0];
            int n5 = n4;
            int n6 = n3 - n;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            while (n12 < n2) {
                int n13 = 0;
                while (n13 < n) {
                    n11 = nArray[n5];
                    n7 = n11 >> 24 & 0xFF;
                    n8 = n11 >> 16 & 0xFF;
                    n9 = n11 >> 8 & 0xFF;
                    n10 = n11 & 0xFF;
                    n8 = (255 * (255 - n7) + n7 * n8) / 255;
                    n9 = (255 * (255 - n7) + n7 * n9) / 255;
                    n10 = (255 * (255 - n7) + n7 * n10) / 255;
                    nArray[n5++] = n7 << 24 & 0xFF000000 | n8 << 16 & 0xFF0000 | n9 << 8 & 0xFF00 | n10 & 0xFF;
                    ++n13;
                }
                n5 += n6;
                ++n12;
            }
        }
        try {
            PNGImageEncoder pNGImageEncoder = new PNGImageEncoder(outputStream, rGB);
            pNGImageEncoder.encode(bufferedImage);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new TranscoderException(iOException);
        }
    }
}

