/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.xml.XMLCharacters;

public class XMLUtilities
extends XMLCharacters {
    protected static Map ENCODINGS = new HashMap();

    protected XMLUtilities() {
    }

    public static boolean isXMLSpace(char c) {
        return c <= ' ' && (4294977024L >> c & 1L) != 0L;
    }

    public static boolean isXMLNameFirstCharacter(char c) {
        return (XMLCharacters.NAME_FIRST_CHARACTER[c / 32] & 1 << c % 32) != 0;
    }

    public static boolean isXMLNameCharacter(char c) {
        return (XMLCharacters.NAME_CHARACTER[c / 32] & 1 << c % 32) != 0;
    }

    public static boolean isXMLCharacter(int n) {
        return n >= 65536 && n <= 0x10FFFF || (XMLCharacters.XML_CHARACTER[n / 32] & 1 << n % 32) != 0;
    }

    public static boolean isXMLPublicIdCharacter(char c) {
        return c < '\u0080' && (XMLCharacters.PUBLIC_ID_CHARACTER[c / 32] & 1 << c % 32) != 0;
    }

    public static boolean isXMLVersionCharacter(char c) {
        return c < '\u0080' && (XMLCharacters.VERSION_CHARACTER[c / 32] & 1 << c % 32) != 0;
    }

    public static boolean isXMLAlphabeticCharacter(char c) {
        return c < '\u0080' && (XMLCharacters.ALPHABETIC_CHARACTER[c / 32] & 1 << c % 32) != 0;
    }

    public static Reader createXMLDocumentReader(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 128);
        byte[] byArray = new byte[4];
        int n = pushbackInputStream.read(byArray);
        if (n > 0) {
            pushbackInputStream.unread(byArray, 0, n);
        }
        if (n == 4) {
            switch (byArray[0] & 0xFF) {
                case 0: {
                    if (byArray[1] != 60 || byArray[2] != 0 || byArray[3] != 63) break;
                    return new InputStreamReader((InputStream)pushbackInputStream, "UnicodeBig");
                }
                case 60: {
                    switch (byArray[1] & 0xFF) {
                        case 0: {
                            if (byArray[2] != 63 || byArray[3] != 0) break;
                            return new InputStreamReader((InputStream)pushbackInputStream, "UnicodeLittle");
                        }
                        case 63: {
                            if (byArray[2] != 120 || byArray[3] != 109) break;
                            Reader reader = XMLUtilities.createXMLDeclarationReader(pushbackInputStream, "UTF8");
                            String string = XMLUtilities.getXMLDeclarationEncoding(reader, "UTF8");
                            return new InputStreamReader((InputStream)pushbackInputStream, string);
                        }
                    }
                    break;
                }
                case 76: {
                    if (byArray[1] != 111 || (byArray[2] & 0xFF) != 167 || (byArray[3] & 0xFF) != 148) break;
                    Reader reader = XMLUtilities.createXMLDeclarationReader(pushbackInputStream, "CP037");
                    String string = XMLUtilities.getXMLDeclarationEncoding(reader, "CP037");
                    return new InputStreamReader((InputStream)pushbackInputStream, string);
                }
                case 254: {
                    if ((byArray[1] & 0xFF) != 255) break;
                    return new InputStreamReader((InputStream)pushbackInputStream, "Unicode");
                }
                case 255: {
                    if ((byArray[1] & 0xFF) != 254) break;
                    return new InputStreamReader((InputStream)pushbackInputStream, "Unicode");
                }
            }
        }
        return new InputStreamReader((InputStream)pushbackInputStream, "UTF8");
    }

    protected static Reader createXMLDeclarationReader(PushbackInputStream pushbackInputStream, String string) throws IOException {
        byte[] byArray = new byte[128];
        int n = pushbackInputStream.read(byArray);
        if (n > 0) {
            pushbackInputStream.unread(byArray, 0, n);
        }
        return new InputStreamReader((InputStream)new ByteArrayInputStream(byArray, 4, n), string);
    }

    protected static String getXMLDeclarationEncoding(Reader reader, String string) throws IOException {
        int n = reader.read();
        if (n != 108) {
            return string;
        }
        n = reader.read();
        if (!XMLUtilities.isXMLSpace((char)n)) {
            return string;
        }
        while (XMLUtilities.isXMLSpace((char)(n = reader.read()))) {
        }
        if (n != 118) {
            return string;
        }
        n = reader.read();
        if (n != 101) {
            return string;
        }
        n = reader.read();
        if (n != 114) {
            return string;
        }
        n = reader.read();
        if (n != 115) {
            return string;
        }
        n = reader.read();
        if (n != 105) {
            return string;
        }
        n = reader.read();
        if (n != 111) {
            return string;
        }
        n = reader.read();
        if (n != 110) {
            return string;
        }
        n = reader.read();
        while (XMLUtilities.isXMLSpace((char)n)) {
            n = reader.read();
        }
        if (n != 61) {
            return string;
        }
        while (XMLUtilities.isXMLSpace((char)(n = reader.read()))) {
        }
        if (n != 34 && n != 39) {
            return string;
        }
        char c = (char)n;
        while ((n = reader.read()) != c) {
            if (XMLUtilities.isXMLVersionCharacter((char)n)) continue;
            return string;
        }
        n = reader.read();
        if (!XMLUtilities.isXMLSpace((char)n)) {
            return string;
        }
        while (XMLUtilities.isXMLSpace((char)(n = reader.read()))) {
        }
        if (n != 101) {
            return string;
        }
        n = reader.read();
        if (n != 110) {
            return string;
        }
        n = reader.read();
        if (n != 99) {
            return string;
        }
        n = reader.read();
        if (n != 111) {
            return string;
        }
        n = reader.read();
        if (n != 100) {
            return string;
        }
        n = reader.read();
        if (n != 105) {
            return string;
        }
        n = reader.read();
        if (n != 110) {
            return string;
        }
        n = reader.read();
        if (n != 103) {
            return string;
        }
        n = reader.read();
        while (XMLUtilities.isXMLSpace((char)n)) {
            n = reader.read();
        }
        if (n != 61) {
            return string;
        }
        while (XMLUtilities.isXMLSpace((char)(n = reader.read()))) {
        }
        if (n != 34 && n != 39) {
            return string;
        }
        c = (char)n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = reader.read()) != -1) {
            if (n == c) {
                return XMLUtilities.encodingToJavaEncoding(stringBuffer.toString(), string);
            }
            stringBuffer.append((char)n);
        }
        return string;
    }

    public static String encodingToJavaEncoding(String string, String string2) {
        String string3 = (String)ENCODINGS.get(string.toUpperCase());
        return string3 == null ? string2 : string3;
    }

    static {
        ENCODINGS.put("UTF-8", "UTF8");
        ENCODINGS.put("UTF-16", "Unicode");
        ENCODINGS.put("US-ASCII", "ASCII");
        ENCODINGS.put("ISO-8859-1", "8859_1");
        ENCODINGS.put("ISO-8859-2", "8859_2");
        ENCODINGS.put("ISO-8859-3", "8859_3");
        ENCODINGS.put("ISO-8859-4", "8859_4");
        ENCODINGS.put("ISO-8859-5", "8859_5");
        ENCODINGS.put("ISO-8859-6", "8859_6");
        ENCODINGS.put("ISO-8859-7", "8859_7");
        ENCODINGS.put("ISO-8859-8", "8859_8");
        ENCODINGS.put("ISO-8859-9", "8859_9");
        ENCODINGS.put("ISO-2022-JP", "JIS");
        ENCODINGS.put("WINDOWS-31J", "MS932");
        ENCODINGS.put("EUC-JP", "EUCJIS");
        ENCODINGS.put("GB2312", "GB2312");
        ENCODINGS.put("BIG5", "Big5");
        ENCODINGS.put("EUC-KR", "KSC5601");
        ENCODINGS.put("ISO-2022-KR", "ISO2022KR");
        ENCODINGS.put("KOI8-R", "KOI8_R");
        ENCODINGS.put("EBCDIC-CP-US", "CP037");
        ENCODINGS.put("EBCDIC-CP-CA", "CP037");
        ENCODINGS.put("EBCDIC-CP-NL", "CP037");
        ENCODINGS.put("EBCDIC-CP-WT", "CP037");
        ENCODINGS.put("EBCDIC-CP-DK", "CP277");
        ENCODINGS.put("EBCDIC-CP-NO", "CP277");
        ENCODINGS.put("EBCDIC-CP-FI", "CP278");
        ENCODINGS.put("EBCDIC-CP-SE", "CP278");
        ENCODINGS.put("EBCDIC-CP-IT", "CP280");
        ENCODINGS.put("EBCDIC-CP-ES", "CP284");
        ENCODINGS.put("EBCDIC-CP-GB", "CP285");
        ENCODINGS.put("EBCDIC-CP-FR", "CP297");
        ENCODINGS.put("EBCDIC-CP-AR1", "CP420");
        ENCODINGS.put("EBCDIC-CP-HE", "CP424");
        ENCODINGS.put("EBCDIC-CP-BE", "CP500");
        ENCODINGS.put("EBCDIC-CP-CH", "CP500");
        ENCODINGS.put("EBCDIC-CP-ROECE", "CP870");
        ENCODINGS.put("EBCDIC-CP-YU", "CP870");
        ENCODINGS.put("EBCDIC-CP-IS", "CP871");
        ENCODINGS.put("EBCDIC-CP-AR2", "CP918");
        ENCODINGS.put("CP1252", "CP1252");
    }
}

