/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public abstract class InputHandler {
    protected static XMLReader createParser() throws FOPException {
        String string = Driver.getParserClassName();
        MessageHandler.logln("using SAX parser " + string);
        try {
            return (XMLReader)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FOPException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new FOPException("Could not instantiate " + string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FOPException("Could not access " + string, illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            throw new FOPException(String.valueOf(string) + " is not a SAX driver", classCastException);
        }
    }

    public static InputSource fileInputSource(File file) {
        String string = file.getAbsolutePath();
        String string2 = System.getProperty("file.separator");
        if (string2 != null && string2.length() == 1) {
            string = string.replace(string2.charAt(0), '/');
        }
        if (string.length() > 0 && string.charAt(0) != '/') {
            string = String.valueOf('/') + string;
        }
        try {
            return new InputSource(new URL("file", null, string).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    public abstract InputSource getInputSource();

    public abstract XMLReader getParser() throws FOPException;

    public static InputSource urlInputSource(URL uRL) {
        return new InputSource(uRL.toString());
    }
}

